/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.type.converter;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.SqlCustomClass;
import com.hazelcast.sql.impl.expression.RowValue;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import com.hazelcast.sql.impl.type.converter.BigDecimalConverter;
import com.hazelcast.sql.impl.type.converter.BigIntegerConverter;
import com.hazelcast.sql.impl.type.converter.BooleanConverter;
import com.hazelcast.sql.impl.type.converter.ByteConverter;
import com.hazelcast.sql.impl.type.converter.CalendarConverter;
import com.hazelcast.sql.impl.type.converter.CharacterConverter;
import com.hazelcast.sql.impl.type.converter.Converter;
import com.hazelcast.sql.impl.type.converter.Converters;
import com.hazelcast.sql.impl.type.converter.DateConverter;
import com.hazelcast.sql.impl.type.converter.DoubleConverter;
import com.hazelcast.sql.impl.type.converter.FloatConverter;
import com.hazelcast.sql.impl.type.converter.InstantConverter;
import com.hazelcast.sql.impl.type.converter.IntegerConverter;
import com.hazelcast.sql.impl.type.converter.JsonConverter;
import com.hazelcast.sql.impl.type.converter.LocalDateConverter;
import com.hazelcast.sql.impl.type.converter.LocalDateTimeConverter;
import com.hazelcast.sql.impl.type.converter.LocalTimeConverter;
import com.hazelcast.sql.impl.type.converter.LongConverter;
import com.hazelcast.sql.impl.type.converter.MapConverter;
import com.hazelcast.sql.impl.type.converter.NullConverter;
import com.hazelcast.sql.impl.type.converter.ObjectConverter;
import com.hazelcast.sql.impl.type.converter.OffsetDateTimeConverter;
import com.hazelcast.sql.impl.type.converter.RowConverter;
import com.hazelcast.sql.impl.type.converter.ShortConverter;
import com.hazelcast.sql.impl.type.converter.StringConverter;
import com.hazelcast.sql.impl.type.converter.ZonedDateTimeConverter;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class ConvertersTest {
    @Test
    public void testGetById() {
        this.checkId((Converter)StringConverter.INSTANCE, 10);
        this.checkId((Converter)CharacterConverter.INSTANCE, 9);
        this.checkId((Converter)BooleanConverter.INSTANCE, 0);
        this.checkId((Converter)ByteConverter.INSTANCE, 1);
        this.checkId((Converter)ShortConverter.INSTANCE, 2);
        this.checkId((Converter)IntegerConverter.INSTANCE, 3);
        this.checkId((Converter)LongConverter.INSTANCE, 4);
        this.checkId((Converter)BigDecimalConverter.INSTANCE, 6);
        this.checkId((Converter)BigIntegerConverter.INSTANCE, 5);
        this.checkId((Converter)FloatConverter.INSTANCE, 7);
        this.checkId((Converter)DoubleConverter.INSTANCE, 8);
        this.checkId((Converter)LocalTimeConverter.INSTANCE, 14);
        this.checkId((Converter)LocalDateConverter.INSTANCE, 13);
        this.checkId((Converter)LocalDateTimeConverter.INSTANCE, 15);
        this.checkId((Converter)DateConverter.INSTANCE, 11);
        this.checkId((Converter)CalendarConverter.INSTANCE, 12);
        this.checkId((Converter)InstantConverter.INSTANCE, 16);
        this.checkId((Converter)OffsetDateTimeConverter.INSTANCE, 17);
        this.checkId((Converter)ZonedDateTimeConverter.INSTANCE, 18);
        this.checkId((Converter)ObjectConverter.INSTANCE, 19);
        this.checkId((Converter)NullConverter.INSTANCE, 20);
        this.checkId((Converter)MapConverter.INSTANCE, 23);
        this.checkId((Converter)JsonConverter.INSTANCE, 24);
        this.checkId((Converter)RowConverter.INSTANCE, 25);
    }

    @Test
    public void testGetByClass() {
        this.checkClasses((Converter)StringConverter.INSTANCE, String.class);
        this.checkClasses((Converter)CharacterConverter.INSTANCE, Character.TYPE, Character.class);
        this.checkClasses((Converter)BooleanConverter.INSTANCE, Boolean.TYPE, Boolean.class);
        this.checkClasses((Converter)ByteConverter.INSTANCE, Byte.TYPE, Byte.class);
        this.checkClasses((Converter)ShortConverter.INSTANCE, Short.TYPE, Short.class);
        this.checkClasses((Converter)IntegerConverter.INSTANCE, Integer.TYPE, Integer.class);
        this.checkClasses((Converter)LongConverter.INSTANCE, Long.TYPE, Long.class);
        this.checkClasses((Converter)BigDecimalConverter.INSTANCE, BigDecimal.class);
        this.checkClasses((Converter)BigIntegerConverter.INSTANCE, BigInteger.class);
        this.checkClasses((Converter)FloatConverter.INSTANCE, Float.TYPE, Float.class);
        this.checkClasses((Converter)DoubleConverter.INSTANCE, Double.TYPE, Double.class);
        this.checkClasses((Converter)LocalTimeConverter.INSTANCE, LocalTime.class);
        this.checkClasses((Converter)LocalDateConverter.INSTANCE, LocalDate.class);
        this.checkClasses((Converter)LocalDateTimeConverter.INSTANCE, LocalDateTime.class);
        this.checkClasses((Converter)DateConverter.INSTANCE, Date.class);
        this.checkClasses((Converter)CalendarConverter.INSTANCE, Calendar.class, GregorianCalendar.class);
        this.checkClasses((Converter)InstantConverter.INSTANCE, Instant.class);
        this.checkClasses((Converter)OffsetDateTimeConverter.INSTANCE, OffsetDateTime.class);
        this.checkClasses((Converter)ZonedDateTimeConverter.INSTANCE, ZonedDateTime.class);
        this.checkClasses((Converter)ObjectConverter.INSTANCE, Object.class, SqlCustomClass.class);
        this.checkClasses((Converter)NullConverter.INSTANCE, Void.TYPE, Void.class);
        this.checkClasses((Converter)MapConverter.INSTANCE, Map.class, HashMap.class);
        this.checkClasses((Converter)JsonConverter.INSTANCE, HazelcastJsonValue.class);
        this.checkClasses((Converter)RowConverter.INSTANCE, RowValue.class);
    }

    @Test
    public void testTypeFamilies() {
        this.checkFamily((Converter)StringConverter.INSTANCE, QueryDataTypeFamily.VARCHAR);
        this.checkFamily((Converter)CharacterConverter.INSTANCE, QueryDataTypeFamily.VARCHAR);
        this.checkFamily((Converter)BooleanConverter.INSTANCE, QueryDataTypeFamily.BOOLEAN);
        this.checkFamily((Converter)ByteConverter.INSTANCE, QueryDataTypeFamily.TINYINT);
        this.checkFamily((Converter)ShortConverter.INSTANCE, QueryDataTypeFamily.SMALLINT);
        this.checkFamily((Converter)IntegerConverter.INSTANCE, QueryDataTypeFamily.INTEGER);
        this.checkFamily((Converter)LongConverter.INSTANCE, QueryDataTypeFamily.BIGINT);
        this.checkFamily((Converter)BigDecimalConverter.INSTANCE, QueryDataTypeFamily.DECIMAL);
        this.checkFamily((Converter)BigIntegerConverter.INSTANCE, QueryDataTypeFamily.DECIMAL);
        this.checkFamily((Converter)FloatConverter.INSTANCE, QueryDataTypeFamily.REAL);
        this.checkFamily((Converter)DoubleConverter.INSTANCE, QueryDataTypeFamily.DOUBLE);
        this.checkFamily((Converter)LocalTimeConverter.INSTANCE, QueryDataTypeFamily.TIME);
        this.checkFamily((Converter)LocalDateConverter.INSTANCE, QueryDataTypeFamily.DATE);
        this.checkFamily((Converter)LocalDateTimeConverter.INSTANCE, QueryDataTypeFamily.TIMESTAMP);
        this.checkFamily((Converter)DateConverter.INSTANCE, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE);
        this.checkFamily((Converter)CalendarConverter.INSTANCE, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE);
        this.checkFamily((Converter)InstantConverter.INSTANCE, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE);
        this.checkFamily((Converter)OffsetDateTimeConverter.INSTANCE, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE);
        this.checkFamily((Converter)ZonedDateTimeConverter.INSTANCE, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE);
        this.checkFamily((Converter)ObjectConverter.INSTANCE, QueryDataTypeFamily.OBJECT);
        this.checkFamily((Converter)NullConverter.INSTANCE, QueryDataTypeFamily.NULL);
        this.checkFamily((Converter)MapConverter.INSTANCE, QueryDataTypeFamily.MAP);
        this.checkFamily((Converter)JsonConverter.INSTANCE, QueryDataTypeFamily.JSON);
        this.checkFamily((Converter)RowConverter.INSTANCE, QueryDataTypeFamily.ROW);
    }

    @Test
    public void testSerialization() {
        InternalSerializationService ss = new DefaultSerializationServiceBuilder().build();
        for (Converter converter : Converters.getConverters()) {
            Assert.assertSame((Object)converter, (Object)ss.toObject((Object)ss.toData((Object)converter)));
        }
        ss.dispose();
    }

    @Test
    public void testStringConverter() {
        StringConverter converter = StringConverter.INSTANCE;
        this.checkConverterConversions((Converter)converter, QueryDataTypeFamily.BOOLEAN, QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.REAL, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.TIME, QueryDataTypeFamily.DATE, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.OBJECT, QueryDataTypeFamily.JSON);
        Assert.assertEquals((Object)false, (Object)converter.asBoolean((Object)"false"));
        Assert.assertEquals((Object)false, (Object)converter.asBoolean((Object)"False"));
        Assert.assertEquals((Object)true, (Object)converter.asBoolean((Object)"true"));
        Assert.assertEquals((Object)true, (Object)converter.asBoolean((Object)"True"));
        this.checkDataException(() -> converter.asBoolean((Object)"0"));
        this.checkDataException(() -> converter.asBoolean((Object)"1"));
        String invalid = "invalid";
        String bigValue = BigDecimal.valueOf(Long.MAX_VALUE).add(new BigDecimal("1.1")).toPlainString();
        Assert.assertEquals((long)1L, (long)converter.asTinyint((Object)"1"));
        this.checkDataException(() -> converter.asTinyint((Object)invalid));
        this.checkDataException(() -> converter.asTinyint((Object)bigValue));
        Assert.assertEquals((long)1L, (long)converter.asSmallint((Object)"1"));
        this.checkDataException(() -> converter.asSmallint((Object)invalid));
        this.checkDataException(() -> converter.asSmallint((Object)bigValue));
        Assert.assertEquals((long)1L, (long)converter.asInt((Object)"1"));
        this.checkDataException(() -> converter.asInt((Object)invalid));
        this.checkDataException(() -> converter.asInt((Object)bigValue));
        Assert.assertEquals((long)1L, (long)converter.asBigint((Object)"1"));
        this.checkDataException(() -> converter.asBigint((Object)invalid));
        this.checkDataException(() -> converter.asBigint((Object)bigValue));
        Assert.assertEquals((Object)new BigDecimal("1.1"), (Object)converter.asDecimal((Object)"1.1"));
        this.checkDataException(() -> converter.asDecimal((Object)invalid));
        Assert.assertEquals((float)1.1f, (float)converter.asReal((Object)"1.1"), (float)0.0f);
        this.checkDataException(() -> converter.asReal((Object)invalid));
        Assert.assertEquals((double)1.1, (double)converter.asDouble((Object)"1.1"), (double)0.0);
        this.checkDataException(() -> converter.asDouble((Object)invalid));
        Assert.assertEquals((Object)LocalTime.parse("01:02"), (Object)converter.asTime((Object)"1:2"));
        Assert.assertEquals((Object)LocalTime.parse("01:22"), (Object)converter.asTime((Object)"1:22"));
        Assert.assertEquals((Object)LocalTime.parse("11:02"), (Object)converter.asTime((Object)"11:2"));
        Assert.assertEquals((Object)LocalTime.parse("11:22"), (Object)converter.asTime((Object)"11:22"));
        Assert.assertEquals((Object)LocalTime.parse("11:22:33"), (Object)converter.asTime((Object)"11:22:33"));
        Assert.assertEquals((Object)LocalTime.parse("11:22:33.444"), (Object)converter.asTime((Object)"11:22:33.444"));
        Assert.assertEquals((Object)LocalTime.parse("11:22:33.444444444"), (Object)converter.asTime((Object)"11:22:33.444444444"));
        this.checkDataException(() -> converter.asTime((Object)"33:22"));
        this.checkDataException(() -> converter.asTime((Object)"11:66"));
        this.checkDataException(() -> converter.asTime((Object)"11:22:66"));
        this.checkDataException(() -> converter.asTime((Object)"11:22:33.4444444444"));
        this.checkDataException(() -> converter.asTime((Object)invalid));
        Assert.assertEquals((Object)LocalDate.parse("2020-01-01"), (Object)converter.asDate((Object)"2020-01-01"));
        Assert.assertEquals((Object)LocalDate.parse("2020-01-01"), (Object)converter.asDate((Object)"2020-1-01"));
        Assert.assertEquals((Object)LocalDate.parse("2020-01-01"), (Object)converter.asDate((Object)"2020-01-1"));
        Assert.assertEquals((Object)LocalDate.parse("2020-01-01"), (Object)converter.asDate((Object)"2020-1-1"));
        Assert.assertEquals((Object)LocalDate.parse("2020-12-01"), (Object)converter.asDate((Object)"2020-12-1"));
        Assert.assertEquals((Object)LocalDate.parse("2020-01-12"), (Object)converter.asDate((Object)"2020-1-12"));
        Assert.assertEquals((Object)LocalDate.parse("2020-09-12"), (Object)converter.asDate((Object)"2020-09-12"));
        Assert.assertEquals((Object)LocalDate.parse("2020-09-12"), (Object)converter.asDate((Object)"2020-9-12"));
        this.checkDataException(() -> converter.asDate((Object)"2020-13-01"));
        this.checkDataException(() -> converter.asDate((Object)"2020-01-35"));
        this.checkDataException(() -> converter.asDate((Object)"2020-13-1"));
        this.checkDataException(() -> converter.asDate((Object)"2020-1-35"));
        this.checkDataException(() -> converter.asDate((Object)invalid));
        Assert.assertEquals((Object)LocalDateTime.parse("2020-01-01T11:22"), (Object)converter.asTimestamp((Object)"2020-01-01T11:22"));
        Assert.assertEquals((Object)LocalDateTime.parse("2020-01-01T11:22:33"), (Object)converter.asTimestamp((Object)"2020-01-01T11:22:33"));
        Assert.assertEquals((Object)LocalDateTime.parse("2020-01-01T11:22:33.444"), (Object)converter.asTimestamp((Object)"2020-01-01T11:22:33.444"));
        Assert.assertEquals((Object)LocalDateTime.parse("2020-01-01T11:22:33.444444444"), (Object)converter.asTimestamp((Object)"2020-01-01T11:22:33.444444444"));
        this.checkDataException(() -> converter.asTimestamp((Object)"2020-13-01T11:22"));
        this.checkDataException(() -> converter.asTimestamp((Object)"2020-01-35T11:22"));
        this.checkDataException(() -> converter.asTimestamp((Object)"2020-01-01T33:22"));
        this.checkDataException(() -> converter.asTimestamp((Object)"2020-01-01T11:66"));
        this.checkDataException(() -> converter.asTimestamp((Object)"2020-01-01T11:22:66"));
        this.checkDataException(() -> converter.asTimestamp((Object)"2020-01-01T11:22:33.4444444444"));
        this.checkDataException(() -> converter.asTimestamp((Object)invalid));
        Assert.assertEquals((Object)LocalDateTime.parse("2020-01-01T11:22"), (Object)converter.asTimestamp((Object)"2020-01-01 11:22"));
        Assert.assertEquals((Object)LocalDateTime.parse("2020-01-01T11:22:33"), (Object)converter.asTimestamp((Object)"2020-01-01 11:22:33"));
        Assert.assertEquals((Object)LocalDateTime.parse("2020-01-01T11:22:33.444"), (Object)converter.asTimestamp((Object)"2020-01-01 11:22:33.444"));
        Assert.assertEquals((Object)LocalDateTime.parse("2020-01-01T11:22:33.444444444"), (Object)converter.asTimestamp((Object)"2020-01-01 11:22:33.444444444"));
        Assert.assertEquals((Object)LocalDateTime.parse("2020-01-01T11:22"), (Object)converter.asTimestamp((Object)"2020-01-01 11:22"));
        Assert.assertEquals((Object)LocalDateTime.parse("2020-01-01T01:22:33"), (Object)converter.asTimestamp((Object)"2020-01-01 1:22:33"));
        Assert.assertEquals((Object)LocalDateTime.parse("2020-01-01T11:22:33.444"), (Object)converter.asTimestamp((Object)"2020-01-01 11:22:33.444"));
        Assert.assertEquals((Object)LocalDateTime.parse("2020-01-01T11:22:33.444444444"), (Object)converter.asTimestamp((Object)"2020-01-01 11:22:33.444444444"));
        this.checkDataException(() -> converter.asTimestamp((Object)"2020-13-01 11:22"));
        this.checkDataException(() -> converter.asTimestamp((Object)"2020-13-01 11:22"));
        this.checkDataException(() -> converter.asTimestamp((Object)"2020-01-35 11:22"));
        this.checkDataException(() -> converter.asTimestamp((Object)"2020-01-1 33:22"));
        this.checkDataException(() -> converter.asTimestamp((Object)"2020-01-1 11:66"));
        this.checkDataException(() -> converter.asTimestamp((Object)"2020-01-1 T11:22:66"));
        this.checkDataException(() -> converter.asTimestamp((Object)"2020-01-01 11:22:33.4444444444"));
        Assert.assertEquals((Object)OffsetDateTime.parse("2020-01-01T11:22:33.444444444Z"), (Object)converter.asTimestampWithTimezone((Object)"2020-01-01T11:22:33.444444444Z"));
        Assert.assertEquals((Object)OffsetDateTime.parse("2020-01-01T11:22:33.444444444+01:00"), (Object)converter.asTimestampWithTimezone((Object)"2020-01-01T11:22:33.444444444+01:00"));
        this.checkDataException(() -> converter.asTimestampWithTimezone((Object)invalid));
        Assert.assertEquals((Object)"val", (Object)converter.asObject((Object)"val"));
        this.checkConverterSelf((Converter)converter);
    }

    @Test
    public void testCharacterConverter() {
        CharacterConverter converter = CharacterConverter.INSTANCE;
        this.checkConverterConversions((Converter)converter, QueryDataTypeFamily.BOOLEAN, QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.REAL, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.TIME, QueryDataTypeFamily.DATE, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.OBJECT);
        char invalid = 'c';
        Assert.assertEquals((long)1L, (long)converter.asTinyint((Object)Character.valueOf('1')));
        this.checkDataException(() -> converter.asTinyint((Object)Character.valueOf(invalid)));
        Assert.assertEquals((long)1L, (long)converter.asSmallint((Object)Character.valueOf('1')));
        this.checkDataException(() -> converter.asSmallint((Object)Character.valueOf(invalid)));
        Assert.assertEquals((long)1L, (long)converter.asInt((Object)Character.valueOf('1')));
        this.checkDataException(() -> converter.asInt((Object)Character.valueOf(invalid)));
        Assert.assertEquals((long)1L, (long)converter.asBigint((Object)Character.valueOf('1')));
        this.checkDataException(() -> converter.asBigint((Object)Character.valueOf(invalid)));
        Assert.assertEquals((Object)new BigDecimal("1"), (Object)converter.asDecimal((Object)Character.valueOf('1')));
        this.checkDataException(() -> converter.asDecimal((Object)Character.valueOf(invalid)));
        Assert.assertEquals((float)1.0f, (float)converter.asReal((Object)Character.valueOf('1')), (float)0.0f);
        this.checkDataException(() -> converter.asReal((Object)Character.valueOf(invalid)));
        Assert.assertEquals((double)1.0, (double)converter.asDouble((Object)Character.valueOf('1')), (double)0.0);
        this.checkDataException(() -> converter.asDouble((Object)Character.valueOf(invalid)));
        Assert.assertEquals((Object)"c", (Object)converter.asObject((Object)Character.valueOf('c')));
        this.checkConverterSelf((Converter)converter);
    }

    @Test
    public void testBooleanConverter() {
        BooleanConverter converter = BooleanConverter.INSTANCE;
        this.checkConverterConversions((Converter)converter, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.OBJECT);
        Assert.assertEquals((Object)"true", (Object)converter.asVarchar((Object)true));
        Assert.assertEquals((Object)"false", (Object)converter.asVarchar((Object)false));
        Assert.assertEquals((Object)true, (Object)converter.asObject((Object)true));
        this.checkConverterSelf((Converter)converter);
    }

    @Test
    public void testByteConverter() {
        ByteConverter converter = ByteConverter.INSTANCE;
        this.checkConverterConversions((Converter)converter, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.REAL, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.OBJECT);
        Assert.assertEquals((Object)"1", (Object)converter.asVarchar((Object)1));
        Assert.assertEquals((long)1L, (long)converter.asTinyint((Object)1));
        Assert.assertEquals((long)1L, (long)converter.asSmallint((Object)1));
        Assert.assertEquals((long)1L, (long)converter.asInt((Object)1));
        Assert.assertEquals((long)1L, (long)converter.asBigint((Object)1));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)converter.asDecimal((Object)1));
        Assert.assertEquals((float)1.0f, (float)converter.asReal((Object)1), (float)0.0f);
        Assert.assertEquals((double)1.0, (double)converter.asDouble((Object)1), (double)0.0);
        Assert.assertEquals((Object)1, (Object)converter.asObject((Object)1));
        this.checkConverterSelf((Converter)converter);
    }

    @Test
    public void testShortConverter() {
        ShortConverter converter = ShortConverter.INSTANCE;
        this.checkConverterConversions((Converter)converter, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.REAL, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.OBJECT);
        Assert.assertEquals((Object)"1", (Object)converter.asVarchar((Object)1));
        Assert.assertEquals((long)1L, (long)converter.asTinyint((Object)1));
        this.checkDataException(() -> converter.asTinyint((Object)Short.MAX_VALUE));
        Assert.assertEquals((long)1L, (long)converter.asSmallint((Object)1));
        Assert.assertEquals((long)1L, (long)converter.asInt((Object)1));
        Assert.assertEquals((long)1L, (long)converter.asBigint((Object)1));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)converter.asDecimal((Object)1));
        Assert.assertEquals((float)1.0f, (float)converter.asReal((Object)1), (float)0.0f);
        Assert.assertEquals((double)1.0, (double)converter.asDouble((Object)1), (double)0.0);
        Assert.assertEquals((Object)1, (Object)converter.asObject((Object)1));
        this.checkConverterSelf((Converter)converter);
    }

    @Test
    public void testIntConverter() {
        IntegerConverter converter = IntegerConverter.INSTANCE;
        this.checkConverterConversions((Converter)converter, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.REAL, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.OBJECT);
        Assert.assertEquals((Object)"1", (Object)converter.asVarchar((Object)1));
        Assert.assertEquals((long)1L, (long)converter.asTinyint((Object)1));
        this.checkDataException(() -> converter.asTinyint((Object)Integer.MAX_VALUE));
        Assert.assertEquals((long)1L, (long)converter.asSmallint((Object)1));
        this.checkDataException(() -> converter.asSmallint((Object)Integer.MAX_VALUE));
        Assert.assertEquals((long)1L, (long)converter.asInt((Object)1));
        Assert.assertEquals((long)1L, (long)converter.asBigint((Object)1));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)converter.asDecimal((Object)1));
        Assert.assertEquals((float)1.0f, (float)converter.asReal((Object)1), (float)0.0f);
        Assert.assertEquals((double)1.0, (double)converter.asDouble((Object)1), (double)0.0);
        Assert.assertEquals((Object)1, (Object)converter.asObject((Object)1));
        this.checkConverterSelf((Converter)converter);
    }

    @Test
    public void testLongConverter() {
        LongConverter converter = LongConverter.INSTANCE;
        this.checkConverterConversions((Converter)converter, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.REAL, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.OBJECT);
        Assert.assertEquals((Object)"1", (Object)converter.asVarchar((Object)1L));
        Assert.assertEquals((long)1L, (long)converter.asTinyint((Object)1L));
        this.checkDataException(() -> converter.asTinyint((Object)Long.MAX_VALUE));
        Assert.assertEquals((long)1L, (long)converter.asSmallint((Object)1L));
        this.checkDataException(() -> converter.asSmallint((Object)Long.MAX_VALUE));
        Assert.assertEquals((long)1L, (long)converter.asInt((Object)1L));
        this.checkDataException(() -> converter.asInt((Object)Long.MAX_VALUE));
        Assert.assertEquals((long)1L, (long)converter.asBigint((Object)1L));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)converter.asDecimal((Object)1L));
        Assert.assertEquals((float)1.0f, (float)converter.asReal((Object)1L), (float)0.0f);
        Assert.assertEquals((double)1.0, (double)converter.asDouble((Object)1L), (double)0.0);
        Assert.assertEquals((Object)1L, (Object)converter.asObject((Object)1L));
        this.checkConverterSelf((Converter)converter);
    }

    @Test
    public void testBigIntegerConverter() {
        BigIntegerConverter converter = BigIntegerConverter.INSTANCE;
        this.checkConverterConversions((Converter)converter, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.REAL, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.OBJECT);
        BigInteger bigValue = BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE);
        Assert.assertEquals((Object)"1", (Object)converter.asVarchar((Object)BigInteger.ONE));
        Assert.assertEquals((long)1L, (long)converter.asTinyint((Object)BigInteger.ONE));
        this.checkDataException(() -> converter.asTinyint((Object)bigValue));
        Assert.assertEquals((long)1L, (long)converter.asSmallint((Object)BigInteger.ONE));
        this.checkDataException(() -> converter.asSmallint((Object)bigValue));
        Assert.assertEquals((long)1L, (long)converter.asInt((Object)BigInteger.ONE));
        this.checkDataException(() -> converter.asInt((Object)bigValue));
        Assert.assertEquals((long)1L, (long)converter.asBigint((Object)BigInteger.ONE));
        this.checkDataException(() -> converter.asBigint((Object)bigValue));
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)converter.asDecimal((Object)BigInteger.ONE));
        Assert.assertEquals((float)1.0f, (float)converter.asReal((Object)BigInteger.ONE), (float)0.0f);
        Assert.assertEquals((double)1.0, (double)converter.asDouble((Object)BigInteger.ONE), (double)0.0);
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)converter.asObject((Object)BigInteger.ONE));
        this.checkConverterSelf((Converter)converter);
    }

    @Test
    public void testBigDecimalConverter() {
        BigDecimalConverter converter = BigDecimalConverter.INSTANCE;
        this.checkConverterConversions((Converter)converter, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.REAL, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.OBJECT);
        BigDecimal val = BigDecimal.valueOf(11L, 1);
        BigDecimal bigValue = BigDecimal.valueOf(Long.MAX_VALUE).add(new BigDecimal("1.1"));
        Assert.assertEquals((Object)"1.1", (Object)converter.asVarchar((Object)val));
        Assert.assertEquals((long)1L, (long)converter.asTinyint((Object)val));
        this.checkDataException(() -> converter.asTinyint((Object)bigValue));
        Assert.assertEquals((long)1L, (long)converter.asSmallint((Object)val));
        this.checkDataException(() -> converter.asSmallint((Object)bigValue));
        Assert.assertEquals((long)1L, (long)converter.asInt((Object)val));
        this.checkDataException(() -> converter.asInt((Object)bigValue));
        Assert.assertEquals((long)1L, (long)converter.asBigint((Object)val));
        this.checkDataException(() -> converter.asBigint((Object)bigValue));
        Assert.assertEquals((Object)val, (Object)converter.asDecimal((Object)val));
        Assert.assertEquals((float)1.1f, (float)converter.asReal((Object)val), (float)0.0f);
        Assert.assertEquals((double)1.1, (double)converter.asDouble((Object)val), (double)0.0);
        Assert.assertEquals((Object)val, (Object)converter.asObject((Object)val));
        this.checkConverterSelf((Converter)converter);
    }

    @Test
    public void testFloatConverter() {
        FloatConverter converter = FloatConverter.INSTANCE;
        this.checkConverterConversions((Converter)converter, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.OBJECT);
        float val = 1.1f;
        float bigValue = 2.305843E19f;
        Assert.assertEquals((Object)"1.1", (Object)converter.asVarchar((Object)Float.valueOf(val)));
        Assert.assertEquals((long)1L, (long)converter.asTinyint((Object)Float.valueOf(val)));
        this.checkDataException(() -> converter.asTinyint((Object)Float.valueOf(bigValue)));
        this.checkDataException(() -> converter.asTinyint((Object)Float.valueOf(128.0f)));
        this.checkDataException(() -> converter.asTinyint((Object)Float.valueOf(Float.POSITIVE_INFINITY)));
        this.checkDataException(() -> converter.asTinyint((Object)Float.valueOf(Float.NEGATIVE_INFINITY)));
        this.checkDataException(() -> converter.asTinyint((Object)Float.valueOf(Float.NaN)));
        Assert.assertEquals((long)1L, (long)converter.asSmallint((Object)Float.valueOf(val)));
        this.checkDataException(() -> converter.asSmallint((Object)Float.valueOf(bigValue)));
        this.checkDataException(() -> converter.asSmallint((Object)Float.valueOf(32768.0f)));
        this.checkDataException(() -> converter.asSmallint((Object)Float.valueOf(Float.POSITIVE_INFINITY)));
        this.checkDataException(() -> converter.asSmallint((Object)Float.valueOf(Float.NEGATIVE_INFINITY)));
        this.checkDataException(() -> converter.asSmallint((Object)Float.valueOf(Float.NaN)));
        Assert.assertEquals((long)1L, (long)converter.asInt((Object)Float.valueOf(val)));
        this.checkDataException(() -> converter.asInt((Object)Float.valueOf(bigValue)));
        this.checkDataException(() -> converter.asInt((Object)Float.valueOf(2.1474836E9f)));
        this.checkDataException(() -> converter.asInt((Object)Float.valueOf(Float.POSITIVE_INFINITY)));
        this.checkDataException(() -> converter.asInt((Object)Float.valueOf(Float.NEGATIVE_INFINITY)));
        this.checkDataException(() -> converter.asInt((Object)Float.valueOf(Float.NaN)));
        Assert.assertEquals((long)1L, (long)converter.asBigint((Object)Float.valueOf(val)));
        this.checkDataException(() -> converter.asBigint((Object)Float.valueOf(bigValue)));
        this.checkDataException(() -> converter.asBigint((Object)Float.valueOf(9.223372E18f + Math.ulp(9.223372E18f))));
        this.checkDataException(() -> converter.asBigint((Object)Float.valueOf(Float.POSITIVE_INFINITY)));
        this.checkDataException(() -> converter.asBigint((Object)Float.valueOf(Float.NEGATIVE_INFINITY)));
        this.checkDataException(() -> converter.asBigint((Object)Float.valueOf(Float.NaN)));
        Assert.assertEquals((Object)new BigDecimal(val, QueryDataTypeUtils.DECIMAL_MATH_CONTEXT), (Object)converter.asDecimal((Object)Float.valueOf(val)));
        Assert.assertEquals((float)1.1f, (float)converter.asReal((Object)Float.valueOf(val)), (float)0.0f);
        Assert.assertEquals((double)1.1f, (double)converter.asDouble((Object)Float.valueOf(val)), (double)0.0);
        Assert.assertEquals((Object)Float.valueOf(1.1f), (Object)converter.asObject((Object)Float.valueOf(val)));
        this.checkConverterSelf((Converter)converter);
    }

    @Test
    public void testDoubleConverter() {
        DoubleConverter converter = DoubleConverter.INSTANCE;
        this.checkConverterConversions((Converter)converter, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.REAL, QueryDataTypeFamily.OBJECT);
        double val = 1.1;
        double bigValue = 2.305843009213694E19;
        Assert.assertEquals((Object)"1.1", (Object)converter.asVarchar((Object)val));
        Assert.assertEquals((long)1L, (long)converter.asTinyint((Object)val));
        this.checkDataException(() -> converter.asTinyint((Object)bigValue));
        this.checkDataException(() -> converter.asTinyint((Object)128.0));
        this.checkDataException(() -> converter.asTinyint((Object)Double.POSITIVE_INFINITY));
        this.checkDataException(() -> converter.asTinyint((Object)Double.NEGATIVE_INFINITY));
        this.checkDataException(() -> converter.asTinyint((Object)Double.NaN));
        Assert.assertEquals((long)1L, (long)converter.asSmallint((Object)val));
        this.checkDataException(() -> converter.asSmallint((Object)bigValue));
        this.checkDataException(() -> converter.asSmallint((Object)32768.0));
        this.checkDataException(() -> converter.asSmallint((Object)Double.POSITIVE_INFINITY));
        this.checkDataException(() -> converter.asSmallint((Object)Double.NEGATIVE_INFINITY));
        this.checkDataException(() -> converter.asSmallint((Object)Double.NaN));
        Assert.assertEquals((long)1L, (long)converter.asInt((Object)val));
        this.checkDataException(() -> converter.asInt((Object)bigValue));
        this.checkDataException(() -> converter.asInt((Object)2.147483648E9));
        this.checkDataException(() -> converter.asInt((Object)Double.POSITIVE_INFINITY));
        this.checkDataException(() -> converter.asInt((Object)Double.NEGATIVE_INFINITY));
        this.checkDataException(() -> converter.asInt((Object)Double.NaN));
        Assert.assertEquals((long)1L, (long)converter.asBigint((Object)val));
        this.checkDataException(() -> converter.asBigint((Object)bigValue));
        this.checkDataException(() -> converter.asBigint((Object)(9.223372036854776E18 + Math.ulp(9.223372036854776E18))));
        this.checkDataException(() -> converter.asBigint((Object)Double.POSITIVE_INFINITY));
        this.checkDataException(() -> converter.asBigint((Object)Double.NEGATIVE_INFINITY));
        this.checkDataException(() -> converter.asBigint((Object)Double.NaN));
        Assert.assertEquals((Object)new BigDecimal(val, QueryDataTypeUtils.DECIMAL_MATH_CONTEXT), (Object)converter.asDecimal((Object)val));
        Assert.assertEquals((float)1.1f, (float)converter.asReal((Object)val), (float)0.0f);
        Assert.assertEquals((double)1.1, (double)converter.asDouble((Object)val), (double)0.0);
        Assert.assertEquals((Object)1.1, (Object)converter.asObject((Object)val));
        this.checkConverterSelf((Converter)converter);
    }

    @Test
    public void testLocalTimeConverter() {
        LocalTimeConverter converter = LocalTimeConverter.INSTANCE;
        this.checkConverterConversions((Converter)converter, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.OBJECT);
        String timeString = "11:22:33.444";
        LocalTime time = LocalTime.parse(timeString);
        LocalDate date = LocalDate.now();
        LocalDateTime dateTime = LocalDateTime.of(date, time);
        OffsetDateTime globalDateTime = ZonedDateTime.of(dateTime, ZoneId.systemDefault()).toOffsetDateTime();
        Assert.assertEquals((Object)timeString, (Object)converter.asVarchar((Object)time));
        Assert.assertEquals((Object)time, (Object)converter.asTime((Object)time));
        Assert.assertEquals((Object)dateTime, (Object)converter.asTimestamp((Object)time));
        Assert.assertEquals((Object)globalDateTime, (Object)converter.asTimestampWithTimezone((Object)time));
        this.checkConverterSelf((Converter)converter);
    }

    @Test
    public void testLocalDateConverter() {
        LocalDateConverter converter = LocalDateConverter.INSTANCE;
        this.checkConverterConversions((Converter)converter, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.OBJECT);
        String dateString = "2020-02-02";
        LocalDate date = LocalDate.parse(dateString);
        LocalDateTime dateTime = date.atStartOfDay();
        OffsetDateTime globalDateTime = ZonedDateTime.of(dateTime, ZoneId.systemDefault()).toOffsetDateTime();
        Assert.assertEquals((Object)dateString, (Object)converter.asVarchar((Object)date));
        Assert.assertEquals((Object)date, (Object)converter.asDate((Object)date));
        Assert.assertEquals((Object)dateTime, (Object)converter.asTimestamp((Object)date));
        Assert.assertEquals((Object)globalDateTime, (Object)converter.asTimestampWithTimezone((Object)date));
        this.checkConverterSelf((Converter)converter);
    }

    @Test
    public void testLocalDateTimeConverter() {
        LocalDateTimeConverter converter = LocalDateTimeConverter.INSTANCE;
        this.checkConverterConversions((Converter)converter, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.TIME, QueryDataTypeFamily.DATE, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.OBJECT);
        String dateTimeString = "2020-02-02T11:22:33.444";
        LocalDateTime dateTime = LocalDateTime.parse(dateTimeString);
        OffsetDateTime globalDateTime = ZonedDateTime.of(dateTime, ZoneId.systemDefault()).toOffsetDateTime();
        Assert.assertEquals((Object)dateTimeString, (Object)converter.asVarchar((Object)dateTime));
        Assert.assertEquals((Object)dateTime.toLocalDate(), (Object)converter.asDate((Object)dateTime));
        Assert.assertEquals((Object)dateTime.toLocalTime(), (Object)converter.asTime((Object)dateTime));
        Assert.assertEquals((Object)dateTime, (Object)converter.asTimestamp((Object)dateTime));
        Assert.assertEquals((Object)globalDateTime, (Object)converter.asTimestampWithTimezone((Object)dateTime));
        this.checkConverterSelf((Converter)converter);
    }

    @Test
    public void testDateConverter() {
        DateConverter converter = DateConverter.INSTANCE;
        this.checkConverterConversions((Converter)converter, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.TIME, QueryDataTypeFamily.DATE, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.OBJECT);
        Date val = new Date();
        this.checkTimestampWithTimezone((Converter)converter, val, OffsetDateTime.ofInstant(val.toInstant(), ZoneId.systemDefault()));
        this.checkConverterSelf((Converter)converter);
    }

    @Test
    public void testCalendarConverter() {
        CalendarConverter converter = CalendarConverter.INSTANCE;
        this.checkConverterConversions((Converter)converter, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.TIME, QueryDataTypeFamily.DATE, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.OBJECT);
        Calendar val = Calendar.getInstance();
        this.checkTimestampWithTimezone((Converter)converter, val, OffsetDateTime.ofInstant(val.toInstant(), val.getTimeZone().toZoneId()));
        this.checkConverterSelf((Converter)converter);
    }

    @Test
    public void testInstantConverter() {
        InstantConverter converter = InstantConverter.INSTANCE;
        this.checkConverterConversions((Converter)converter, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.TIME, QueryDataTypeFamily.DATE, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.OBJECT);
        Instant val = Instant.now();
        this.checkTimestampWithTimezone((Converter)converter, val, OffsetDateTime.ofInstant(val, ZoneId.systemDefault()));
        this.checkConverterSelf((Converter)converter);
    }

    @Test
    public void testOffsetDateTimeConverter() {
        OffsetDateTimeConverter converter = OffsetDateTimeConverter.INSTANCE;
        this.checkConverterConversions((Converter)converter, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.TIME, QueryDataTypeFamily.DATE, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.OBJECT);
        OffsetDateTime val = OffsetDateTime.now();
        this.checkTimestampWithTimezone((Converter)converter, val, val);
        this.checkConverterSelf((Converter)converter);
    }

    @Test
    public void testZonedDateTimeConverter() {
        ZonedDateTimeConverter converter = ZonedDateTimeConverter.INSTANCE;
        this.checkConverterConversions((Converter)converter, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.TIME, QueryDataTypeFamily.DATE, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.OBJECT);
        ZonedDateTime val = ZonedDateTime.now();
        this.checkTimestampWithTimezone((Converter)converter, val, val.toOffsetDateTime());
        this.checkConverterSelf((Converter)converter);
    }

    @Test
    public void testObjectConverter() {
        ObjectConverter converter = ObjectConverter.INSTANCE;
        this.checkConverterConversions((Converter)converter, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.BOOLEAN, QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.REAL, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.TIME, QueryDataTypeFamily.DATE, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.MAP, QueryDataTypeFamily.JSON, QueryDataTypeFamily.ROW);
        Assert.assertEquals((Object)"c", (Object)converter.asVarchar((Object)Character.valueOf('c')));
        Assert.assertEquals((Object)"val", (Object)converter.asVarchar((Object)"val"));
        Assert.assertEquals((Object)"2020-01-01T11:22:33.444444444", (Object)converter.asVarchar((Object)LocalDateTime.parse("2020-01-01T11:22:33.444444444")));
        Assert.assertEquals((Object)new SqlCustomClass(1).toString(), (Object)converter.asVarchar((Object)new SqlCustomClass(1)));
        Assert.assertEquals((Object)true, (Object)converter.asBoolean((Object)true));
        Assert.assertEquals((Object)true, (Object)converter.asBoolean((Object)"true"));
        Assert.assertEquals((Object)false, (Object)converter.asBoolean((Object)false));
        Assert.assertEquals((Object)false, (Object)converter.asBoolean((Object)"false"));
        this.checkDataException(() -> converter.asBoolean((Object)"1"));
        this.checkDataException(() -> converter.asBoolean((Object)1));
        this.checkDataException(() -> converter.asBoolean(new Object()));
        String invalid = "invalid";
        String bigValue = BigDecimal.valueOf(Long.MAX_VALUE).add(new BigDecimal("1.1")).toPlainString();
        Assert.assertEquals((long)1L, (long)converter.asTinyint((Object)1));
        Assert.assertEquals((long)1L, (long)converter.asTinyint((Object)"1"));
        this.checkDataException(() -> converter.asTinyint((Object)invalid));
        this.checkDataException(() -> converter.asTinyint((Object)bigValue));
        Assert.assertEquals((long)1L, (long)converter.asSmallint((Object)1));
        Assert.assertEquals((long)1L, (long)converter.asSmallint((Object)"1"));
        this.checkDataException(() -> converter.asSmallint((Object)invalid));
        this.checkDataException(() -> converter.asSmallint((Object)bigValue));
        Assert.assertEquals((long)1L, (long)converter.asInt((Object)1));
        Assert.assertEquals((long)1L, (long)converter.asInt((Object)"1"));
        this.checkDataException(() -> converter.asInt((Object)invalid));
        this.checkDataException(() -> converter.asInt((Object)bigValue));
        Assert.assertEquals((long)1L, (long)converter.asBigint((Object)1));
        Assert.assertEquals((long)1L, (long)converter.asBigint((Object)"1"));
        this.checkDataException(() -> converter.asBigint((Object)invalid));
        this.checkDataException(() -> converter.asBigint((Object)bigValue));
        Assert.assertEquals((Object)new BigDecimal("1.1"), (Object)converter.asDecimal((Object)new BigDecimal("1.1")));
        Assert.assertEquals((Object)new BigDecimal("1.1"), (Object)converter.asDecimal((Object)"1.1"));
        this.checkDataException(() -> converter.asDecimal((Object)invalid));
        Assert.assertEquals((float)1.1f, (float)converter.asReal((Object)Float.valueOf(1.1f)), (float)0.0f);
        Assert.assertEquals((float)1.1f, (float)converter.asReal((Object)"1.1"), (float)0.0f);
        this.checkDataException(() -> converter.asReal((Object)invalid));
        Assert.assertEquals((double)1.1, (double)converter.asDouble((Object)1.1), (double)0.0);
        Assert.assertEquals((double)1.1, (double)converter.asDouble((Object)"1.1"), (double)0.0);
        this.checkDataException(() -> converter.asDouble((Object)invalid));
        Assert.assertEquals((Object)LocalTime.parse("11:22"), (Object)converter.asTime((Object)LocalTime.parse("11:22")));
        Assert.assertEquals((Object)LocalTime.parse("11:22"), (Object)converter.asTime((Object)LocalDateTime.parse("2020-01-01T11:22")));
        Assert.assertEquals((Object)LocalTime.parse("11:22"), (Object)converter.asTime((Object)"11:22"));
        this.checkDataException(() -> converter.asTime((Object)invalid));
        Assert.assertEquals((Object)LocalDate.parse("2020-01-01"), (Object)converter.asDate((Object)LocalDate.parse("2020-01-01")));
        Assert.assertEquals((Object)LocalDate.parse("2020-01-01"), (Object)converter.asDate((Object)LocalDateTime.parse("2020-01-01T11:22:33")));
        Assert.assertEquals((Object)LocalDate.parse("2020-01-01"), (Object)converter.asDate((Object)"2020-01-01"));
        this.checkDataException(() -> converter.asDate((Object)invalid));
        Assert.assertEquals((Object)LocalDateTime.parse("2020-01-01T11:22:33.444444444"), (Object)converter.asTimestamp((Object)LocalDateTime.parse("2020-01-01T11:22:33.444444444")));
        Assert.assertEquals((Object)LocalDateTime.parse("2020-01-01T11:22:33.444444444"), (Object)converter.asTimestamp((Object)"2020-01-01T11:22:33.444444444"));
        this.checkDataException(() -> converter.asTimestamp((Object)invalid));
        Assert.assertEquals((Object)OffsetDateTime.parse("2020-01-01T11:22:33.444444444+01:00"), (Object)converter.asTimestampWithTimezone((Object)OffsetDateTime.parse("2020-01-01T11:22:33.444444444+01:00")));
        Assert.assertEquals((Object)OffsetDateTime.parse("2020-01-01T11:22:33.444444444+01:00"), (Object)converter.asTimestampWithTimezone((Object)"2020-01-01T11:22:33.444444444+01:00"));
        this.checkDataException(() -> converter.asTimestampWithTimezone((Object)invalid));
        Assert.assertEquals((Object)"val", (Object)converter.asObject((Object)"val"));
        Assert.assertEquals((Object)1, (Object)converter.asObject((Object)1));
        Assert.assertEquals((Object)new SqlCustomClass(1), (Object)converter.asObject((Object)new SqlCustomClass(1)));
        Assert.assertEquals(Map.of("k", 1), (Object)converter.asMap(Map.of("k", 1)));
        Assert.assertEquals((Object)new HazelcastJsonValue("[1,2,3]"), (Object)converter.asJson((Object)"[1,2,3]"));
        Assert.assertEquals((Object)new RowValue(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))), (Object)converter.asRow((Object)new RowValue(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)))));
        this.checkConverterSelf((Converter)converter);
    }

    @Test
    public void testNullConverter() {
        NullConverter converter = NullConverter.INSTANCE;
        this.checkConverterConversions((Converter)converter, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.BOOLEAN, QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.REAL, QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.TIME, QueryDataTypeFamily.DATE, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.OBJECT, QueryDataTypeFamily.MAP, QueryDataTypeFamily.JSON, QueryDataTypeFamily.ROW);
        this.checkUnsupportedException(() -> converter.asVarchar(null));
        this.checkUnsupportedException(() -> converter.asBoolean(null));
        this.checkUnsupportedException(() -> converter.asTinyint(null));
        this.checkUnsupportedException(() -> converter.asSmallint(null));
        this.checkUnsupportedException(() -> converter.asInt(null));
        this.checkUnsupportedException(() -> converter.asBigint(null));
        this.checkUnsupportedException(() -> converter.asDecimal(null));
        this.checkUnsupportedException(() -> converter.asReal(null));
        this.checkUnsupportedException(() -> converter.asDouble(null));
        this.checkUnsupportedException(() -> converter.asTime(null));
        this.checkUnsupportedException(() -> converter.asDate(null));
        this.checkUnsupportedException(() -> converter.asTimestamp(null));
        this.checkUnsupportedException(() -> converter.asTimestampWithTimezone(null));
        this.checkUnsupportedException(() -> converter.asObject(null));
        this.checkUnsupportedException(() -> converter.asMap(null));
        this.checkUnsupportedException(() -> converter.asJson(null));
        this.checkUnsupportedException(() -> converter.asRow(null));
        this.checkUnsupportedException(() -> converter.convertToSelf((Converter)converter, null));
    }

    @Test
    public void testMapConverter() {
        MapConverter converter = MapConverter.INSTANCE;
        this.checkConverterConversions((Converter)converter, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.OBJECT, QueryDataTypeFamily.MAP);
        Assert.assertEquals((Object)"{k=1}", (Object)converter.asVarchar(Map.of("k", 1)));
        this.checkConverterSelf((Converter)converter);
    }

    @Test
    public void testJsonConverter() {
        JsonConverter converter = JsonConverter.INSTANCE;
        this.checkConverterConversions((Converter)converter, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.OBJECT, QueryDataTypeFamily.JSON);
        Assert.assertEquals((Object)"[1,2,3]", (Object)converter.asVarchar((Object)new HazelcastJsonValue("[1,2,3]")));
        Assert.assertEquals((Object)new HazelcastJsonValue("[1,2,3]"), (Object)converter.asObject((Object)new HazelcastJsonValue("[1,2,3]")));
        this.checkConverterSelf((Converter)converter);
    }

    @Test
    public void testRowConverter() {
        RowConverter converter = RowConverter.INSTANCE;
        this.checkConverterConversions((Converter)converter, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.OBJECT, QueryDataTypeFamily.ROW);
        Assert.assertEquals((Object)"[1, 2, 3]", (Object)converter.asVarchar((Object)new RowValue(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)))));
        this.checkConverterSelf((Converter)converter);
    }

    private void checkId(Converter converter, int id) {
        Assert.assertSame((Object)id, (Object)converter.getId());
        Assert.assertSame((Object)converter, (Object)Converters.getConverter((int)id));
    }

    private void checkClasses(Converter converter, Class<?> ... classes) {
        HazelcastTestSupport.assertContains(List.of(classes), (Object)converter.getValueClass());
        for (Class<?> clazz : classes) {
            Assert.assertSame((Object)converter, (Object)Converters.getConverter(clazz));
        }
    }

    private void checkFamily(Converter converter, QueryDataTypeFamily expectedTypeFamily) {
        Assert.assertSame((Object)expectedTypeFamily, (Object)converter.getTypeFamily());
    }

    private void checkDataException(Runnable runnable) {
        try {
            runnable.run();
            Assert.fail((String)"Must fail");
        }
        catch (QueryException e) {
            Assert.assertEquals((long)2000L, (long)e.getCode());
        }
    }

    private void checkUnsupportedException(Runnable runnable) {
        try {
            runnable.run();
            Assert.fail((String)"Must fail");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private void checkTimestampWithTimezone(Converter converter, Object value, OffsetDateTime timestampWithTimezone) {
        LocalDateTime timestamp = timestampWithTimezone.atZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
        LocalDate date = timestamp.toLocalDate();
        LocalTime time = timestamp.toLocalTime();
        Assert.assertEquals((Object)timestampWithTimezone.toString(), (Object)converter.asVarchar(value));
        Assert.assertEquals((Object)date, (Object)converter.asDate(value));
        Assert.assertEquals((Object)time, (Object)converter.asTime(value));
        Assert.assertEquals((Object)timestamp, (Object)converter.asTimestamp(value));
        Assert.assertEquals((Object)timestampWithTimezone, (Object)converter.asTimestampWithTimezone(value));
        Assert.assertEquals((Object)timestampWithTimezone, (Object)converter.asObject(value));
    }

    private void checkConverterConversions(Converter converter, QueryDataTypeFamily ... expectedSupportedConversions) {
        HashSet<QueryDataTypeFamily> expectedSupportedConversions0 = new HashSet<QueryDataTypeFamily>();
        expectedSupportedConversions0.add(converter.getTypeFamily());
        expectedSupportedConversions0.addAll(Arrays.asList(expectedSupportedConversions));
        for (QueryDataTypeFamily typeFamily : QueryDataTypeFamily.values()) {
            this.checkConverterConversion(converter, typeFamily, expectedSupportedConversions0.contains(typeFamily));
        }
    }

    private void checkConverterConversion(Converter converter, QueryDataTypeFamily typeFamily, boolean expected) {
        Assert.assertEquals((String)(String.valueOf(typeFamily) + ": " + expected), (Object)expected, (Object)converter.canConvertTo(typeFamily));
        switch (typeFamily) {
            case VARCHAR: {
                Assert.assertEquals((Object)expected, (Object)converter.canConvertToVarchar());
                break;
            }
            case BOOLEAN: {
                Assert.assertEquals((Object)expected, (Object)converter.canConvertToBoolean());
                break;
            }
            case TINYINT: {
                Assert.assertEquals((Object)expected, (Object)converter.canConvertToTinyint());
                break;
            }
            case SMALLINT: {
                Assert.assertEquals((Object)expected, (Object)converter.canConvertToSmallint());
                break;
            }
            case INTEGER: {
                Assert.assertEquals((Object)expected, (Object)converter.canConvertToInt());
                break;
            }
            case BIGINT: {
                Assert.assertEquals((Object)expected, (Object)converter.canConvertToBigint());
                break;
            }
            case DECIMAL: {
                Assert.assertEquals((Object)expected, (Object)converter.canConvertToDecimal());
                break;
            }
            case REAL: {
                Assert.assertEquals((Object)expected, (Object)converter.canConvertToReal());
                break;
            }
            case DOUBLE: {
                Assert.assertEquals((Object)expected, (Object)converter.canConvertToDouble());
                break;
            }
            case TIME: {
                Assert.assertEquals((Object)expected, (Object)converter.canConvertToTime());
                break;
            }
            case DATE: {
                Assert.assertEquals((Object)expected, (Object)converter.canConvertToDate());
                break;
            }
            case TIMESTAMP: {
                Assert.assertEquals((Object)expected, (Object)converter.canConvertToTimestamp());
                break;
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                Assert.assertEquals((Object)expected, (Object)converter.canConvertToTimestampWithTimezone());
                break;
            }
            case OBJECT: {
                Assert.assertEquals((Object)expected, (Object)converter.canConvertToObject());
                break;
            }
            case MAP: {
                Assert.assertEquals((Object)expected, (Object)converter.canConvertToMap());
                break;
            }
            case JSON: {
                Assert.assertEquals((Object)expected, (Object)converter.canConvertToJson());
                break;
            }
            case ROW: {
                Assert.assertEquals((Object)expected, (Object)converter.canConvertToRow());
            }
        }
        if (!expected) {
            this.checkCannotConvert(converter, typeFamily);
        }
    }

    private void checkCannotConvert(Converter converter, QueryDataTypeFamily typeFamily) {
        try {
            Object val = new Object();
            switch (typeFamily) {
                case VARCHAR: {
                    converter.asVarchar(val);
                    break;
                }
                case BOOLEAN: {
                    converter.asBoolean(val);
                    break;
                }
                case TINYINT: {
                    converter.asTinyint(val);
                    break;
                }
                case SMALLINT: {
                    converter.asSmallint(val);
                    break;
                }
                case INTEGER: {
                    converter.asInt(val);
                    break;
                }
                case BIGINT: {
                    converter.asBigint(val);
                    break;
                }
                case DECIMAL: {
                    converter.asDecimal(val);
                    break;
                }
                case REAL: {
                    converter.asReal(val);
                    break;
                }
                case DOUBLE: {
                    converter.asDouble(val);
                    break;
                }
                case TIME: {
                    converter.asTime(val);
                    break;
                }
                case DATE: {
                    converter.asDate(val);
                    break;
                }
                case TIMESTAMP: {
                    converter.asTimestamp(val);
                    break;
                }
                case TIMESTAMP_WITH_TIME_ZONE: {
                    converter.asTimestampWithTimezone(val);
                    break;
                }
                case OBJECT: {
                    converter.asObject(val);
                    break;
                }
                case MAP: {
                    converter.asMap(val);
                    break;
                }
                case JSON: {
                    converter.asJson(val);
                    break;
                }
                case ROW: {
                    converter.asRow(val);
                    break;
                }
                default: {
                    return;
                }
            }
            Assert.fail((String)("Must fail: " + String.valueOf(typeFamily)));
        }
        catch (QueryException e) {
            Assert.assertEquals((long)2000L, (long)e.getCode());
        }
    }

    private void checkConverterSelf(Converter converter) {
        MockConverter mockConverter = new MockConverter();
        converter.convertToSelf((Converter)mockConverter, new Object());
        Assert.assertEquals((Object)converter.getTypeFamily(), (Object)mockConverter.getInvoked());
    }

    private static final class MockConverter
    extends Converter {
        private QueryDataTypeFamily invoked;

        private MockConverter() {
            super(-1, QueryDataTypeFamily.OBJECT);
        }

        public Class<?> getValueClass() {
            return Object.class;
        }

        public boolean asBoolean(Object val) {
            this.invoked = QueryDataTypeFamily.BOOLEAN;
            return true;
        }

        public byte asTinyint(Object val) {
            this.invoked = QueryDataTypeFamily.TINYINT;
            return 0;
        }

        public short asSmallint(Object val) {
            this.invoked = QueryDataTypeFamily.SMALLINT;
            return 0;
        }

        public int asInt(Object val) {
            this.invoked = QueryDataTypeFamily.INTEGER;
            return 0;
        }

        public long asBigint(Object val) {
            this.invoked = QueryDataTypeFamily.BIGINT;
            return 0L;
        }

        public BigDecimal asDecimal(Object val) {
            this.invoked = QueryDataTypeFamily.DECIMAL;
            return BigDecimal.ZERO;
        }

        public float asReal(Object val) {
            this.invoked = QueryDataTypeFamily.REAL;
            return 0.0f;
        }

        public double asDouble(Object val) {
            this.invoked = QueryDataTypeFamily.DOUBLE;
            return 0.0;
        }

        public String asVarchar(Object val) {
            this.invoked = QueryDataTypeFamily.VARCHAR;
            return "";
        }

        public LocalDate asDate(Object val) {
            this.invoked = QueryDataTypeFamily.DATE;
            return LocalDate.now();
        }

        public LocalTime asTime(Object val) {
            this.invoked = QueryDataTypeFamily.TIME;
            return LocalTime.now();
        }

        public LocalDateTime asTimestamp(Object val) {
            this.invoked = QueryDataTypeFamily.TIMESTAMP;
            return LocalDateTime.now();
        }

        public OffsetDateTime asTimestampWithTimezone(Object val) {
            this.invoked = QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE;
            return OffsetDateTime.now();
        }

        public Object asObject(Object val) {
            this.invoked = QueryDataTypeFamily.OBJECT;
            return new Object();
        }

        public Map<?, ?> asMap(Object val) {
            this.invoked = QueryDataTypeFamily.MAP;
            return Collections.emptyMap();
        }

        public HazelcastJsonValue asJson(Object val) {
            this.invoked = QueryDataTypeFamily.JSON;
            return new HazelcastJsonValue("");
        }

        public RowValue asRow(Object val) {
            this.invoked = QueryDataTypeFamily.ROW;
            return new RowValue();
        }

        public Object convertToSelf(Converter converter, Object val) {
            return val;
        }

        private QueryDataTypeFamily getInvoked() {
            return this.invoked;
        }
    }
}

