/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.type;

import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class QueryDataTypeFamilyTest {
    @Test
    public void testTemporal() {
        block3: for (QueryDataTypeFamily typeFamily : QueryDataTypeFamily.values()) {
            switch (typeFamily) {
                case TIME: 
                case DATE: 
                case TIMESTAMP: 
                case TIMESTAMP_WITH_TIME_ZONE: {
                    Assert.assertTrue((boolean)typeFamily.isTemporal());
                    continue block3;
                }
                default: {
                    Assert.assertFalse((boolean)typeFamily.isTemporal());
                }
            }
        }
    }

    @Test
    public void testEstimatedSize() {
        Assert.assertTrue((QueryDataTypeFamily.BOOLEAN.getEstimatedSize() <= QueryDataTypeFamily.TINYINT.getEstimatedSize() ? 1 : 0) != 0);
        Assert.assertTrue((QueryDataTypeFamily.TINYINT.getEstimatedSize() < QueryDataTypeFamily.SMALLINT.getEstimatedSize() ? 1 : 0) != 0);
        Assert.assertTrue((QueryDataTypeFamily.SMALLINT.getEstimatedSize() < QueryDataTypeFamily.INTEGER.getEstimatedSize() ? 1 : 0) != 0);
        Assert.assertTrue((QueryDataTypeFamily.INTEGER.getEstimatedSize() < QueryDataTypeFamily.BIGINT.getEstimatedSize() ? 1 : 0) != 0);
        Assert.assertTrue((QueryDataTypeFamily.REAL.getEstimatedSize() < QueryDataTypeFamily.DOUBLE.getEstimatedSize() ? 1 : 0) != 0);
        Assert.assertTrue((QueryDataTypeFamily.NULL.getEstimatedSize() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPrecedence() {
        QueryDataTypeFamilyTest.checkPrecedence(QueryDataTypeFamily.NULL, QueryDataTypeFamily.VARCHAR);
        QueryDataTypeFamilyTest.checkPrecedence(QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.BOOLEAN);
        QueryDataTypeFamilyTest.checkPrecedence(QueryDataTypeFamily.BOOLEAN, QueryDataTypeFamily.TINYINT);
        QueryDataTypeFamilyTest.checkPrecedence(QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.SMALLINT);
        QueryDataTypeFamilyTest.checkPrecedence(QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.INTEGER);
        QueryDataTypeFamilyTest.checkPrecedence(QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.BIGINT);
        QueryDataTypeFamilyTest.checkPrecedence(QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.DECIMAL);
        QueryDataTypeFamilyTest.checkPrecedence(QueryDataTypeFamily.DECIMAL, QueryDataTypeFamily.REAL);
        QueryDataTypeFamilyTest.checkPrecedence(QueryDataTypeFamily.REAL, QueryDataTypeFamily.DOUBLE);
        QueryDataTypeFamilyTest.checkPrecedence(QueryDataTypeFamily.DOUBLE, QueryDataTypeFamily.TIME);
        QueryDataTypeFamilyTest.checkPrecedence(QueryDataTypeFamily.TIME, QueryDataTypeFamily.DATE);
        QueryDataTypeFamilyTest.checkPrecedence(QueryDataTypeFamily.DATE, QueryDataTypeFamily.TIMESTAMP);
        QueryDataTypeFamilyTest.checkPrecedence(QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE);
        QueryDataTypeFamilyTest.checkPrecedence(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.OBJECT);
    }

    @Test
    public void testPrecedenceUnique() {
        HashMap<Integer, QueryDataTypeFamily> map = new HashMap<Integer, QueryDataTypeFamily>();
        for (QueryDataTypeFamily family : QueryDataTypeFamily.values()) {
            int precedence = family.getPrecedence();
            QueryDataTypeFamily oldFamily = map.putIfAbsent(precedence, family);
            Assert.assertNull((String)(String.valueOf(oldFamily) + " and " + String.valueOf(family) + " have the same precedence: " + precedence), (Object)oldFamily);
        }
    }

    private static void checkPrecedence(QueryDataTypeFamily lower, QueryDataTypeFamily higher) {
        Assert.assertTrue((lower.getPrecedence() < higher.getPrecedence() ? 1 : 0) != 0);
    }
}

