/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.schema.map;

import com.hazelcast.config.IndexType;
import com.hazelcast.sql.impl.CoreSqlTestSupport;
import com.hazelcast.sql.impl.schema.map.MapTableIndex;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class MapTableIndexTest
extends CoreSqlTestSupport {
    @Test
    public void testContent() {
        MapTableIndex index = new MapTableIndex("index", IndexType.SORTED, 1, Collections.singletonList(1), Collections.singletonList(QueryDataType.INT));
        Assert.assertEquals((Object)"index", (Object)index.getName());
        Assert.assertEquals((Object)IndexType.SORTED, (Object)index.getType());
        Assert.assertEquals((long)1L, (long)index.getComponentsCount());
        Assert.assertEquals(Collections.singletonList(1), (Object)index.getFieldOrdinals());
        Assert.assertEquals(Collections.singletonList(QueryDataType.INT), (Object)index.getFieldConverterTypes());
    }

    @Test
    public void testEquals() {
        String name1 = "index1";
        String name2 = "index2";
        IndexType type1 = IndexType.SORTED;
        IndexType type2 = IndexType.HASH;
        int components1 = 1;
        int components2 = 2;
        List<Integer> ordinals1 = Collections.singletonList(1);
        List<Integer> ordinals2 = Collections.singletonList(2);
        List<QueryDataType> types1 = Collections.singletonList(QueryDataType.INT);
        List<QueryDataType> types2 = Collections.singletonList(QueryDataType.BIGINT);
        MapTableIndex index = new MapTableIndex(name1, type1, components1, ordinals1, types1);
        MapTableIndexTest.checkEquals(index, new MapTableIndex(name1, type1, components1, ordinals1, types1), true);
        MapTableIndexTest.checkEquals(index, new MapTableIndex(name2, type1, components1, ordinals1, types1), false);
        MapTableIndexTest.checkEquals(index, new MapTableIndex(name1, type2, components1, ordinals1, types1), false);
        MapTableIndexTest.checkEquals(index, new MapTableIndex(name1, type1, components2, ordinals1, types1), false);
        MapTableIndexTest.checkEquals(index, new MapTableIndex(name1, type1, components1, ordinals2, types1), false);
        MapTableIndexTest.checkEquals(index, new MapTableIndex(name1, type1, components1, ordinals1, types2), false);
    }
}

