/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.schema.map;

import com.hazelcast.core.TypeConverter;
import com.hazelcast.query.impl.CompositeConverter;
import com.hazelcast.query.impl.TypeConverters;
import com.hazelcast.sql.impl.schema.map.MapTableUtils;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class MapTableConverterResolutionTest {
    @Test
    public void testSimpleConverters() {
        this.checkSimpleConverter(TypeConverters.BOOLEAN_CONVERTER, QueryDataType.BOOLEAN);
        this.checkSimpleConverter(TypeConverters.BYTE_CONVERTER, QueryDataType.TINYINT);
        this.checkSimpleConverter(TypeConverters.SHORT_CONVERTER, QueryDataType.SMALLINT);
        this.checkSimpleConverter(TypeConverters.INTEGER_CONVERTER, QueryDataType.INT);
        this.checkSimpleConverter(TypeConverters.LONG_CONVERTER, QueryDataType.BIGINT);
        this.checkSimpleConverter(TypeConverters.BIG_INTEGER_CONVERTER, QueryDataType.DECIMAL_BIG_INTEGER);
        this.checkSimpleConverter(TypeConverters.BIG_DECIMAL_CONVERTER, QueryDataType.DECIMAL);
        this.checkSimpleConverter(TypeConverters.FLOAT_CONVERTER, QueryDataType.REAL);
        this.checkSimpleConverter(TypeConverters.DOUBLE_CONVERTER, QueryDataType.DOUBLE);
        this.checkSimpleConverter(TypeConverters.CHAR_CONVERTER, QueryDataType.VARCHAR_CHARACTER);
        this.checkSimpleConverter(TypeConverters.STRING_CONVERTER, QueryDataType.VARCHAR);
        this.checkSimpleConverter(TypeConverters.ENUM_CONVERTER, QueryDataType.OBJECT);
        this.checkSimpleConverter(TypeConverters.IDENTITY_CONVERTER, QueryDataType.OBJECT);
        this.checkSimpleConverter(TypeConverters.PORTABLE_CONVERTER, QueryDataType.OBJECT);
        this.checkSimpleConverter(TypeConverters.UUID_CONVERTER, QueryDataType.OBJECT);
        this.checkUnsupportedConverter(TypeConverters.DATE_CONVERTER);
        this.checkUnsupportedConverter(TypeConverters.SQL_DATE_CONVERTER);
        this.checkUnsupportedConverter(TypeConverters.SQL_TIMESTAMP_CONVERTER);
        this.checkUnsupportedConverter(TypeConverters.NULL_CONVERTER);
    }

    private void checkSimpleConverter(TypeConverter converter, QueryDataType expectedType) {
        Assert.assertEquals((Object)expectedType, (Object)MapTableUtils.indexConverterToSqlType((TypeConverter)converter));
        Assert.assertEquals(Collections.singletonList(expectedType), (Object)MapTableUtils.indexConverterToSqlTypes((TypeConverter)converter));
    }

    private void checkUnsupportedConverter(TypeConverter converter) {
        Assert.assertNull((Object)MapTableUtils.indexConverterToSqlType((TypeConverter)converter));
        Assert.assertEquals(Collections.emptyList(), (Object)MapTableUtils.indexConverterToSqlTypes((TypeConverter)converter));
        CompositeConverter badGood = new CompositeConverter(new TypeConverter[]{converter, TypeConverters.INTEGER_CONVERTER});
        Assert.assertEquals(Collections.emptyList(), (Object)MapTableUtils.indexConverterToSqlTypes((TypeConverter)badGood));
        CompositeConverter goodBad = new CompositeConverter(new TypeConverter[]{TypeConverters.INTEGER_CONVERTER, converter});
        Assert.assertEquals(Collections.singletonList(QueryDataType.INT), (Object)MapTableUtils.indexConverterToSqlTypes((TypeConverter)goodBad));
    }

    @Test
    public void testCompositeConverters() {
        this.checkCompositeConverters(TypeConverters.BOOLEAN_CONVERTER, QueryDataType.BOOLEAN);
        this.checkCompositeConverters(TypeConverters.BYTE_CONVERTER, QueryDataType.TINYINT);
        this.checkCompositeConverters(TypeConverters.SHORT_CONVERTER, QueryDataType.SMALLINT);
        this.checkCompositeConverters(TypeConverters.INTEGER_CONVERTER, QueryDataType.INT);
        this.checkCompositeConverters(TypeConverters.LONG_CONVERTER, QueryDataType.BIGINT);
        this.checkCompositeConverters(TypeConverters.BIG_INTEGER_CONVERTER, QueryDataType.DECIMAL_BIG_INTEGER);
        this.checkCompositeConverters(TypeConverters.BIG_DECIMAL_CONVERTER, QueryDataType.DECIMAL);
        this.checkCompositeConverters(TypeConverters.FLOAT_CONVERTER, QueryDataType.REAL);
        this.checkCompositeConverters(TypeConverters.DOUBLE_CONVERTER, QueryDataType.DOUBLE);
        this.checkCompositeConverters(TypeConverters.CHAR_CONVERTER, QueryDataType.VARCHAR_CHARACTER);
        this.checkCompositeConverters(TypeConverters.STRING_CONVERTER, QueryDataType.VARCHAR);
        this.checkCompositeConverters(TypeConverters.ENUM_CONVERTER, QueryDataType.OBJECT);
        this.checkCompositeConverters(TypeConverters.IDENTITY_CONVERTER, QueryDataType.OBJECT);
        this.checkCompositeConverters(TypeConverters.PORTABLE_CONVERTER, QueryDataType.OBJECT);
        this.checkCompositeConverters(TypeConverters.UUID_CONVERTER, QueryDataType.OBJECT);
    }

    private void checkCompositeConverters(TypeConverter converter1, QueryDataType expectedType) {
        this.checkCompositeConverter(converter1, TypeConverters.BOOLEAN_CONVERTER, expectedType, QueryDataType.BOOLEAN);
        this.checkCompositeConverter(converter1, TypeConverters.BYTE_CONVERTER, expectedType, QueryDataType.TINYINT);
        this.checkCompositeConverter(converter1, TypeConverters.SHORT_CONVERTER, expectedType, QueryDataType.SMALLINT);
        this.checkCompositeConverter(converter1, TypeConverters.INTEGER_CONVERTER, expectedType, QueryDataType.INT);
        this.checkCompositeConverter(converter1, TypeConverters.LONG_CONVERTER, expectedType, QueryDataType.BIGINT);
        this.checkCompositeConverter(converter1, TypeConverters.BIG_INTEGER_CONVERTER, expectedType, QueryDataType.DECIMAL_BIG_INTEGER);
        this.checkCompositeConverter(converter1, TypeConverters.BIG_DECIMAL_CONVERTER, expectedType, QueryDataType.DECIMAL);
        this.checkCompositeConverter(converter1, TypeConverters.FLOAT_CONVERTER, expectedType, QueryDataType.REAL);
        this.checkCompositeConverter(converter1, TypeConverters.DOUBLE_CONVERTER, expectedType, QueryDataType.DOUBLE);
        this.checkCompositeConverter(converter1, TypeConverters.CHAR_CONVERTER, expectedType, QueryDataType.VARCHAR_CHARACTER);
        this.checkCompositeConverter(converter1, TypeConverters.STRING_CONVERTER, expectedType, QueryDataType.VARCHAR);
        this.checkCompositeConverter(converter1, TypeConverters.ENUM_CONVERTER, expectedType, QueryDataType.OBJECT);
        this.checkCompositeConverter(converter1, TypeConverters.IDENTITY_CONVERTER, expectedType, QueryDataType.OBJECT);
        this.checkCompositeConverter(converter1, TypeConverters.PORTABLE_CONVERTER, expectedType, QueryDataType.OBJECT);
        this.checkCompositeConverter(converter1, TypeConverters.UUID_CONVERTER, expectedType, QueryDataType.OBJECT);
    }

    private void checkCompositeConverter(TypeConverter converter1, TypeConverter converter2, QueryDataType ... expectedTypes) {
        CompositeConverter converter = new CompositeConverter(new TypeConverter[]{converter1, converter2});
        List types = MapTableUtils.indexConverterToSqlTypes((TypeConverter)converter);
        List<Object> expectedTypes0 = expectedTypes == null ? Collections.emptyList() : Arrays.asList(expectedTypes);
        Assert.assertEquals(expectedTypes0, (Object)types);
    }

    @Test
    public void testConverterCompatibility() {
        this.checkConverterCompatibility(QueryDataType.BOOLEAN, new QueryDataType[0]);
        this.checkConverterCompatibilityNumeric(QueryDataType.TINYINT);
        this.checkConverterCompatibilityNumeric(QueryDataType.SMALLINT);
        this.checkConverterCompatibilityNumeric(QueryDataType.INT);
        this.checkConverterCompatibilityNumeric(QueryDataType.BIGINT);
        this.checkConverterCompatibilityNumeric(QueryDataType.DECIMAL);
        this.checkConverterCompatibilityNumeric(QueryDataType.DECIMAL_BIG_INTEGER);
        this.checkConverterCompatibilityNumeric(QueryDataType.REAL);
        this.checkConverterCompatibilityNumeric(QueryDataType.DOUBLE);
        this.checkConverterCompatibility(QueryDataType.VARCHAR, QueryDataType.VARCHAR_CHARACTER);
        this.checkConverterCompatibility(QueryDataType.VARCHAR_CHARACTER, QueryDataType.VARCHAR);
        this.checkConverterCompatibility(QueryDataType.OBJECT, new QueryDataType[0]);
    }

    private void checkConverterCompatibilityNumeric(QueryDataType columnType) {
        this.checkConverterCompatibility(columnType, QueryDataType.TINYINT, QueryDataType.SMALLINT, QueryDataType.INT, QueryDataType.BIGINT, QueryDataType.DECIMAL_BIG_INTEGER, QueryDataType.DECIMAL, QueryDataType.REAL, QueryDataType.DOUBLE);
    }

    private void checkConverterCompatibility(QueryDataType columnType, QueryDataType ... supportedIndexConverterTypes) {
        HashSet<QueryDataType> supportedIndexConverterTypes0 = supportedIndexConverterTypes == null ? new HashSet<QueryDataType>() : new HashSet<QueryDataType>(Arrays.asList(supportedIndexConverterTypes));
        supportedIndexConverterTypes0.add(columnType);
        this.checkConverterCompatibility(columnType, QueryDataType.BOOLEAN, supportedIndexConverterTypes0);
        this.checkConverterCompatibility(columnType, QueryDataType.TINYINT, supportedIndexConverterTypes0);
        this.checkConverterCompatibility(columnType, QueryDataType.SMALLINT, supportedIndexConverterTypes0);
        this.checkConverterCompatibility(columnType, QueryDataType.INT, supportedIndexConverterTypes0);
        this.checkConverterCompatibility(columnType, QueryDataType.BIGINT, supportedIndexConverterTypes0);
        this.checkConverterCompatibility(columnType, QueryDataType.DECIMAL, supportedIndexConverterTypes0);
        this.checkConverterCompatibility(columnType, QueryDataType.DECIMAL_BIG_INTEGER, supportedIndexConverterTypes0);
        this.checkConverterCompatibility(columnType, QueryDataType.REAL, supportedIndexConverterTypes0);
        this.checkConverterCompatibility(columnType, QueryDataType.DOUBLE, supportedIndexConverterTypes0);
        this.checkConverterCompatibility(columnType, QueryDataType.VARCHAR, supportedIndexConverterTypes0);
        this.checkConverterCompatibility(columnType, QueryDataType.VARCHAR_CHARACTER, supportedIndexConverterTypes0);
        this.checkConverterCompatibility(columnType, QueryDataType.OBJECT, supportedIndexConverterTypes0);
    }

    private void checkConverterCompatibility(QueryDataType columnType, QueryDataType indexConverterType, Set<QueryDataType> supportedIndexConverterTypes) {
        boolean supported = supportedIndexConverterTypes.contains(indexConverterType);
        Assert.assertEquals((Object)supported, (Object)MapTableUtils.isCompatibleForIndexRequest((QueryDataType)columnType, (QueryDataType)indexConverterType));
    }
}

