/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.schema;

import com.hazelcast.sql.impl.optimizer.PlanObjectKey;
import com.hazelcast.sql.impl.schema.SqlCatalog;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableResolver;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlCatalogTest {
    @Test
    public void when_sameNameInTwoSchemas_then_conflict() {
        MockTable s1t1 = new MockTable("s1", "t1");
        MockTable s1t2 = new MockTable("s1", "t2");
        MockTable s2t2 = new MockTable("s2", "t2");
        MockTableResolver tr1 = new MockTableResolver(s1t1, s1t2, s2t2);
        new SqlCatalog(Collections.singletonList(tr1));
        Assert.assertEquals(Collections.emptySet(), (Object)s1t1.getConflictingSchemas());
        Assert.assertEquals(Set.of("s1", "s2"), (Object)s1t2.getConflictingSchemas());
        Assert.assertEquals(Set.of("s1", "s2"), (Object)s2t2.getConflictingSchemas());
    }

    @Test
    public void when_sameFqn_then_noConflict() {
        MockTable s1t1_1 = new MockTable("s1", "t1");
        MockTable s1t1_2 = new MockTable("s1", "t1");
        MockTableResolver tr1 = new MockTableResolver(s1t1_1, s1t1_2);
        new SqlCatalog(Collections.singletonList(tr1));
        Assert.assertEquals(Collections.emptySet(), (Object)s1t1_1.getConflictingSchemas());
        Assert.assertEquals(Collections.emptySet(), (Object)s1t1_2.getConflictingSchemas());
    }

    @Test
    public void when_sameFqnAndConflict_then_conflict() {
        MockTable s1t1_1 = new MockTable("s1", "t1");
        MockTable s1t1_2 = new MockTable("s1", "t1");
        MockTable s2t1 = new MockTable("s2", "t1");
        MockTableResolver tr1 = new MockTableResolver(s1t1_1);
        MockTableResolver tr2 = new MockTableResolver(s1t1_2, s2t1);
        new SqlCatalog(Arrays.asList(tr1, tr2));
        Set<String> bothSchemas = Set.of("s1", "s2");
        Assert.assertEquals(bothSchemas, (Object)s1t1_1.getConflictingSchemas());
        Assert.assertEquals(Collections.emptySet(), (Object)s1t1_2.getConflictingSchemas());
        Assert.assertEquals(bothSchemas, (Object)s2t1.getConflictingSchemas());
    }

    private static class MockTable
    extends Table {
        MockTable(String schema, String tableName) {
            super(schema, tableName, Collections.emptyList(), null, "Mock", false);
        }

        public PlanObjectKey getObjectKey() {
            return null;
        }
    }

    private static class MockTableResolver
    implements TableResolver {
        private final List<Table> tables;

        private MockTableResolver(Table ... tables) {
            this.tables = Arrays.asList(tables);
        }

        @Nonnull
        public List<List<String>> getDefaultSearchPaths() {
            return Collections.emptyList();
        }

        @Nonnull
        public List<Table> getTables() {
            return this.tables;
        }

        public void registerListener(TableResolver.TableListener listener) {
        }
    }
}

