/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.schema;

import com.hazelcast.cluster.Member;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.schema.model.Person;
import com.hazelcast.sql.impl.client.SqlClientService;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class IMapResolverTest
extends SqlTestSupport {
    @BeforeClass
    public static void beforeClass() {
        IMapResolverTest.initializeWithClient((int)1, null, null);
    }

    @Before
    public void setup() {
        IMapResolverTest.warmUpPartitions((HazelcastInstance[])IMapResolverTest.instances());
        IMapResolverTest.warmUpPartitions((HazelcastInstance[])new HazelcastInstance[]{IMapResolverTest.client()});
    }

    @Test
    public void smokeTest() throws Exception {
        Member member = IMapResolverTest.instance().getCluster().getLocalMember();
        IMapResolverTest.instance().getMap("m1").put((Object)42, (Object)new BigDecimal(43));
        String mappingDdl1 = (String)((SqlClientService)IMapResolverTest.client().getSql()).mappingDdl(member, "m1").get();
        Assertions.assertThat((String)mappingDdl1).isEqualToNormalizingNewlines((CharSequence)"CREATE OR REPLACE EXTERNAL MAPPING \"hazelcast\".\"public\".\"m1\" EXTERNAL NAME \"m1\"\nTYPE \"IMap\"\nOPTIONS (\n  'keyFormat'='java',\n  'keyJavaClass'='java.lang.Integer',\n  'valueFormat'='java',\n  'valueJavaClass'='java.math.BigDecimal'\n)");
        IMapResolverTest.instance().getSql().executeUpdate(mappingDdl1, new Object[0]);
        IMapResolverTest.instance().getMap("m2").put((Object)"foo", (Object)new Person("person name"));
        String mappingDdl2 = (String)((SqlClientService)IMapResolverTest.client().getSql()).mappingDdl(member, "m2").get();
        Assertions.assertThat((String)mappingDdl2).isEqualToNormalizingNewlines((CharSequence)"CREATE OR REPLACE EXTERNAL MAPPING \"hazelcast\".\"public\".\"m2\" EXTERNAL NAME \"m2\"\nTYPE \"IMap\"\nOPTIONS (\n  'keyFormat'='java',\n  'keyJavaClass'='java.lang.String',\n  'valueFormat'='java',\n  'valueJavaClass'='com.hazelcast.jet.sql.impl.schema.model.Person'\n)");
        IMapResolverTest.instance().getSql().executeUpdate(mappingDdl2, new Object[0]);
    }

    @Test
    public void testCompactSerialization() throws Exception {
        Member member = IMapResolverTest.instance().getCluster().getLocalMember();
        IMapResolverTest.instance().getMap("m3").put((Object)"foo", (Object)new CompactClass(1));
        String mappingDdl = (String)((SqlClientService)IMapResolverTest.client().getSql()).mappingDdl(member, "m3").get();
        Assertions.assertThat((String)mappingDdl).isEqualToNormalizingNewlines((CharSequence)"CREATE OR REPLACE EXTERNAL MAPPING \"hazelcast\".\"public\".\"m3\" EXTERNAL NAME \"m3\" (\n  \"field\" INTEGER EXTERNAL NAME \"this.field\"\n)\nTYPE \"IMap\"\nOPTIONS (\n  'keyFormat'='java',\n  'keyJavaClass'='java.lang.String',\n  'valueFormat'='compact',\n  'valueCompactTypeName'='com.hazelcast.sql.impl.schema.IMapResolverTest$CompactClass'\n)");
        IMapResolverTest.instance().getSql().executeUpdate(mappingDdl, new Object[0]);
    }

    private static class CompactClass {
        private Integer field;

        CompactClass(Integer field) {
            this.field = field;
        }
    }
}

