/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.predicate;

import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.predicate.TernaryLogic;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class TernaryLogicTest {
    private static final Row ROW = new MockRow();
    private static final ExpressionEvalContext CONTEXT = (ExpressionEvalContext)Mockito.mock(ExpressionEvalContext.class);

    @Test
    public void testAnd() {
        Assert.assertEquals((Object)true, (Object)TernaryLogic.and((Row)ROW, (ExpressionEvalContext)CONTEXT, (Expression[])new Expression[0]));
        Assert.assertEquals((Object)false, (Object)TernaryLogic.and((Row)ROW, (ExpressionEvalContext)CONTEXT, (Expression[])new Expression[]{ConstantExpression.FALSE, ConstantExpression.FALSE}));
        Assert.assertEquals((Object)false, (Object)TernaryLogic.and((Row)ROW, (ExpressionEvalContext)CONTEXT, (Expression[])new Expression[]{ConstantExpression.FALSE, ConstantExpression.TRUE}));
        Assert.assertEquals((Object)false, (Object)TernaryLogic.and((Row)ROW, (ExpressionEvalContext)CONTEXT, (Expression[])new Expression[]{ConstantExpression.TRUE, ConstantExpression.FALSE}));
        Assert.assertEquals((Object)true, (Object)TernaryLogic.and((Row)ROW, (ExpressionEvalContext)CONTEXT, (Expression[])new Expression[]{ConstantExpression.TRUE, ConstantExpression.TRUE}));
        Assert.assertEquals((Object)false, (Object)TernaryLogic.and((Row)ROW, (ExpressionEvalContext)CONTEXT, (Expression[])new Expression[]{ConstantExpression.NULL, ConstantExpression.FALSE}));
        Assert.assertEquals((Object)false, (Object)TernaryLogic.and((Row)ROW, (ExpressionEvalContext)CONTEXT, (Expression[])new Expression[]{ConstantExpression.FALSE, ConstantExpression.NULL}));
        Assert.assertEquals(null, (Object)TernaryLogic.and((Row)ROW, (ExpressionEvalContext)CONTEXT, (Expression[])new Expression[]{ConstantExpression.NULL, ConstantExpression.TRUE}));
        Assert.assertEquals(null, (Object)TernaryLogic.and((Row)ROW, (ExpressionEvalContext)CONTEXT, (Expression[])new Expression[]{ConstantExpression.TRUE, ConstantExpression.NULL}));
        Assert.assertEquals(null, (Object)TernaryLogic.and((Row)ROW, (ExpressionEvalContext)CONTEXT, (Expression[])new Expression[]{ConstantExpression.NULL, ConstantExpression.NULL}));
    }

    @Test
    public void testOr() {
        Assert.assertEquals((Object)false, (Object)TernaryLogic.or((Row)ROW, (ExpressionEvalContext)CONTEXT, (Expression[])new Expression[0]));
        Assert.assertEquals((Object)false, (Object)TernaryLogic.or((Row)ROW, (ExpressionEvalContext)CONTEXT, (Expression[])new Expression[]{ConstantExpression.FALSE, ConstantExpression.FALSE}));
        Assert.assertEquals((Object)true, (Object)TernaryLogic.or((Row)ROW, (ExpressionEvalContext)CONTEXT, (Expression[])new Expression[]{ConstantExpression.FALSE, ConstantExpression.TRUE}));
        Assert.assertEquals((Object)true, (Object)TernaryLogic.or((Row)ROW, (ExpressionEvalContext)CONTEXT, (Expression[])new Expression[]{ConstantExpression.TRUE, ConstantExpression.FALSE}));
        Assert.assertEquals((Object)true, (Object)TernaryLogic.or((Row)ROW, (ExpressionEvalContext)CONTEXT, (Expression[])new Expression[]{ConstantExpression.TRUE, ConstantExpression.TRUE}));
        Assert.assertEquals(null, (Object)TernaryLogic.or((Row)ROW, (ExpressionEvalContext)CONTEXT, (Expression[])new Expression[]{ConstantExpression.NULL, ConstantExpression.FALSE}));
        Assert.assertEquals(null, (Object)TernaryLogic.or((Row)ROW, (ExpressionEvalContext)CONTEXT, (Expression[])new Expression[]{ConstantExpression.FALSE, ConstantExpression.NULL}));
        Assert.assertEquals((Object)true, (Object)TernaryLogic.or((Row)ROW, (ExpressionEvalContext)CONTEXT, (Expression[])new Expression[]{ConstantExpression.NULL, ConstantExpression.TRUE}));
        Assert.assertEquals((Object)true, (Object)TernaryLogic.or((Row)ROW, (ExpressionEvalContext)CONTEXT, (Expression[])new Expression[]{ConstantExpression.TRUE, ConstantExpression.NULL}));
        Assert.assertEquals(null, (Object)TernaryLogic.or((Row)ROW, (ExpressionEvalContext)CONTEXT, (Expression[])new Expression[]{ConstantExpression.NULL, ConstantExpression.NULL}));
    }

    @Test
    public void testNot() {
        Assert.assertEquals((Object)true, (Object)TernaryLogic.not((Boolean)false));
        Assert.assertEquals((Object)false, (Object)TernaryLogic.not((Boolean)true));
        Assert.assertEquals(null, (Object)TernaryLogic.not(null));
    }

    @Test
    public void isNull() {
        Assert.assertEquals((Object)false, (Object)TernaryLogic.isNull((Object)false));
        Assert.assertEquals((Object)false, (Object)TernaryLogic.isNull((Object)true));
        Assert.assertEquals((Object)true, (Object)TernaryLogic.isNull(null));
        Assert.assertEquals((Object)false, (Object)TernaryLogic.isNull((Object)new Object()));
    }

    @Test
    public void isNotNull() {
        Assert.assertEquals((Object)true, (Object)TernaryLogic.isNotNull((Object)false));
        Assert.assertEquals((Object)true, (Object)TernaryLogic.isNotNull((Object)true));
        Assert.assertEquals((Object)false, (Object)TernaryLogic.isNotNull(null));
        Assert.assertEquals((Object)true, (Object)TernaryLogic.isNotNull((Object)new Object()));
    }

    @Test
    public void testIsTrue() {
        Assert.assertEquals((Object)false, (Object)TernaryLogic.isTrue((Boolean)false));
        Assert.assertEquals((Object)true, (Object)TernaryLogic.isTrue((Boolean)true));
        Assert.assertEquals((Object)false, (Object)TernaryLogic.isTrue(null));
    }

    @Test
    public void testIsNotTrue() {
        Assert.assertEquals((Object)true, (Object)TernaryLogic.isNotTrue((Boolean)false));
        Assert.assertEquals((Object)false, (Object)TernaryLogic.isNotTrue((Boolean)true));
        Assert.assertEquals((Object)true, (Object)TernaryLogic.isNotTrue(null));
    }

    @Test
    public void testIsFalse() {
        Assert.assertEquals((Object)true, (Object)TernaryLogic.isFalse((Boolean)false));
        Assert.assertEquals((Object)false, (Object)TernaryLogic.isFalse((Boolean)true));
        Assert.assertEquals((Object)false, (Object)TernaryLogic.isFalse(null));
    }

    @Test
    public void testIsNotFalse() {
        Assert.assertEquals((Object)false, (Object)TernaryLogic.isNotFalse((Boolean)false));
        Assert.assertEquals((Object)true, (Object)TernaryLogic.isNotFalse((Boolean)true));
        Assert.assertEquals((Object)true, (Object)TernaryLogic.isNotFalse(null));
    }

    private static class MockRow
    implements Row {
        private MockRow() {
        }

        public <T> T get(int index) {
            throw new UnsupportedOperationException();
        }

        public int getColumnCount() {
            throw new UnsupportedOperationException();
        }
    }
}

