/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.datetime;

import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.datetime.Formatter;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class FormatterTest {
    private static final Locale TR = new Locale("tr", "TR");

    @Test
    public void testDates() {
        Formatter f = Formatter.forDates((String)"FMDay, Mon FMDDth, FMYYYY");
        this.check(LocalDate.of(2022, 9, 26), f, "Monday, Sep 26th, 2022");
        f = Formatter.forDates((String)"FMDD FMMonth FMYYYY");
        this.check(LocalDate.of(2022, 9, 26), f, "26 Eyl\u00fcl 2022", TR);
        f = Formatter.forDates((String)"YYYY-MM-DD FMHH:MI AM OF");
        this.check(LocalDateTime.of(2022, 9, 26, 14, 53).atOffset(ZoneOffset.ofHours(3)), f, "2022-09-26 2:53 PM +03:00");
        f = Formatter.forDates((String)"HH12:MI A.M. TZTZH:TZM");
        this.check(LocalTime.of(14, 53).atOffset(ZoneOffset.ofHours(3)), f, "02:53 P.M. GMT+03:00");
        f = Formatter.forDates((String)"HH12:MI A.M.");
        this.check(LocalTime.of(14, 53), f, "02:53 \u00d6.S.", TR);
        f = Formatter.forDates((String)"At HH24:MI:SS, FMSSSS(=FMSSSSS) \"seconds are passed from the midnight.\"");
        this.check(LocalTime.of(12, 34, 56), f, "At 12:34:56, 45296(=45296) seconds are passed from the midnight.");
        f = Formatter.forDates((String)"YYYY-MM-DD \"is the\" FMDDDth \"day of\" FMYYYY.");
        this.check(LocalDate.of(2022, 9, 26), f, "2022-09-26 is the 269th day of 2022.");
        f = Formatter.forDates((String)"Y,YYY YYYY YYY YY Y - FMY,YYY FMYYYY FMYYY FMYY FMY");
        this.check(Year.of(1), f, "0,001 0001 001 01 1 - 1 1 1 1 1");
        f = Formatter.forDates((String)"FF1 FF2 FF3(=MS) FF4 FF5 FF6(=US)");
        this.check(LocalTime.ofNanoOfDay(123456789L), f, "1 12 123(=123) 1234 12345 123456(=123456)");
        f = Formatter.forDates((String)"\"Quarter\" FMYYYY-\"Q\"Q \"is in the\" FMCCth \"century.\"");
        this.check(YearMonth.of(2022, 9), f, "Quarter 2022-Q3 is in the 21st century.");
        f = Formatter.forDates((String)"\"Plato founded the Academy in c.\" FMYYYY AD.");
        this.check(Year.of(-386), f, "Plato founded the Academy in c. 387 BC.");
        f = Formatter.forDates((String)"\"Plato Akademi'yi\" A.D. FMYYYY \"civar\u0131nda kurdu.\"");
        this.check(Year.of(-386), f, "Plato Akademi'yi M.\u00d6. 387 civar\u0131nda kurdu.", TR);
        f = Formatter.forDates((String)"AD(=BC) A.D.(=B.C.) ad(=bc) a.d.(=b.c.)");
        this.check(Year.of(0), f, "BC(=BC) B.C.(=B.C.) bc(=bc) b.c.(=b.c.)");
        f = Formatter.forDates((String)"\"The Halley's closest approach to the Earth was on\" FMDD FMMonth FMYYYY AD (the FMJth \"Julian day\").");
        this.check(LocalDate.of(837, 2, 28), f, "The Halley's closest approach to the Earth was on 28 February 837 AD (the 2026827th Julian day).");
        f = Formatter.forDates((String)"FMRM.FMRD.FMRY");
        this.check(LocalDate.of(2022, 9, 26), f, "IX.XXVI.MMXXII");
    }

    @Test
    public void testWeekDates() {
        Formatter f = Formatter.forDates((String)"IYYY-\"W\"IW-FMID");
        this.check(LocalDate.of(2022, 10, 25), f, "2022-W43-2");
        this.check(LocalDate.of(2019, 12, 30), f, "2020-W01-1");
        f = Formatter.forDates((String)"YYYY-MM-DD \"is the\" FMIDDDth \"day of week-year\" FMIYYY.");
        this.check(LocalDate.of(2008, 12, 29), f, "2008-12-29 is the 1st day of week-year 2009.");
        this.check(LocalDate.of(2010, 1, 3), f, "2010-01-03 is the 371st day of week-year 2009.");
        f = Formatter.forDates((String)"IYYY IYY IY I - FMIYYY FMIYY FMIY FMI");
        this.check(LocalDate.of(1, 1, 1), f, "0001 001 01 1 - 1 1 1 1");
    }

    @Test
    public void testDigitsAndGrouping() {
        Formatter f = Formatter.forNumbers((String)"00");
        this.check(-5, f, "-05");
        f = Formatter.forNumbers((String)".00");
        this.check(-0.5, f, "-.50");
        f = Formatter.forNumbers((String)"0,909.090");
        this.check(-123.4, f, "-0,123.400");
        f = Formatter.forNumbers((String)"9,090.909");
        this.check(-123.4, f, "  -123.40 ");
        f = Formatter.forNumbers((String)"9G99G999D99");
        this.check(-123456.78, f, "-1,23,456.78");
    }

    @Test
    public void testRounding() {
        Formatter f = Formatter.forNumbers((String)"FM0.9");
        this.check(0.15, f, "0.2");
        f = Formatter.forNumbers((String)"FM.99");
        this.check(0.015, f, ".02");
        f = Formatter.forNumbers((String)"FM99");
        this.check(9.9, f, "10");
    }

    @Test
    public void testSignAndAnchoring() {
        this.check(0.0, "+0.0", "-0.0", "S0.0", "SG0.0");
        this.check(0.0, " +.0", " -.0", "S9.0", "9SG.0", "9S.0");
        this.check(0.0, "+0  ", "-0  ", "S0.9", "SG0.9");
        this.check(0.0, "0.0+", "0.0-", "0.0S", "0.0SG");
        this.check(0.0, " .0+", " .0-", "9.0S", "9.0SG");
        this.check(0.0, "0+  ", "0-  ", "0.9S", "0SG.9", "0S.9");
        this.check(0.0, "+0  ", "-0  ", "SG9.9", "S9.9");
        this.check(0.0, "0+  ", "0-  ", "9SG.9", "9S.9", "9.S9", "9.9S");
        this.check(0.0, "0 + ", "0 - ", "9.SG9");
        this.check(0.0, "0  +", "0  -", "9.9SG");
        this.check(0.0, "+.0", "-.0", "SG.9", "S.9");
        this.check(0.0, ".+0", ".-0", ".SG9", ".S9");
        this.check(0.0, ".0+", ".0-", ".9SG", ".9S");
        this.check(0.0, " 0 ", "<0>", "9BR", "BR9", "9B", "B9", "BR9BR", "B9B", "BR9B", "B9BR");
        this.check(4.5, "  4.5 ", "< 4.5>", "99.9BR", "BR99.9", "BR99.9BR", "BR99.9B");
        this.check(4.5, "  4.5 ", " <4.5>", "99.9B", "B99.9", "B99.9B");
        this.check(4.5, " +4.5 ", " <4.5>", "P9.9B", "BP9.9", "PB9.9");
        this.check(4.5, "+ 4.5", "- 4.5", "SG99.9");
        this.check(4.5, " 4.5+", " 4.5-", "99.9SG", "99.9S");
        this.check(4.5, " +4.5", " -4.5", "S99.9");
        this.check(4.5, "  4.5", "- 4.5", "MI99.9");
        this.check(4.5, " 4.5 ", " 4.5-", "99.9MI", "99.9M");
        this.check(4.5, "  4.5", " -4.5", "M99.9");
        this.check(4.5, "+  4.5", "  -4.5", "PL99.9");
        this.check(4.5, "  4.5+", " -4.5 ", "99.9PL", "99.9P");
        this.check(4.5, "  +4.5", "  -4.5", "P99.9");
    }

    @Test
    public void testMultiplier() {
        this.check(4.5, " 450", "-450", "999V99", "999V9V9");
        this.check(0.0485, " 4.9 E-01", "-4.9 E-01", "9.9V9 EEEE", "9V9.9 EEEE", "9.9 V9EEEE", "9.9 EEEEV9");
    }

    @Test
    public void testExponentialForm() {
        this.check(0.0, " 0E+00", "-0E+00", "9EEEE");
        this.check(0.0, " .0E+00", "-.0E+00", ".9EEEE");
        Formatter f = Formatter.forNumbers((String)"FM9.99EEEE");
        this.check(0, f, "0E+00");
        this.check(50000.0, f, "5E+04");
        this.check(4.5E-4, f, "4.5E-04");
        this.check(4.859E-4, f, "4.86E-04");
    }

    @Test
    public void testSignAndCurrencyAnchoring() {
        this.check(4.5, "$  4.5", "$- 4.5", "CRMI99.9");
        this.check(4.5, "$  4.5", "$ -4.5", "CRM99.9", "CR99.9");
        this.check(4.5, "  $4.5", " $-4.5", "CM99.9");
        this.check(4.5, " $ 4.5", "-$ 4.5", "MICR99.9");
        this.check(4.5, "  $4.5", "- $4.5", "MIC99.9");
        this.check(4.5, "  $4.5", " -$4.5", "MC99.9", "C99.9");
        this.check(4.5, "$  4.5 ", "$< 4.5>", "CRBR99.9", "CR99.9BR");
        this.check(4.5, "$  4.5 ", "$ <4.5>", "CRB99.9", "CR99.9B");
        this.check(4.5, "  $4.5 ", " $<4.5>", "CB99.9");
        this.check(4.5, " $ 4.5 ", "<$ 4.5>", "BRCR99.9");
        this.check(4.5, "  $4.5 ", "< $4.5>", "BRC99.9", "C99.9BR");
        this.check(4.5, "  $4.5 ", " <$4.5>", "BC99.9", "C99.9B");
        this.check(5.0, "$ 5 ", "$<5>", "CRBR9", "CRB9", "CR9B");
        this.check(5.0, " $5 ", "$<5>", "CB9");
        this.check(5.0, " $5 ", "<$5>", "BRCR9", "BRC9", "C9BR", "BC9", "C9B");
        this.check(5.0, " 5 $", "<5>$", "9BRCR", "9BCR", "B9CR");
        this.check(5.0, " 5$ ", "<5>$", "9BC");
        this.check(5.0, " 5$ ", "<5$>", "9CRBR", "9CBR", "BR9C", "9CB", "B9C");
    }

    @Test
    public void testOrdinals() {
        Formatter f = Formatter.forNumbers((String)"9TH");
        this.check(-1, f, "-1ST");
        this.check(0, f, " 0TH");
        this.check(2, f, " 2ND");
        this.check(3, f, " 3RD");
        f = Formatter.forNumbers((String)"FM999th");
        this.check(410, f, "410th");
        this.check(411, f, "411th");
        this.check(412, f, "412th");
        this.check(413, f, "413th");
        this.check(421, f, "421st");
        this.check(422, f, "422nd");
        this.check(423, f, "423rd");
        this.check(411.2, f, "411th");
        this.check(420.5, f, "421st");
    }

    @Test
    public void testRomanNumerals() {
        Formatter f = Formatter.forNumbers((String)"FMRN");
        this.check(485, f, "CDLXXXV");
        f = Formatter.forNumbers((String)"RN");
        this.check(485, f, "        CDLXXXV");
        this.check(3888, f, "MMMDCCCLXXXVIII");
    }

    @Test
    public void testOverflow() {
        Formatter f = Formatter.forNumbers((String)"9");
        this.check(-10, f, "-#");
        this.check(Double.NaN, f, " #");
        f = Formatter.forNumbers((String)".9");
        this.check(-1, f, "-.#");
        this.check(Double.NaN, f, " .#");
        f = Formatter.forNumbers((String)"SG");
        this.check(-1, f, "-");
        this.check(Double.NaN, f, "+");
        f = Formatter.forNumbers((String)"9th");
        this.check(-10, f, "-#th");
        this.check(Double.NaN, f, " #  ");
        f = Formatter.forNumbers((String)"9.9EEEE");
        this.check(Double.NEGATIVE_INFINITY, f, "-#.#E+##");
        this.check(Double.NaN, f, " #.#E+##");
        f = Formatter.forNumbers((String)"FMRN");
        this.check(-1, f, "###############");
        this.check(0, f, "###############");
        this.check(4000, f, "###############");
        this.check(Double.NaN, f, "###############");
    }

    @Test
    public void testLiterals() {
        this.check(4.5, "  $4.5", " -$4.5", "M$99.9", "$99.9");
        this.check(4.5, "$  4.5", "$ -4.5", "F$M99.9", "F$99.9");
        this.check(4.5, " 4.5 USD ", "-4.5 USD ", "9.99 \"USD\"");
        this.check(4.5, " 4.5  USD", "-4.5  USD", "9.99 F\"USD\"");
        this.check(45.0, " 4.5", "-4.5", "9\".\"9", "9\\.9");
        this.check(45.0, " 450", "-450", "99\"0\"", "99\\0");
        Formatter f = Formatter.forNumbers((String)"FM\"Integer: \"999 \"Fraction: \".999");
        this.check(48.59, f, "Integer: 48 Fraction: .59");
        f = Formatter.forNumbers((String)"FM\\\"999\"\\\" + \\\"\".999\\\"");
        this.check(48.59, f, "\"48\" + \".59\"");
    }

    @Test
    public void testEscaping() {
        this.check("\"\\\"\"", "\"", "Quote in quotes");
        this.check("\"\\\"", "\"", "Quote in unpaired quotes");
        this.check("\\\"", "\"", "Quote not in quotes");
        this.check("\"", "", "Unescaped quote");
        this.check("\"\\\\\"", "\\", "Backslash in quotes");
        this.check("\"\\\\", "\\", "Backslash in unpaired quotes");
        this.check("\\\\", "\\", "Backslash not in quotes");
        this.check("\\", "\\", "Unescaped backslash");
        this.check("\"\\a\"", "a", "Unnecessary escape in quotes");
        this.check("\\a", "a", "Unnecessary escape not in quotes");
    }

    @Test
    public void testFillMode() {
        this.check(0.0, " 0", "-0", "9");
        this.check(0.0, "0", "-0", "FM9");
        this.check(0.0, " 0 ", "<0>", "B9");
        this.check(0.0, "0", "<0>", "FMB9");
        Formatter f = Formatter.forNumbers((String)"999 (RN)");
        this.check(0, f, "   0 ()               ");
        this.check(988, f, " 988 (CMLXXXVIII)     ");
    }

    @Test
    public void testLocales() {
        Formatter f = Formatter.forNumbers((String)"FM9G999D99 CR");
        this.check((Object)1234.56, f, "1,234.56 $", Locale.US);
        this.check((Object)1234.56, f, "1.234,56 \u20ba", TR);
        Locale fr_CH = new Locale("fr", "CH");
        f = Formatter.forNumbers((String)"FM9G999D99");
        this.check((Object)1234.56, f, "1\u202f234,56", fr_CH);
        f = Formatter.forNumbers((String)"FM9G999D99 CR");
        this.check((Object)1234.56, f, "1\u202f234.56 CHF", fr_CH);
    }

    @Test
    public void testFeatureOrthogonality() {
        Formatter f = Formatter.forNumbers((String)"FM999th +.99");
        this.check(421.35, f, "421st +.35");
        f = Formatter.forNumbers((String)"FM999.99th");
        this.check(421.35, f, "421.35st");
        f = Formatter.forNumbers((String)"FM999V99 -> RN");
        this.check(3.14, f, "314 -> CCCXIV");
    }

    @Test
    public void testLowercasePatterns() {
        Formatter f = Formatter.forDates((String)"yyyy-mm-dd fmhh:mi am tzfmtzh");
        this.check(LocalDateTime.of(2022, 9, 26, 14, 53).atOffset(ZoneOffset.ofHours(3)), f, "2022-09-26 2:53 pm gmt+3");
        f = Formatter.forNumbers((String)"fm9.99eeee");
        this.check(4.859E-4, f, "4.86e-04");
        f = Formatter.forNumbers((String)"fmrn");
        this.check(485, f, "cdlxxxv");
        f = Formatter.forNumbers((String)"9d99 f\"USD\"");
        this.check(4.5, f, " 4.5  USD");
    }

    @Test
    public void testEmptyOrIncompatibleFormat() {
        this.check(LocalDate.MIN, Formatter.forDates((String)""), "");
        this.check(0, Formatter.forNumbers((String)""), "");
        Assert.assertThrows((String)"Input parameter is expected to be date/time", QueryException.class, () -> Formatter.forDates((String)"YYYY-MM-DD").format((Object)0, Locale.US));
        Assert.assertThrows((String)"Input parameter is expected to be numeric", QueryException.class, () -> Formatter.forNumbers((String)"9").format((Object)LocalDate.MIN, Locale.US));
    }

    private void check(String literal, String expected, String message) {
        Assert.assertEquals((String)message, (Object)expected, (Object)Formatter.forDates((String)literal).format((Object)Year.of(0), Locale.US));
        Assert.assertEquals((String)message, (Object)expected, (Object)Formatter.forNumbers((String)("FM" + literal)).format((Object)0, Locale.US));
    }

    private void check(double input, String expectedPositive, String expectedNegative, String ... formats) {
        for (String format : formats) {
            Formatter f = Formatter.forNumbers((String)format);
            this.check(input, f, expectedPositive);
            this.check(-input, f, expectedNegative);
        }
    }

    private void check(Object input, Formatter f, String expected) {
        this.check(input, f, expected, Locale.US);
    }

    private void check(Object input, Formatter f, String expected, Locale locale) {
        Assert.assertEquals((Object)expected, (Object)f.format(input, locale));
    }

    @Test
    public void testDecimalFormat() {
        DecimalFormat df = new DecimalFormat("#.#");
        df.setRoundingMode(RoundingMode.HALF_UP);
        Assert.assertNotEquals((Object)"0.2", (Object)df.format(0.15));
    }
}

