/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.client;

import com.hazelcast.client.config.ClientSqlResubmissionMode;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.core.TopologyChangedException;
import com.hazelcast.jet.sql.SqlTestSupport;
import java.io.Serializable;
import java.util.HashMap;
import java.util.function.Supplier;

public abstract class SqlResubmissionTestSupport
extends SqlTestSupport {
    protected static final String FAILING_MAP_NAME = SqlResubmissionTestSupport.randomName();
    protected static final int COMMON_MAP_SIZE = 10000;
    protected static final String COMMON_MAP_NAME = SqlResubmissionTestSupport.randomName();

    protected boolean shouldFailAfterSomeDataIsFetched(ClientSqlResubmissionMode mode) {
        return mode == ClientSqlResubmissionMode.NEVER || mode == ClientSqlResubmissionMode.RETRY_SELECTS;
    }

    protected boolean shouldFailBeforeAnyDataIsFetched(ClientSqlResubmissionMode mode) {
        return mode == ClientSqlResubmissionMode.NEVER;
    }

    protected boolean shouldFailNonSelectQuery(ClientSqlResubmissionMode mode) {
        return mode != ClientSqlResubmissionMode.RETRY_ALL;
    }

    protected <T> void createMap(HazelcastInstance instance, String name, int size, Supplier<T> objectCreator, Class<T> tClass) {
        HashMap<Integer, T> map = new HashMap<Integer, T>();
        for (int i = 0; i < size; ++i) {
            map.put(i, objectCreator.get());
        }
        instance.getMap(name).putAll(map);
        SqlResubmissionTestSupport.createMapping(instance, name, Integer.class, tClass);
    }

    public static class IntHolder
    implements Serializable {
        private int field = 0;

        public IntHolder() {
        }

        public IntHolder(int field) {
            this.field = field;
        }

        public int getField() {
            return this.field;
        }

        public void setField(int field) {
            this.field = field;
        }
    }

    public static class FailingDuringFieldAccessObject
    implements Serializable {
        private int field = 0;

        public int getField() {
            throw new TopologyChangedException();
        }

        public void setField(int field) {
            this.field = field;
        }
    }
}

