/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.slf4j.testHarness;

import com.hazelcast.shaded.org.slf4j.Logger;
import com.hazelcast.shaded.org.slf4j.LoggerAccessingThread;
import com.hazelcast.shaded.org.slf4j.LoggerFactory;
import com.hazelcast.shaded.org.slf4j.event.EventRecordingLogger;
import com.hazelcast.shaded.org.slf4j.helpers.SubstituteLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Test;

public abstract class MultithreadedInitializationTest {
    protected static final int THREAD_COUNT = 4 + Runtime.getRuntime().availableProcessors() * 2;
    private final List<Logger> createdLoggers = Collections.synchronizedList(new ArrayList());
    protected final AtomicLong eventCount = new AtomicLong(0L);
    private final CyclicBarrier barrier = new CyclicBarrier(THREAD_COUNT + 1);

    @Test
    public void multiThreadedInitialization() throws InterruptedException, BrokenBarrierException {
        LoggerAccessingThread[] accessors = this.harness();
        Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
        logger.info("hello");
        this.eventCount.getAndIncrement();
        this.assertAllSubstLoggersAreFixed();
        long recordedEventCount = this.getRecordedEventCount();
        int LENIENCY_COUNT = 30;
        long expectedEventCount = this.eventCount.get() + (long)this.extraLogEvents();
        Assert.assertTrue((String)("unmet condition: " + expectedEventCount + " >= " + recordedEventCount), (expectedEventCount >= recordedEventCount ? 1 : 0) != 0);
        Assert.assertTrue((String)("unmet condition: " + expectedEventCount + " < " + recordedEventCount + "+" + LENIENCY_COUNT), (expectedEventCount < recordedEventCount + (long)LENIENCY_COUNT ? 1 : 0) != 0);
    }

    protected abstract long getRecordedEventCount();

    protected int extraLogEvents() {
        return 0;
    }

    private void assertAllSubstLoggersAreFixed() {
        for (Logger logger : this.createdLoggers) {
            SubstituteLogger substLogger;
            if (!(logger instanceof SubstituteLogger) || !((substLogger = (SubstituteLogger)logger).delegate() instanceof EventRecordingLogger)) continue;
            Assert.fail((String)("substLogger " + substLogger.getName() + " has a delegate of type EventRecodingLogger"));
        }
    }

    private LoggerAccessingThread[] harness() throws InterruptedException, BrokenBarrierException {
        int i;
        LoggerAccessingThread[] threads = new LoggerAccessingThread[THREAD_COUNT];
        for (i = 0; i < THREAD_COUNT; ++i) {
            threads[i] = new LoggerAccessingThread(this.barrier, this.createdLoggers, i, this.eventCount);
            threads[i].start();
        }
        this.barrier.await();
        for (i = 0; i < THREAD_COUNT; ++i) {
            threads[i].join();
        }
        return threads;
    }
}

