/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.slf4j.basicTests;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;

public class DoubleCheckedInt {
    static final int THREAD_COUNT = 10 + Runtime.getRuntime().availableProcessors() * 2;
    static final int UNINITIALIZED_STATE = 0;
    static final int ONGOING_INITIALIZATION = 1;
    static final int SUCCESS = 2;
    static final int FAILURE = 3;
    static final int NUMBER_OF_STATES = 4;
    private static int STATE = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getState() {
        if (STATE != 0) return STATE;
        Class<DoubleCheckedInt> clazz = DoubleCheckedInt.class;
        synchronized (DoubleCheckedInt.class) {
            if (STATE != 0) return STATE;
            STATE = 1;
            long r = System.nanoTime();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            STATE = r % 2L == 0L ? 2 : 3;
            // ** MonitorExit[var0] (shouldn't be in output)
            return STATE;
        }
    }

    public static void main(String[] args) throws InterruptedException, BrokenBarrierException {
        StateAccessingThread[] preInitializationThreads = DoubleCheckedInt.harness();
        DoubleCheckedInt.check(preInitializationThreads, false);
        System.out.println("============");
        StateAccessingThread[] postInitializationThreads = DoubleCheckedInt.harness();
        DoubleCheckedInt.check(postInitializationThreads, true);
    }

    private static StateAccessingThread[] harness() throws InterruptedException, BrokenBarrierException {
        int i;
        StateAccessingThread[] threads = new StateAccessingThread[THREAD_COUNT];
        CyclicBarrier barrier = new CyclicBarrier(THREAD_COUNT + 1);
        for (i = 0; i < THREAD_COUNT; ++i) {
            threads[i] = new StateAccessingThread(barrier);
            threads[i].start();
        }
        barrier.await();
        for (i = 0; i < THREAD_COUNT; ++i) {
            threads[i].join();
        }
        return threads;
    }

    private static void check(StateAccessingThread[] threads, boolean postInit) {
        int[] stateCount = DoubleCheckedInt.getStateCount(threads);
        DoubleCheckedInt.printStateCount(stateCount);
        if (stateCount[0] != 0) {
            throw new IllegalStateException("getState() should never return a zero value");
        }
        if (stateCount[2] != 0 && stateCount[3] != 0) {
            throw new IllegalStateException("getState() should return consistent values");
        }
        if (postInit && stateCount[2] != THREAD_COUNT && stateCount[3] != THREAD_COUNT) {
            throw new IllegalStateException("getState() should return consistent values");
        }
    }

    private static void printStateCount(int[] stateCount) {
        block6: for (int i = 0; i < 4; ++i) {
            switch (i) {
                case 0: {
                    System.out.println("UNINITIALIZED_STATE count: " + stateCount[i]);
                    continue block6;
                }
                case 1: {
                    System.out.println("ONGOING_INITIALIZATION count: " + stateCount[i]);
                    continue block6;
                }
                case 2: {
                    System.out.println("SUCCESS count: " + stateCount[i]);
                    continue block6;
                }
                case 3: {
                    System.out.println("FAILURE count: " + stateCount[i]);
                }
            }
        }
    }

    private static int[] getStateCount(StateAccessingThread[] threads) {
        int[] valCount = new int[4];
        for (StateAccessingThread thread : threads) {
            int val = thread.state;
            valCount[val] = valCount[val] + 1;
        }
        return valCount;
    }

    static class StateAccessingThread
    extends Thread {
        public int state = -1;
        final CyclicBarrier barrier;

        StateAccessingThread(CyclicBarrier barrier) {
            this.barrier = barrier;
        }

        @Override
        public void run() {
            try {
                this.barrier.await();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.state = DoubleCheckedInt.getState();
        }
    }
}

