/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.slf4j;

import com.hazelcast.shaded.org.slf4j.ILoggerFactory;
import com.hazelcast.shaded.org.slf4j.IMarkerFactory;
import com.hazelcast.shaded.org.slf4j.LoggerFactory;
import com.hazelcast.shaded.org.slf4j.spi.MDCAdapter;
import com.hazelcast.shaded.org.slf4j.spi.SLF4JServiceProvider;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LoggerFactoryTest {
    private PrintStream rawSyserr;
    private ByteArrayOutputStream mockedSyserr;
    final ClassLoader classLoaderOfLoggerFactory = LoggerFactory.class.getClassLoader();

    @Before
    public void setUp() {
        this.rawSyserr = System.err;
        this.mockedSyserr = new ByteArrayOutputStream();
        System.setErr(new PrintStream(this.mockedSyserr));
    }

    @After
    public void cleanUp() {
        System.clearProperty("slf4j.provider");
        System.setErr(this.rawSyserr);
    }

    @Test
    public void testExplicitlySpecified() {
        System.setProperty("slf4j.provider", "com.hazelcast.shaded.org.slf4j.LoggerFactoryTest$TestingProvider");
        SLF4JServiceProvider provider = LoggerFactory.loadExplicitlySpecified((ClassLoader)this.classLoaderOfLoggerFactory);
        Assert.assertTrue((String)"provider should be instance of TestingProvider class", (boolean)(provider instanceof TestingProvider));
        Assert.assertTrue((boolean)this.mockedSyserr.toString().contains(" Attempting to load provider \"org.slf4j.LoggerFactoryTest$TestingProvider\" specified via \"slf4j.provider\" system property"));
        System.out.println(this.mockedSyserr.toString());
    }

    @Test
    public void testExplicitlySpecifiedNull() {
        Assert.assertNull((Object)LoggerFactory.loadExplicitlySpecified((ClassLoader)this.classLoaderOfLoggerFactory));
    }

    @Test
    public void testExplicitlySpecifyMissingServiceProvider() {
        System.setProperty("slf4j.provider", "com.example.ServiceProvider");
        SLF4JServiceProvider provider = LoggerFactory.loadExplicitlySpecified((ClassLoader)this.classLoaderOfLoggerFactory);
        Assert.assertNull((Object)provider);
        Assert.assertTrue((boolean)this.mockedSyserr.toString().contains("Failed to instantiate the specified SLF4JServiceProvider (com.example.ServiceProvider)"));
    }

    @Test
    public void testExplicitlySpecifyNonServiceProvider() {
        System.setProperty("slf4j.provider", "java.lang.String");
        Assert.assertNull((Object)LoggerFactory.loadExplicitlySpecified((ClassLoader)this.classLoaderOfLoggerFactory));
        Assert.assertTrue((boolean)this.mockedSyserr.toString().contains("Specified SLF4JServiceProvider (java.lang.String) does not implement SLF4JServiceProvider interface"));
    }

    public static class TestingProvider
    implements SLF4JServiceProvider {
        public ILoggerFactory getLoggerFactory() {
            return null;
        }

        public IMarkerFactory getMarkerFactory() {
            return null;
        }

        public MDCAdapter getMDCAdapter() {
            return null;
        }

        public String getRequestedApiVersion() {
            return null;
        }

        public void initialize() {
        }
    }
}

