/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.slf4j;

import com.hazelcast.shaded.org.slf4j.Logger;
import com.hazelcast.shaded.org.slf4j.LoggerFactory;
import java.util.List;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicLong;

public class LoggerAccessingThread
extends Thread {
    private static final int LOOP_LEN = 32;
    final CyclicBarrier barrier;
    final int count;
    final AtomicLong eventCount;
    List<Logger> loggerList;

    public LoggerAccessingThread(CyclicBarrier barrier, List<Logger> loggerList, int count, AtomicLong eventCount) {
        this.barrier = barrier;
        this.loggerList = loggerList;
        this.count = count;
        this.eventCount = eventCount;
    }

    @Override
    public void run() {
        try {
            this.barrier.await();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String loggerNamePrefix = this.getClass().getName();
        for (int i = 0; i < 32; ++i) {
            Logger logger = LoggerFactory.getLogger((String)(loggerNamePrefix + "-" + this.count + "-" + i));
            this.loggerList.add(logger);
            Thread.yield();
            logger.info("in run method");
            this.eventCount.getAndIncrement();
        }
    }
}

