/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.valid;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryCollection;
import com.hazelcast.shaded.org.locationtech.jts.geom.LinearRing;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTReader;
import com.hazelcast.shaded.org.locationtech.jts.operation.valid.IsValidOp;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class ValidClosedRingTest
extends TestCase {
    private static WKTReader rdr = new WKTReader();

    public ValidClosedRingTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(ValidClosedRingTest.class);
    }

    public void testBadLinearRing() {
        LinearRing ring = (LinearRing)this.fromWKT("LINEARRING (0 0, 0 10, 10 10, 10 0, 0 0)");
        this.updateNonClosedRing(ring);
        this.checkIsValid((Geometry)ring, false);
    }

    public void testGoodLinearRing() {
        LinearRing ring = (LinearRing)this.fromWKT("LINEARRING (0 0, 0 10, 10 10, 10 0, 0 0)");
        this.checkIsValid((Geometry)ring, true);
    }

    public void testBadPolygonShell() {
        Polygon poly = (Polygon)this.fromWKT("POLYGON ((0 0, 0 10, 10 10, 10 0, 0 0))");
        this.updateNonClosedRing(poly.getExteriorRing());
        this.checkIsValid((Geometry)poly, false);
    }

    public void testBadPolygonHole() {
        Polygon poly = (Polygon)this.fromWKT("POLYGON ((0 0, 0 10, 10 10, 10 0, 0 0), (1 1, 2 1, 2 2, 1 2, 1 1) ))");
        this.updateNonClosedRing(poly.getInteriorRingN(0));
        this.checkIsValid((Geometry)poly, false);
    }

    public void testGoodPolygon() {
        Polygon poly = (Polygon)this.fromWKT("POLYGON ((0 0, 0 10, 10 10, 10 0, 0 0))");
        this.checkIsValid((Geometry)poly, true);
    }

    public void testBadGeometryCollection() {
        GeometryCollection gc = (GeometryCollection)this.fromWKT("GEOMETRYCOLLECTION ( POLYGON ((0 0, 0 10, 10 10, 10 0, 0 0), (1 1, 2 1, 2 2, 1 2, 1 1) )), POINT(0 0) )");
        Polygon poly = (Polygon)gc.getGeometryN(0);
        this.updateNonClosedRing(poly.getInteriorRingN(0));
        this.checkIsValid((Geometry)poly, false);
    }

    private void checkIsValid(Geometry geom, boolean expected) {
        IsValidOp validator = new IsValidOp(geom);
        boolean isValid = validator.isValid();
        ValidClosedRingTest.assertTrue((isValid == expected ? 1 : 0) != 0);
    }

    Geometry fromWKT(String wkt) {
        Geometry geom = null;
        try {
            geom = rdr.read(wkt);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return geom;
    }

    private void updateNonClosedRing(LinearRing ring) {
        Coordinate[] pts = ring.getCoordinates();
        pts[0].x += 1.0E-4;
    }
}

