/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.overlayng;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.PrecisionUtil;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class PrecisionUtilTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(PrecisionUtilTest.class);
    }

    public PrecisionUtilTest(String name) {
        super(name);
    }

    public void testInts() {
        this.checkRobustScale("POINT(1 1)", "POINT(10 10)", 1.0, 1.0E12, 1.0);
    }

    public void testBNull() {
        this.checkRobustScale("POINT(1 1)", null, 1.0, 1.0E13, 1.0);
    }

    public void testPower10() {
        this.checkRobustScale("POINT(100 100)", "POINT(1000 1000)", 1.0, 1.0E11, 1.0);
    }

    public void testDecimalsDifferent() {
        this.checkRobustScale("POINT( 1.123 1.12 )", "POINT( 10.123 10.12345 )", 100000.0, 1.0E12, 100000.0);
    }

    public void testDecimalsShort() {
        this.checkRobustScale("POINT(1 1.12345)", "POINT(10 10)", 100000.0, 1.0E12, 100000.0);
    }

    public void testDecimalsMany() {
        this.checkRobustScale("POINT(1 1.123451234512345)", "POINT(10 10)", 1.0E12, 1.0E12, 1.0E15);
    }

    public void testDecimalsAllLong() {
        this.checkRobustScale("POINT( 1.123451234512345 1.123451234512345 )", "POINT( 10.123451234512345 10.123451234512345 )", 1.0E12, 1.0E12, 1.0E15);
    }

    public void testSafeScaleChosen() {
        this.checkRobustScale("POINT( 123123.123451234512345 1 )", "POINT( 10 10 )", 1.0E8, 1.0E8, 1.0E11);
    }

    public void testSafeScaleChosenLargeMagnitude() {
        this.checkRobustScale("POINT( 123123123.123451234512345 1 )", "POINT( 10 10 )", 100000.0, 100000.0, 1.0E8);
    }

    public void testInherentWithLargeMagnitude() {
        this.checkRobustScale("POINT( 123123123.12 1 )", "POINT( 10 10 )", 100.0, 100000.0, 100.0);
    }

    public void testMixedMagnitude() {
        this.checkRobustScale("POINT( 1.123451234512345 1 )", "POINT( 100000.12345 10 )", 1.0E8, 1.0E8, 1.0E15);
    }

    public void testInherentBelowSafe() {
        this.checkRobustScale("POINT( 100000.1234512 1 )", "POINT( 100000.12345 10 )", 1.0E7, 1.0E8, 1.0E7);
    }

    private void checkRobustScale(String wktA, String wktB, double scaleExpected, double safeScaleExpected, double inherentScaleExpected) {
        Geometry a = this.read(wktA);
        Geometry b = null;
        if (wktB != null) {
            b = this.read(wktB);
        }
        double robustScale = PrecisionUtil.robustScale((Geometry)a, b);
        PrecisionUtilTest.assertEquals((String)"Auto scale: ", (Object)scaleExpected, (Object)robustScale);
        PrecisionUtilTest.assertEquals((String)"Inherent scale: ", (Object)inherentScaleExpected, (Object)PrecisionUtil.inherentScale((Geometry)a, (Geometry)b));
        PrecisionUtilTest.assertEquals((String)"Safe scale: ", (Object)safeScaleExpected, (Object)PrecisionUtil.safeScale((Geometry)a, (Geometry)b));
    }
}

