/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.overlayng;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.OverlayNG;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class OverlayNGStrictModeTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(OverlayNGStrictModeTest.class);
    }

    public OverlayNGStrictModeTest(String name) {
        super(name);
    }

    public void testPolygonTouchALPIntersection() {
        Geometry a = this.read("POLYGON ((10 10, 10 30, 30 30, 30 10, 10 10))");
        Geometry b = this.read("POLYGON ((40 10, 30 10, 35 15, 30 15, 30 20, 35 20, 25 30, 40 30, 40 10))");
        Geometry expected = this.read("POLYGON ((30 25, 25 30, 30 30, 30 25))");
        Geometry actual = OverlayNGStrictModeTest.intersection(a, b);
        this.checkEqual(expected, actual);
    }

    public void testPolygonTouchALIntersection() {
        Geometry a = this.read("POLYGON ((10 30, 60 30, 60 10, 10 10, 10 30))");
        Geometry b = this.read("POLYGON ((10 50, 60 50, 60 30, 30 30, 10 10, 10 50))");
        Geometry expected = this.read("POLYGON ((30 30, 10 10, 10 30, 30 30))");
        Geometry actual = OverlayNGStrictModeTest.intersection(a, b);
        this.checkEqual(expected, actual);
    }

    public void testPolygonTouchLPIntersection() {
        Geometry a = this.read("POLYGON ((10 10, 10 30, 30 30, 30 10, 10 10))");
        Geometry b = this.read("POLYGON ((40 25, 30 25, 30 20, 35 20, 30 15, 40 15, 40 25))");
        Geometry expected = this.read("LINESTRING (30 25, 30 20)");
        Geometry actual = OverlayNGStrictModeTest.intersection(a, b);
        this.checkEqual(expected, actual);
    }

    public void testLineTouchLPIntersection() {
        Geometry a = this.read("LINESTRING (10 10, 20 10, 20 20, 30 10)");
        Geometry b = this.read("LINESTRING (10 10, 30 10)");
        Geometry expected = this.read("LINESTRING (10 10, 20 10)");
        Geometry actual = OverlayNGStrictModeTest.intersection(a, b);
        this.checkEqual(expected, actual);
    }

    public void testPolygonResultMixedIntersection() {
        Geometry a = this.read("POLYGON ((10 30, 60 30, 60 10, 10 10, 10 30))");
        Geometry b = this.read("POLYGON ((10 50, 60 50, 60 30, 30 30, 10 10, 10 50))");
        Geometry expected = this.read("POLYGON ((30 30, 10 10, 10 30, 30 30))");
        Geometry actual = OverlayNGStrictModeTest.intersection(a, b);
        this.checkEqual(expected, actual);
    }

    public void testPolygonResultLineIntersection() {
        Geometry a = this.read("POLYGON ((10 20, 20 20, 20 10, 10 10, 10 20))");
        Geometry b = this.read("POLYGON ((30 20, 30 10, 20 10, 20 20, 30 20))");
        Geometry expected = this.read("LINESTRING (20 20, 20 10)");
        Geometry actual = OverlayNGStrictModeTest.intersection(a, b);
        this.checkEqual(expected, actual);
    }

    public void testPolygonLineSymDifference() {
        Geometry a = this.read("POLYGON ((10 20, 20 20, 20 10, 10 10, 10 20))");
        Geometry b = this.read("LINESTRING (15 15, 25 15)");
        Geometry expected = this.read("GEOMETRYCOLLECTION (POLYGON ((20 20, 20 15, 20 10, 10 10, 10 20, 20 20)), LINESTRING (20 15, 25 15))");
        Geometry actual = OverlayNGStrictModeTest.symDifference(a, b);
        this.checkEqual(expected, actual);
    }

    public void testPolygonLineUnion() {
        Geometry a = this.read("POLYGON ((10 20, 20 20, 20 10, 10 10, 10 20))");
        Geometry b = this.read("LINESTRING (15 15, 25 15)");
        Geometry expected = this.read("GEOMETRYCOLLECTION (POLYGON ((20 20, 20 15, 20 10, 10 10, 10 20, 20 20)), LINESTRING (20 15, 25 15))");
        Geometry actual = OverlayNGStrictModeTest.union(a, b);
        this.checkEqual(expected, actual);
    }

    public void testPolygonIntersectionCollapse() {
        Geometry a = this.read("POLYGON ((1 1, 1 5, 3 5, 3 2, 9 1, 1 1))");
        Geometry b = this.read("POLYGON ((7 5, 9 5, 9 1, 7 1, 7 5))");
        Geometry expected = this.read("POLYGON EMPTY");
        Geometry actual = OverlayNGStrictModeTest.intersection(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void testPolygonUnionCollapse() {
        Geometry a = this.read("POLYGON ((1 1, 1 5, 3 5, 3 1.4, 7 1, 1 1))");
        Geometry b = this.read("POLYGON ((7 5, 9 5, 9 1, 7 1, 7 5))");
        Geometry expected = this.read("MULTIPOLYGON (((1 1, 1 5, 3 5, 3 1, 1 1)), ((7 1, 7 5, 9 5, 9 1, 7 1)))");
        Geometry actual = OverlayNGStrictModeTest.union(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    static Geometry intersection(Geometry a, Geometry b) {
        return OverlayNGStrictModeTest.overlay(a, b, 1);
    }

    static Geometry symDifference(Geometry a, Geometry b) {
        return OverlayNGStrictModeTest.overlay(a, b, 4);
    }

    static Geometry union(Geometry a, Geometry b) {
        return OverlayNGStrictModeTest.overlay(a, b, 2);
    }

    static Geometry overlay(Geometry a, Geometry b, int opCode) {
        OverlayNG ov = new OverlayNG(a, b, opCode);
        ov.setStrictMode(true);
        return ov.getResult();
    }

    static Geometry intersection(Geometry a, Geometry b, double scaleFactor) {
        return OverlayNGStrictModeTest.overlay(a, b, scaleFactor, 1);
    }

    static Geometry union(Geometry a, Geometry b, double scaleFactor) {
        return OverlayNGStrictModeTest.overlay(a, b, scaleFactor, 2);
    }

    static Geometry overlay(Geometry a, Geometry b, double scaleFactor, int opCode) {
        PrecisionModel pm = new PrecisionModel(scaleFactor);
        OverlayNG ov = new OverlayNG(a, b, pm, opCode);
        ov.setStrictMode(true);
        return ov.getResult();
    }
}

