/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.overlayng;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.ElevationModel;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class ElevationModelTest
extends GeometryTestCase {
    private static final double TOLERANCE = 1.0E-5;

    public static void main(String[] args) {
        TestRunner.run(ElevationModelTest.class);
    }

    public ElevationModelTest(String name) {
        super(name);
    }

    public void testBox() {
        this.checkElevation("POLYGON Z ((1 6 50, 9 6 60, 9 4 50, 1 4 40, 1 6 50))", 0.0, 10.0, 50.0, 5.0, 10.0, 50.0, 10.0, 10.0, 60.0, 0.0, 5.0, 50.0, 5.0, 5.0, 50.0, 10.0, 5.0, 50.0, 0.0, 4.0, 40.0, 5.0, 4.0, 50.0, 10.0, 4.0, 50.0, 0.0, 0.0, 40.0, 5.0, 0.0, 50.0, 10.0, 0.0, 50.0);
    }

    public void testLine() {
        this.checkElevation("LINESTRING Z (0 0 0, 10 10 10)", -1.0, 11.0, 5.0, 11.0, 11.0, 10.0, 0.0, 10.0, 5.0, 5.0, 10.0, 5.0, 10.0, 10.0, 10.0, 0.0, 5.0, 5.0, 5.0, 5.0, 5.0, 10.0, 5.0, 5.0, 0.0, 0.0, 0.0, 5.0, 0.0, 5.0, 10.0, 0.0, 5.0, -1.0, -1.0, 0.0, 5.0, -1.0, 5.0, 11.0, -1.0, 5.0);
    }

    public void testPopulateZLine() {
        this.checkElevationPopulateZ("LINESTRING Z (0 0 0, 10 10 10)", "LINESTRING (1 1, 9 9)", "LINESTRING (1 1 0, 9 9 10)");
    }

    public void testPopulateZBox() {
        this.checkElevationPopulateZ("LINESTRING Z (0 0 0, 10 10 10)", "POLYGON ((1 9, 9 9, 9 1, 1 1, 1 9))", "POLYGON Z ((1 1 0, 1 9 5, 9 9 10, 9 1 5, 1 1 0))");
    }

    public void testMultiLine() {
        this.checkElevation("MULTILINESTRING Z ((0 0 0, 10 10 8), (1 2 2, 9 8 6))", -1.0, 11.0, 4.0, 11.0, 11.0, 7.0, 0.0, 10.0, 4.0, 5.0, 10.0, 4.0, 10.0, 10.0, 7.0, 0.0, 5.0, 4.0, 5.0, 5.0, 4.0, 10.0, 5.0, 4.0, 0.0, 0.0, 1.0, 5.0, 0.0, 4.0, 10.0, 0.0, 4.0, -1.0, -1.0, 1.0, 5.0, -1.0, 4.0, 11.0, -1.0, 4.0);
    }

    public void testTwoLines() {
        this.checkElevation("LINESTRING Z (0 0 0, 10 10 8)", "LINESTRING Z (1 2 2, 9 8 6))", -1.0, 11.0, 4.0, 11.0, 11.0, 7.0, 0.0, 10.0, 4.0, 5.0, 10.0, 4.0, 10.0, 10.0, 7.0, 0.0, 5.0, 4.0, 5.0, 5.0, 4.0, 10.0, 5.0, 4.0, 0.0, 0.0, 1.0, 5.0, 0.0, 4.0, 10.0, 0.0, 4.0, -1.0, -1.0, 1.0, 5.0, -1.0, 4.0, 11.0, -1.0, 4.0);
    }

    public void testLine2D() {
        this.checkElevation("0102000000020000000000000000000000000000000000000000000000000024400000000000002440", 5.0, 5.0, Double.NaN);
    }

    public void testLineHorizontal() {
        this.checkElevation("LINESTRING Z (0 5 0, 10 5 10)", 0.0, 10.0, 0.0, 5.0, 10.0, 5.0, 10.0, 10.0, 10.0, 0.0, 5.0, 0.0, 5.0, 5.0, 5.0, 10.0, 5.0, 10.0, 0.0, 0.0, 0.0, 5.0, 0.0, 5.0, 10.0, 0.0, 10.0);
    }

    public void testLineVertical() {
        this.checkElevation("LINESTRING Z (5 0 0, 5 10 10)", 0.0, 10.0, 10.0, 5.0, 10.0, 10.0, 10.0, 10.0, 10.0, 0.0, 5.0, 5.0, 5.0, 5.0, 5.0, 10.0, 5.0, 5.0, 0.0, 0.0, 0.0, 5.0, 0.0, 0.0, 10.0, 0.0, 0.0);
    }

    public void testPoint() {
        this.checkElevation("POINT Z (5 5 5)", 0.0, 9.0, 5.0, 5.0, 9.0, 5.0, 9.0, 9.0, 5.0, 0.0, 5.0, 5.0, 5.0, 5.0, 5.0, 9.0, 5.0, 5.0, 0.0, 0.0, 5.0, 5.0, 0.0, 5.0, 9.0, 0.0, 5.0);
    }

    public void testMultiPointSame() {
        this.checkElevation("MULTIPOINT Z ((5 5 5), (5 5 9))", 0.0, 9.0, 7.0, 5.0, 9.0, 7.0, 9.0, 9.0, 7.0, 0.0, 5.0, 7.0, 5.0, 5.0, 7.0, 9.0, 5.0, 7.0, 0.0, 0.0, 7.0, 5.0, 0.0, 7.0, 9.0, 0.0, 7.0);
    }

    private void checkElevation(String wkt1, String wkt2, double ... ords) {
        this.checkElevation(this.read(wkt1), this.read(wkt2), ords);
    }

    private void checkElevation(String wkt1, double ... ords) {
        this.checkElevation(this.read(wkt1), null, ords);
    }

    private void checkElevation(Geometry geom1, Geometry geom2, double[] ords) {
        ElevationModel model = ElevationModel.create((Geometry)geom1, (Geometry)geom2);
        int numPts = ords.length / 3;
        if (3 * numPts != ords.length) {
            throw new IllegalArgumentException("Incorrect number of ordinates");
        }
        for (int i = 0; i < numPts; ++i) {
            double x = ords[3 * i];
            double y = ords[3 * i + 1];
            double expectedZ = ords[3 * i + 2];
            double actualZ = model.getZ(x, y);
            String msg = "Point ( " + x + ", " + y + " ) : ";
            ElevationModelTest.assertEquals((String)msg, (double)expectedZ, (double)actualZ, (double)1.0E-5);
        }
    }

    private void checkElevationPopulateZ(String wkt, String wktNoZ, String wktZExpected) {
        Geometry geom = this.read(wkt);
        ElevationModel model = ElevationModel.create((Geometry)geom, null);
        Geometry geomNoZ = this.read(wktNoZ);
        model.populateZ(geomNoZ);
        Geometry geomZExpected = this.read(wktZExpected);
        this.checkEqualXYZ(geomZExpected, geomNoZ);
    }
}

