/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.noding;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.util.LineStringExtracter;
import com.hazelcast.shaded.org.locationtech.jts.noding.NodedSegmentString;
import com.hazelcast.shaded.org.locationtech.jts.noding.Noder;
import com.hazelcast.shaded.org.locationtech.jts.noding.ValidatingNoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NodingTestUtil {
    public static Geometry toLines(Collection<NodedSegmentString> nodedList, GeometryFactory geomFact) {
        LineString[] lines = new LineString[nodedList.size()];
        int i = 0;
        for (NodedSegmentString nss : nodedList) {
            Coordinate[] pts = nss.getCoordinates();
            LineString line = geomFact.createLineString(pts);
            lines[i++] = line;
        }
        if (lines.length == 1) {
            return lines[0];
        }
        return geomFact.createMultiLineString(lines);
    }

    public static List<NodedSegmentString> toSegmentStrings(List<LineString> lines) {
        ArrayList<NodedSegmentString> nssList = new ArrayList<NodedSegmentString>();
        for (LineString line : lines) {
            NodedSegmentString nss = new NodedSegmentString(line.getCoordinates(), (Object)line);
            nssList.add(nss);
        }
        return nssList;
    }

    public static List<NodedSegmentString> getNodedSubstrings(NodedSegmentString nss) {
        ArrayList<NodedSegmentString> resultEdgelist = new ArrayList<NodedSegmentString>();
        nss.getNodeList().addSplitEdges(resultEdgelist);
        return resultEdgelist;
    }

    public static Geometry nodeValidated(Geometry geom1, Geometry geom2, Noder noder) {
        List lines = LineStringExtracter.getLines((Geometry)geom1);
        if (geom2 != null) {
            lines.addAll(LineStringExtracter.getLines((Geometry)geom2));
        }
        List<NodedSegmentString> ssList = NodingTestUtil.toSegmentStrings(lines);
        ValidatingNoder noderValid = new ValidatingNoder(noder);
        noderValid.computeNodes(ssList);
        Collection nodedList = noder.getNodedSubstrings();
        Geometry result = NodingTestUtil.toLines(nodedList, geom1.getFactory());
        return result;
    }

    public NodedSegmentString createNSS(double ... ords) {
        if (ords.length % 2 != 0) {
            throw new IllegalArgumentException("Must provide pairs of ordinates");
        }
        Coordinate[] pts = new Coordinate[ords.length / 2];
        for (int i = 0; i <= ords.length; i += 2) {
            Coordinate p;
            pts[i / 2] = p = new Coordinate(ords[i], ords[i + 1]);
        }
        NodedSegmentString nss = new NodedSegmentString(pts, null);
        return nss;
    }
}

