/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.noding;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.noding.NodedSegmentString;
import com.hazelcast.shaded.org.locationtech.jts.noding.NodingTestUtil;
import java.util.List;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class NodedSegmentStringTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(NodedSegmentStringTest.class);
    }

    public NodedSegmentStringTest(String name) {
        super(name);
    }

    public void testSegmentNodeOrderingForSnappedNodes() {
        this.checkNoding("LINESTRING (655103.6628454948 1794805.456674405, 655016.20226 1794940.10998, 655014.8317182435 1794941.5196832407)", "MULTIPOINT((655016.29615051334 1794939.965427252), (655016.20226531825 1794940.1099718122), (655016.20226 1794940.10998), (655016.20225819293 1794940.1099794197))", new int[]{0, 0, 1, 1}, "MULTILINESTRING ((655014.8317182435 1794941.5196832407, 655016.2022581929 1794940.1099794197), (655016.2022581929 1794940.1099794197, 655016.20226 1794940.10998), (655016.20226 1794940.10998, 655016.2022653183 1794940.1099718122), (655016.2022653183 1794940.1099718122, 655016.2961505133 1794939.965427252), (655016.2961505133 1794939.965427252, 655103.6628454948 1794805.456674405))");
    }

    private void checkNoding(String wktLine, String wktNodes, int[] segmentIndex, String wktExpected) {
        Geometry line = this.read(wktLine);
        Geometry pts = this.read(wktNodes);
        NodedSegmentString nss = new NodedSegmentString(line.getCoordinates(), null);
        Coordinate[] node = pts.getCoordinates();
        for (int i = 0; i < node.length; ++i) {
            nss.addIntersection(node[i], segmentIndex[i]);
        }
        List<NodedSegmentString> nodedSS = NodingTestUtil.getNodedSubstrings(nss);
        Geometry result = NodingTestUtil.toLines(nodedSS, line.getFactory());
        Geometry expected = this.read(wktExpected);
        this.checkEqual(expected, result);
    }
}

