/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.math;

import com.hazelcast.shaded.org.locationtech.jts.math.DD;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class DDBasicTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(DDBasicTest.class);
    }

    public DDBasicTest(String name) {
        super(name);
    }

    public void testNaN() {
        DDBasicTest.assertTrue((boolean)DD.valueOf((double)1.0).divide(DD.valueOf((double)0.0)).isNaN());
        DDBasicTest.assertTrue((boolean)DD.valueOf((double)1.0).multiply(DD.NaN).isNaN());
    }

    public void testAddMult2() {
        this.checkAddMult2(new DD(3.0));
        this.checkAddMult2(DD.PI);
    }

    public void testMultiplyDivide() {
        this.checkMultiplyDivide(DD.PI, DD.E, 1.0E-30);
        this.checkMultiplyDivide(DD.TWO_PI, DD.E, 1.0E-30);
        this.checkMultiplyDivide(DD.PI_2, DD.E, 1.0E-30);
        this.checkMultiplyDivide(new DD(39.4), new DD(10.0), 1.0E-30);
    }

    public void testDivideMultiply() {
        this.checkDivideMultiply(DD.PI, DD.E, 1.0E-30);
        this.checkDivideMultiply(new DD(39.4), new DD(10.0), 1.0E-30);
    }

    public void testSqrt() {
        this.checkSqrt(DD.PI, 1.0E-30);
        this.checkSqrt(DD.E, 1.0E-30);
        this.checkSqrt(new DD(999.0), 1.0E-28);
    }

    private void checkSqrt(DD x, double errBound) {
        DD sqrt = x.sqrt();
        DD x2 = sqrt.multiply(sqrt);
        this.checkErrorBound("Sqrt", x, x2, errBound);
    }

    public void testTrunc() {
        this.checkTrunc(DD.valueOf((double)1.0E16).subtract(DD.valueOf((double)1.0)), DD.valueOf((double)1.0E16).subtract(DD.valueOf((double)1.0)));
        this.checkTrunc(DD.PI, DD.valueOf((double)3.0));
        this.checkTrunc(DD.valueOf((double)999.999), DD.valueOf((double)999.0));
        this.checkTrunc(DD.E.negate(), DD.valueOf((double)-2.0));
        this.checkTrunc(DD.valueOf((double)-999.999), DD.valueOf((double)-999.0));
    }

    private void checkTrunc(DD x, DD expected) {
        DD trunc = x.trunc();
        boolean isEqual = trunc.equals(expected);
        DDBasicTest.assertTrue((boolean)isEqual);
    }

    public void testPow() {
        this.checkPow(0.0, 3, 1.972152263052528E-31);
        this.checkPow(14.0, 3, 1.972152263052528E-31);
        this.checkPow(3.0, -5, 1.972152263052528E-31);
        this.checkPow(-3.0, 5, 1.972152263052528E-31);
        this.checkPow(-3.0, -5, 1.972152263052528E-31);
        this.checkPow(0.12345, -5, 1.23259516440783E-27);
    }

    public void testReciprocal() {
        this.checkReciprocal(3.0, 0.0);
        this.checkReciprocal(99.0, 1.0E-29);
        this.checkReciprocal(999.0, 0.0);
        this.checkReciprocal(3.14159269E8, 0.0);
    }

    public void testDeterminant() {
        this.checkDeterminant(3.0, 8.0, 4.0, 6.0, -14.0, 0.0);
        this.checkDeterminantDD(3.0, 8.0, 4.0, 6.0, -14.0, 0.0);
    }

    public void testDeterminantRobust() {
        this.checkDeterminant(1.0E9, 9.99999999E8, 9.99999999E8, 9.99999998E8, -1.0, 0.0);
        this.checkDeterminantDD(1.0E9, 9.99999999E8, 9.99999999E8, 9.99999998E8, -1.0, 0.0);
    }

    private void checkDeterminant(double x1, double y1, double x2, double y2, double expected, double errBound) {
        DD det = DD.determinant((double)x1, (double)y1, (double)x2, (double)y2);
        this.checkErrorBound("Determinant", det, DD.valueOf((double)expected), errBound);
    }

    private void checkDeterminantDD(double x1, double y1, double x2, double y2, double expected, double errBound) {
        DD det = DD.determinant((DD)DD.valueOf((double)x1), (DD)DD.valueOf((double)y1), (DD)DD.valueOf((double)x2), (DD)DD.valueOf((double)y2));
        this.checkErrorBound("Determinant", det, DD.valueOf((double)expected), errBound);
    }

    public void testBinom() {
        this.checkBinomialSquare(100.0, 1.0);
        this.checkBinomialSquare(1000.0, 1.0);
        this.checkBinomialSquare(10000.0, 1.0);
        this.checkBinomialSquare(100000.0, 1.0);
        this.checkBinomialSquare(1000000.0, 1.0);
        this.checkBinomialSquare(1.0E8, 1.0);
        this.checkBinomialSquare(1.0E10, 1.0);
        this.checkBinomialSquare(1.0E14, 1.0);
        this.checkBinomialSquare(1.0E14, 291.0);
        this.checkBinomialSquare(5.0E14, 291.0);
        this.checkBinomialSquare(5.0E14, 345291.0);
    }

    private void checkAddMult2(DD dd) {
        DD sum = dd.add(dd);
        DD prod = dd.multiply(new DD(2.0));
        this.checkErrorBound("AddMult2", sum, prod, 0.0);
    }

    private void checkMultiplyDivide(DD a, DD b, double errBound) {
        DD a2 = a.multiply(b).divide(b);
        this.checkErrorBound("MultiplyDivide", a, a2, errBound);
    }

    private void checkDivideMultiply(DD a, DD b, double errBound) {
        DD a2 = a.divide(b).multiply(b);
        this.checkErrorBound("DivideMultiply", a, a2, errBound);
    }

    private DD delta(DD x, DD y) {
        return x.subtract(y).abs();
    }

    private void checkErrorBound(String tag, DD x, DD y, double errBound) {
        boolean isWithinEps;
        DD err = x.subtract(y).abs();
        boolean bl = isWithinEps = err.doubleValue() <= errBound;
        if (!isWithinEps) {
            System.out.println("checkErrorBound: " + tag + " val1 = " + x + " val2 = " + y + "  err=" + err);
        }
        DDBasicTest.assertTrue((boolean)isWithinEps);
    }

    void checkBinomialSquare(double a, double b) {
        DD add = new DD(a);
        DD bdd = new DD(b);
        DD aPlusb = add.add(bdd);
        DD abSq = aPlusb.multiply(aPlusb);
        DD a2dd = add.multiply(add);
        DD b2dd = bdd.multiply(bdd);
        DD ab = add.multiply(bdd);
        DD sum = b2dd.add(ab).add(ab);
        DD diff = abSq.subtract(a2dd);
        DD delta = diff.subtract(sum);
        this.printBinomialSquareDouble(a, b);
        boolean isSame = diff.equals(sum);
        DDBasicTest.assertTrue((boolean)isSame);
        boolean isDeltaZero = delta.isZero();
        DDBasicTest.assertTrue((boolean)isDeltaZero);
    }

    void printBinomialSquareDouble(double a, double b) {
        double sum = 2.0 * a * b + b * b;
        double diff = (a + b) * (a + b) - a * a;
    }

    public void testBinomial2() {
        this.checkBinomial2(100.0, 1.0);
        this.checkBinomial2(1000.0, 1.0);
        this.checkBinomial2(10000.0, 1.0);
        this.checkBinomial2(100000.0, 1.0);
        this.checkBinomial2(1000000.0, 1.0);
        this.checkBinomial2(1.0E8, 1.0);
        this.checkBinomial2(1.0E10, 1.0);
        this.checkBinomial2(1.0E14, 1.0);
        this.checkBinomial2(1.0E14, 291.0);
        this.checkBinomial2(5.0E14, 291.0);
        this.checkBinomial2(5.0E14, 345291.0);
    }

    void checkBinomial2(double a, double b) {
        DD add = new DD(a);
        DD bdd = new DD(b);
        DD aPlusb = add.add(bdd);
        DD aSubb = add.subtract(bdd);
        DD abProd = aPlusb.multiply(aSubb);
        DD a2dd = add.multiply(add);
        DD b2dd = bdd.multiply(bdd);
        DD diff = abProd.subtract(a2dd).negate();
        DD delta = diff.subtract(b2dd);
        boolean isSame = diff.equals(b2dd);
        DDBasicTest.assertTrue((boolean)isSame);
        boolean isDeltaZero = delta.isZero();
        DDBasicTest.assertTrue((boolean)isDeltaZero);
    }

    private void checkReciprocal(double x, double errBound) {
        DD xdd = new DD(x);
        DD rr = xdd.reciprocal().reciprocal();
        double err = xdd.subtract(rr).doubleValue();
        DDBasicTest.assertTrue((err <= errBound ? 1 : 0) != 0);
    }

    private void checkPow(double x, int exp, double errBound) {
        boolean isOK;
        DD pow2;
        DD xdd = new DD(x);
        DD pow = xdd.pow(exp);
        double err = pow.subtract(pow2 = this.slowPow(xdd, exp)).doubleValue();
        boolean bl = isOK = err < errBound;
        if (!isOK) {
            System.out.println("Test slowPow value " + pow2);
        }
        DDBasicTest.assertTrue((err <= errBound ? 1 : 0) != 0);
    }

    private DD slowPow(DD x, int exp) {
        if (exp == 0) {
            return DD.valueOf((double)1.0);
        }
        int n = Math.abs(exp);
        DD pow = new DD(x);
        for (int i = 1; i < n; ++i) {
            pow = pow.multiply(x);
        }
        if (exp < 0) {
            return pow.reciprocal();
        }
        return pow;
    }
}

