/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.linearref;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.linearref.AbstractIndexedLineTest;
import com.hazelcast.shaded.org.locationtech.jts.linearref.LinearLocation;
import com.hazelcast.shaded.org.locationtech.jts.linearref.LocationIndexedLine;
import junit.textui.TestRunner;

public class LocationIndexedLineTest
extends AbstractIndexedLineTest {
    public static void main(String[] args) {
        TestRunner.run(LocationIndexedLineTest.class);
    }

    public LocationIndexedLineTest(String name) {
        super(name);
    }

    public void testMultiLineStringSimple() throws Exception {
        this.runExtractLine("MULTILINESTRING ((0 0, 10 10), (20 20, 30 30))", new LinearLocation(0, 0, 0.5), new LinearLocation(1, 0, 0.5), "MULTILINESTRING ((5 5, 10 10), (20 20, 25 25))");
    }

    public void testMultiLineString2() throws Exception {
        this.runExtractLine("MULTILINESTRING ((0 0, 10 10), (20 20, 30 30))", new LinearLocation(0, 0, 1.0), new LinearLocation(1, 0, 0.5), "MULTILINESTRING ((10 10, 10 10), (20 20, 25 25))");
    }

    private void runExtractLine(String wkt, LinearLocation start, LinearLocation end, String expected) {
        Geometry geom = this.read(wkt);
        LocationIndexedLine lil = new LocationIndexedLine(geom);
        Geometry result = lil.extractLine(start, end);
        this.checkExpected(result, expected);
    }

    @Override
    protected Geometry indicesOfThenExtract(Geometry input, Geometry subLine) {
        LocationIndexedLine indexedLine = new LocationIndexedLine(input);
        LinearLocation[] loc = indexedLine.indicesOf(subLine);
        Geometry result = indexedLine.extractLine(loc[0], loc[1]);
        return result;
    }

    @Override
    protected boolean indexOfAfterCheck(Geometry linearGeom, Coordinate testPt) {
        LocationIndexedLine indexedLine = new LocationIndexedLine(linearGeom);
        LinearLocation loc1 = indexedLine.indexOf(testPt);
        LinearLocation loc2 = indexedLine.indexOfAfter(testPt, loc1);
        if (loc2.compareTo((Object)loc1) <= 0) {
            return false;
        }
        Coordinate pt1 = indexedLine.extractPoint(loc1);
        Coordinate pt2 = indexedLine.extractPoint(loc2);
        if (!pt1.equals2D(testPt)) {
            return false;
        }
        return pt2.equals2D(testPt);
    }

    @Override
    protected boolean indexOfAfterCheck(Geometry linearGeom, Coordinate testPt, Coordinate afterPt) {
        LocationIndexedLine indexedLine = new LocationIndexedLine(linearGeom);
        LinearLocation afterLoc = indexedLine.indexOf(afterPt);
        LinearLocation testLoc = indexedLine.indexOfAfter(testPt, afterLoc);
        return testLoc.compareTo((Object)afterLoc) >= 0;
    }

    @Override
    protected Coordinate extractOffsetAt(Geometry linearGeom, Coordinate testPt, double offsetDistance) {
        LocationIndexedLine indexedLine = new LocationIndexedLine(linearGeom);
        LinearLocation index = indexedLine.indexOf(testPt);
        return indexedLine.extractPoint(index, offsetDistance);
    }
}

