/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.io.kml;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.io.ParseException;
import com.hazelcast.shaded.org.locationtech.jts.io.kml.KMLReader;
import com.hazelcast.shaded.org.locationtech.jts.io.kml.KMLWriterTest;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.junit.Assert;

public class KMLReaderTest
extends TestCase {
    private KMLReader kmlReader = new KMLReader(Arrays.asList("altitudeMode", "tesselate", "extrude"));

    public static void main(String[] args) {
        TestRunner.run(KMLWriterTest.class);
    }

    public KMLReaderTest(String name) {
        super(name);
    }

    public void testPoint() {
        this.checkParsingResult("<Point><altitudeMode>absolute</altitudeMode><coordinates>1.0,1.0</coordinates></Point>", "POINT (1 1)", new Map[]{Collections.singletonMap("altitudeMode", "absolute")});
    }

    public void testLineString() {
        this.checkParsingResult("<LineString><tesselate>1</tesselate><coordinates>1.0,1.0 2.0,2.0</coordinates></LineString>", "LINESTRING (1 1, 2 2)", new Map[]{Collections.singletonMap("tesselate", "1")});
    }

    public void testPolygon() {
        this.checkParsingResult("<Polygon>   <altitudeMode>relativeToGround</altitudeMode>   <outerBoundaryIs>       <LinearRing>           <coordinates>1.0,1.0 1.0,10.0 10.0,10.0 10.0,1.0 1.0,1.0</coordinates>       </LinearRing>   </outerBoundaryIs>   <innerBoundaryIs>       <LinearRing>           <coordinates>2.0,2.0 2.0,3.0 3.0,3.0 3.0,2.0 2.0,2.0</coordinates>       </LinearRing>   </innerBoundaryIs>   <innerBoundaryIs>       <LinearRing>           <coordinates>6.0,6.0 6.0,7.0 7.0,7.0 7.0,6.0 6.0,6.0</coordinates>       </LinearRing>   </innerBoundaryIs></Polygon>", "POLYGON ((1 1, 1 10, 10 10, 10 1, 1 1), (2 2, 2 3, 3 3, 3 2, 2 2), (6 6, 6 7, 7 7, 7 6, 6 6))", new Map[]{Collections.singletonMap("altitudeMode", "relativeToGround")});
    }

    public void testMultiGeometry() {
        this.checkParsingResult("<MultiGeometry>   <Point>       <altitudeMode>absolute</altitudeMode>       <coordinates>1.0,1.0</coordinates>   </Point>   <LineString>       <tesselate>1</tesselate>       <coordinates>1.0,1.0 2.0,2.0</coordinates>   </LineString>   <Polygon>       <altitudeMode>relativeToGround</altitudeMode>       <outerBoundaryIs>           <LinearRing>               <coordinates>1.0,1.0 1.0,10.0 10.0,10.0 10.0,1.0 1.0,1.0</coordinates>           </LinearRing>       </outerBoundaryIs>   </Polygon></MultiGeometry>", "GEOMETRYCOLLECTION (POINT (1 1), LINESTRING (1 1, 2 2), POLYGON ((1 1, 1 10, 10 10, 10 1, 1 1)))", new Map[]{Collections.singletonMap("altitudeMode", "absolute"), Collections.singletonMap("tesselate", "1"), Collections.singletonMap("altitudeMode", "relativeToGround")});
    }

    public void testMultiGeometryWithAllPoints() {
        this.checkParsingResult("<MultiGeometry>   <Point><coordinates>1.0,1.0</coordinates></Point>   <Point><coordinates>2.0,2.0</coordinates></Point></MultiGeometry>", "MULTIPOINT ((1 1), (2 2))", new Map[]{null, null});
    }

    public void testMultiGeometryWithAllLines() {
        this.checkParsingResult("<MultiGeometry>   <LineString><coordinates>1.0,1.0 2.0,2.0</coordinates></LineString>   <LineString><coordinates>5.0,5.0 6.0,6.0</coordinates></LineString></MultiGeometry>", "MULTILINESTRING ((1 1, 2 2), (5 5, 6 6))", new Map[]{null, null});
    }

    public void testMultiGeometryWithAllPolygons() {
        this.checkParsingResult("<MultiGeometry>   <Polygon><outerBoundaryIs><LinearRing><coordinates>2.0,2.0 2.0,3.0 3.0,3.0 3.0,2.0 2.0,2.0</coordinates></LinearRing></outerBoundaryIs></Polygon>   <Polygon><outerBoundaryIs><LinearRing><coordinates>6.0,6.0 6.0,7.0 7.0,7.0 7.0,6.0 6.0,6.0</coordinates></LinearRing></outerBoundaryIs></Polygon></MultiGeometry>", "MULTIPOLYGON (((2 2, 2 3, 3 3, 3 2, 2 2)), ((6 6, 6 7, 7 7, 7 6, 6 6)))", new Map[]{null, null});
    }

    public void testZ() {
        String kml = "<Point><coordinates>1.0,1.0,50.0</coordinates></Point>";
        KMLReader kmlReader = new KMLReader();
        try {
            Geometry parsedGeometry = kmlReader.read(kml);
            KMLReaderTest.assertEquals((String)"Wrong Z", (Object)50.0, (Object)parsedGeometry.getCoordinate().z);
        }
        catch (ParseException e) {
            throw new RuntimeException("ParseException: " + e.getMessage());
        }
    }

    public void testPrecisionAndSRID() {
        String kml = "<Point><altitudeMode>absolute</altitudeMode><coordinates>1.385093,1.436456</coordinates></Point>";
        GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(1000.0), 4326);
        KMLReader kmlReader = new KMLReader(geometryFactory);
        try {
            Geometry parsedGeometry = kmlReader.read(kml);
            KMLReaderTest.assertEquals((String)"Wrong SRID", (int)geometryFactory.getSRID(), (int)parsedGeometry.getSRID());
            KMLReaderTest.assertEquals((String)"Wrong precision", (String)"POINT (1.385 1.436)", (String)parsedGeometry.toText());
        }
        catch (ParseException e) {
            throw new RuntimeException("ParseException: " + e.getMessage());
        }
    }

    public void testCoordinatesErrors() {
        this.checkExceptionThrown("<Point></Point>", "No element coordinates found in Point");
        this.checkExceptionThrown("<Point><coordinates></coordinates></Point>", "Empty coordinates");
        this.checkExceptionThrown("<Point><coordinates>1.0</coordinates></Point>", "Invalid coordinate format");
        this.checkExceptionThrown("<Point><coordinates>,1.0</coordinates></Point>", "Invalid coordinate format");
        this.checkExceptionThrown("<Point><coordinates>1.0,</coordinates></Point>", "Invalid coordinate format");
        this.checkExceptionThrown("<Polygon></Polygon>", "No outer boundary for Polygon");
        this.checkExceptionThrown("<Polygon><outerBoundaryIs><LinearRing></LinearRing></outerBoundaryIs></Polygon>", "No element coordinates found in outerBoundaryIs");
        this.checkExceptionThrown("<Polygon><innerBoundaryIs><LinearRing></LinearRing></innerBoundaryIs></Polygon>", "No element coordinates found in innerBoundaryIs");
    }

    public void testUnknownGeometryType() {
        this.checkExceptionThrown("<StrangePoint></StrangePoint>", "Unknown KML geometry type StrangePoint");
    }

    private void checkExceptionThrown(String kmlString, String expectedError) {
        try {
            this.kmlReader.read(kmlString);
            Assert.fail((String)"Exception must be thrown");
        }
        catch (ParseException e) {
            KMLReaderTest.assertEquals((String)"Exception text differs", (String)expectedError, (String)e.getMessage());
        }
    }

    private void checkParsingResult(String kmlString, String expectedWKT, Map<String, String>[] expectedAttributes) {
        try {
            Geometry parsedGeometry = this.kmlReader.read(kmlString);
            String wkt = parsedGeometry.toText();
            KMLReaderTest.assertEquals((String)"WKTs are not equal", (String)expectedWKT, (String)wkt);
            for (int i = 0; i < parsedGeometry.getNumGeometries(); ++i) {
                Geometry geometryN = parsedGeometry.getGeometryN(i);
                KMLReaderTest.assertTrue((String)"User data is not filled", (geometryN.getUserData() != null || expectedAttributes[i] == null ? 1 : 0) != 0);
                if (geometryN.getUserData() == null) continue;
                Map actualUserData = (Map)geometryN.getUserData();
                KMLReaderTest.assertEquals((String)"Number of attributes differs in user data", (int)expectedAttributes[i].size(), (int)actualUserData.size());
                for (Map.Entry<String, String> entry : expectedAttributes[i].entrySet()) {
                    KMLReaderTest.assertTrue((String)("User data has not attribute " + entry.getKey()), (boolean)actualUserData.containsKey(entry.getKey()));
                    KMLReaderTest.assertEquals((String)"Attribute value differs", (String)entry.getValue(), (String)((String)actualUserData.get(entry.getKey())));
                }
            }
        }
        catch (ParseException e) {
            throw new RuntimeException("ParseException: " + e.getMessage());
        }
    }
}

