/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.io.gml2;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.io.gml2.GMLReader;
import com.hazelcast.shaded.org.locationtech.jts.io.gml2.GMLWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.TestCase;
import org.xml.sax.SAXException;

public abstract class WritingTestCase
extends TestCase {
    protected StringWriter sw = null;
    protected static PrecisionModel precisionModel = new PrecisionModel(1000.0);
    protected static GeometryFactory geometryFactory = new GeometryFactory(precisionModel);

    public WritingTestCase(String arg) {
        super(arg);
    }

    protected Writer getWriter() {
        this.sw = new StringWriter();
        this.sw.write("<?xml version='1.0' encoding='UTF-8'?>\n");
        return this.sw;
    }

    protected Reader getReader() throws IOException {
        this.sw.flush();
        this.sw.close();
        String s = this.sw.toString();
        return new StringReader(s);
    }

    protected void checkRoundTrip(Geometry g) throws SAXException, IOException, ParserConfigurationException {
        GMLWriter out = new GMLWriter();
        out.setPrefix(null);
        out.setNamespace(true);
        out.setSrsName("foo");
        out.write(g, this.getWriter());
        GMLReader in = new GMLReader();
        Geometry g2 = in.read(this.getReader(), geometryFactory);
        WritingTestCase.assertTrue((String)"The input Geometry is not the same as the output Geometry", (boolean)g.equalsExact(g2));
    }
}

