/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.index.strtree;

import com.hazelcast.shaded.org.locationtech.jts.index.strtree.AbstractNode;
import com.hazelcast.shaded.org.locationtech.jts.index.strtree.SIRtree;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class SIRtreeTest
extends TestCase {
    public SIRtreeTest(String Name_) {
        super(Name_);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{SIRtreeTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    public void test() {
        TestTree t = new TestTree(2);
        t.insert(2.0, 6.0, "A");
        t.insert(2.0, 4.0, "B");
        t.insert(2.0, 3.0, "C");
        t.insert(2.0, 4.0, "D");
        t.insert(0.0, 1.0, "E");
        t.insert(2.0, 4.0, "F");
        t.insert(5.0, 6.0, "G");
        t.build();
        SIRtreeTest.assertEquals((int)2, (int)t.getRoot().getLevel());
        SIRtreeTest.assertEquals((int)4, (int)t.boundablesAtLevel(0).size());
        SIRtreeTest.assertEquals((int)2, (int)t.boundablesAtLevel(1).size());
        SIRtreeTest.assertEquals((int)1, (int)t.boundablesAtLevel(2).size());
        SIRtreeTest.assertEquals((int)1, (int)t.query(0.5, 0.5).size());
        SIRtreeTest.assertEquals((int)0, (int)t.query(1.5, 1.5).size());
        SIRtreeTest.assertEquals((int)2, (int)t.query(4.5, 5.5).size());
    }

    public void testEmptyTree() {
        TestTree t = new TestTree(2);
        t.build();
        SIRtreeTest.assertEquals((int)0, (int)t.getRoot().getLevel());
        SIRtreeTest.assertEquals((int)1, (int)t.boundablesAtLevel(0).size());
        SIRtreeTest.assertEquals((int)0, (int)t.boundablesAtLevel(1).size());
        SIRtreeTest.assertEquals((int)0, (int)t.boundablesAtLevel(-1).size());
        SIRtreeTest.assertEquals((int)0, (int)t.query(0.5, 0.5).size());
    }

    private static class TestTree
    extends SIRtree {
        public TestTree(int nodeCapacity) {
            super(nodeCapacity);
        }

        public AbstractNode getRoot() {
            return super.getRoot();
        }

        protected List boundablesAtLevel(int level) {
            return super.boundablesAtLevel(level);
        }
    }
}

