/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.index;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Envelope;
import com.hazelcast.shaded.org.locationtech.jts.index.VertexSequencePackedRtree;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class VertexSequencePackedRtreeTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(VertexSequencePackedRtreeTest.class);
    }

    public VertexSequencePackedRtreeTest(String name) {
        super(name);
    }

    public void test1() {
        VertexSequencePackedRtree tree = this.createSPRtree(1, 1);
        this.checkQuery(tree, 1.0, 1.0, 4.0, 4.0, this.result(0));
    }

    public void test2() {
        VertexSequencePackedRtree tree = this.createSPRtree(0, 0, 1, 1);
        this.checkQuery(tree, 1.0, 1.0, 4.0, 4.0, this.result(1));
    }

    public void test6() {
        VertexSequencePackedRtree tree = this.createSPRtree(0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5);
        this.checkQuery(tree, 2.0, 2.0, 4.0, 4.0, this.result(2, 3, 4));
        this.checkQuery(tree, 0.0, 0.0, 0.0, 0.0, this.result(0));
    }

    public void test10() {
        VertexSequencePackedRtree tree = this.createSPRtree(0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10);
        this.checkQuery(tree, 2.0, 2.0, 4.0, 4.0, this.result(2, 3, 4));
        this.checkQuery(tree, 7.0, 7.0, 8.0, 8.0, this.result(7, 8));
        this.checkQuery(tree, 0.0, 0.0, 0.0, 0.0, this.result(0));
    }

    public void test6WithDups() {
        VertexSequencePackedRtree tree = this.createSPRtree(0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 4, 4, 3, 3, 2, 2, 1, 1, 0, 0);
        this.checkQuery(tree, 2.0, 2.0, 4.0, 4.0, this.result(2, 3, 4, 6, 7, 8));
        this.checkQuery(tree, 0.0, 0.0, 0.0, 0.0, this.result(0, 10));
    }

    private void checkQuery(VertexSequencePackedRtree tree, double xmin, double ymin, double xmax, double ymax, int[] expected) {
        Envelope env = new Envelope(xmin, xmax, ymin, ymax);
        int[] result = tree.query(env);
        VertexSequencePackedRtreeTest.assertEquals((int)expected.length, (int)result.length);
        VertexSequencePackedRtreeTest.assertTrue((boolean)this.isEqualResult(expected, result));
    }

    private boolean isEqualResult(int[] expected, int[] result) {
        for (int i = 0; i < result.length; ++i) {
            if (expected[i] == result[i]) continue;
            return false;
        }
        return true;
    }

    private int[] result(int ... i) {
        return i;
    }

    private VertexSequencePackedRtree createSPRtree(int ... ords) {
        int numCoord = ords.length / 2;
        Coordinate[] pt = new Coordinate[numCoord];
        for (int i = 0; i < numCoord; ++i) {
            pt[i] = new Coordinate((double)ords[2 * i], (double)ords[2 * i + 1]);
        }
        return new VertexSequencePackedRtree(pt);
    }
}

