/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.geom;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.geom.Triangle;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTReader;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class TriangleTest
extends GeometryTestCase {
    private PrecisionModel precisionModel = new PrecisionModel();
    private GeometryFactory geometryFactory = new GeometryFactory(this.precisionModel, 0);
    WKTReader reader = new WKTReader(this.geometryFactory);
    private static final double TOLERANCE = 1.0E-5;

    public static void main(String[] args) {
        TestRunner.run(TriangleTest.class);
    }

    public TriangleTest(String name) {
        super(name);
    }

    public void testInterpolateZ() throws Exception {
        this.checkInterpolateZ("LINESTRING(1 1 0, 2 1 0, 1 2 10)", new Coordinate(1.5, 1.5), 5.0);
        this.checkInterpolateZ("LINESTRING(1 1 0, 2 1 0, 1 2 10)", new Coordinate(1.2, 1.2), 2.0);
        this.checkInterpolateZ("LINESTRING(1 1 0, 2 1 0, 1 2 10)", new Coordinate(0.0, 0.0), -10.0);
    }

    public void checkInterpolateZ(String wkt, Coordinate p, double expectedValue) throws Exception {
        Geometry g = this.reader.read(wkt);
        Coordinate[] pt = g.getCoordinates();
        Triangle t = new Triangle(pt[0], pt[1], pt[2]);
        double z = t.interpolateZ(p);
        TriangleTest.assertEquals((double)expectedValue, (double)z, (double)1.0E-6);
    }

    public void testArea3D() throws Exception {
        this.checkArea3D("POLYGON((0 0 10, 100 0 110, 100 100 110, 0 0 10))", 7071.067811865475);
        this.checkArea3D("POLYGON((0 0 10, 100 0 10, 50 100 110, 0 0 10))", 7071.067811865475);
    }

    public void checkArea3D(String wkt, double expectedValue) throws Exception {
        Geometry g = this.reader.read(wkt);
        Coordinate[] pt = g.getCoordinates();
        Triangle t = new Triangle(pt[0], pt[1], pt[2]);
        double area3D = t.area3D();
        TriangleTest.assertEquals((double)expectedValue, (double)area3D, (double)1.0E-5);
    }

    public void testArea() throws Exception {
        this.checkArea("POLYGON((10 10, 20 20, 20 10, 10 10))", 50.0);
        this.checkArea("POLYGON((10 10, 20 10, 20 20, 10 10))", -50.0);
        this.checkArea("POLYGON((10 10, 10 10, 10 10, 10 10))", 0.0);
        this.checkArea("POLYGON((10 10, 20 10, 15 10, 10 10))", 0.0);
    }

    public void checkArea(String wkt, double expectedValue) throws Exception {
        Geometry g = this.reader.read(wkt);
        Coordinate[] pt = g.getCoordinates();
        Triangle t = new Triangle(pt[0], pt[1], pt[2]);
        double signedArea = t.signedArea();
        TriangleTest.assertEquals((double)expectedValue, (double)signedArea, (double)1.0E-5);
        double area = t.area();
        TriangleTest.assertEquals((double)Math.abs(expectedValue), (double)area, (double)1.0E-5);
    }

    public void testAcute() throws Exception {
        this.checkAcute("POLYGON((10 10, 20 20, 20 10, 10 10))", false);
        this.checkAcute("POLYGON((10 10, 20 10, 20 20, 10 10))", false);
        this.checkAcute("POLYGON((10 10, 20 10, 15 20, 10 10))", true);
    }

    public void checkAcute(String wkt, boolean expectedValue) throws Exception {
        Geometry g = this.reader.read(wkt);
        Coordinate[] pt = g.getCoordinates();
        Triangle t = new Triangle(pt[0], pt[1], pt[2]);
        boolean isAcute = t.isAcute();
        TriangleTest.assertEquals((boolean)expectedValue, (boolean)isAcute);
    }

    public void testCircumCentre() throws Exception {
        this.checkCircumCentre("POLYGON((10 10, 20 20, 20 10, 10 10))", new Coordinate(15.0, 15.0));
        this.checkCircumCentre("POLYGON((10 10, 20 10, 20 20, 10 10))", new Coordinate(15.0, 15.0));
        this.checkCircumCentre("POLYGON((10 10, 20 10, 15 20, 10 10))", new Coordinate(15.0, 13.75));
    }

    public void testCentroid() throws Exception {
        this.checkCentroid("POLYGON((10 10, 20 20, 20 10, 10 10))", new Coordinate(16.666666666666668, 13.333333333333334));
        this.checkCentroid("POLYGON((10 10, 20 10, 20 20, 10 10))", new Coordinate(16.666666666666668, 13.333333333333334));
        this.checkCentroid("POLYGON((10 10, 20 10, 15 20, 10 10))", new Coordinate(15.0, 13.333333333333334));
    }

    public void checkCentroid(String wkt, Coordinate expectedValue) throws Exception {
        Geometry g = this.reader.read(wkt);
        Coordinate[] pt = g.getCoordinates();
        Coordinate centroid = Triangle.centroid((Coordinate)pt[0], (Coordinate)pt[1], (Coordinate)pt[2]);
        TriangleTest.assertEquals((String)expectedValue.toString(), (String)centroid.toString());
        Triangle t = new Triangle(pt[0], pt[1], pt[2]);
        centroid = t.centroid();
        TriangleTest.assertEquals((String)expectedValue.toString(), (String)centroid.toString());
    }

    public void checkCircumCentre(String wkt, Coordinate expectedValue) throws Exception {
        Geometry g = this.reader.read(wkt);
        Coordinate[] pt = g.getCoordinates();
        Coordinate circumcentre = Triangle.circumcentre((Coordinate)pt[0], (Coordinate)pt[1], (Coordinate)pt[2]);
        TriangleTest.assertEquals((String)expectedValue.toString(), (String)circumcentre.toString());
        Triangle t = new Triangle(pt[0], pt[1], pt[2]);
        circumcentre = t.circumcentre();
        TriangleTest.assertEquals((String)expectedValue.toString(), (String)circumcentre.toString());
    }

    public void testLongestSideLength() throws Exception {
        this.checkLongestSideLength("POLYGON((10 10 1, 20 20 2, 20 10 3, 10 10 1))", 14.142135623730951);
        this.checkLongestSideLength("POLYGON((10 10 1, 20 10 2, 20 20 3, 10 10 1))", 14.142135623730951);
        this.checkLongestSideLength("POLYGON((10 10 1, 20 10 2, 15 20 3, 10 10 1))", 11.180339887498949);
    }

    public void checkLongestSideLength(String wkt, double expectedValue) throws Exception {
        Geometry g = this.reader.read(wkt);
        Coordinate[] pt = g.getCoordinates();
        double length = Triangle.longestSideLength((Coordinate)pt[0], (Coordinate)pt[1], (Coordinate)pt[2]);
        TriangleTest.assertEquals((double)expectedValue, (double)length, (double)1.0E-8);
        Triangle t = new Triangle(pt[0], pt[1], pt[2]);
        length = t.longestSideLength();
        TriangleTest.assertEquals((double)expectedValue, (double)length, (double)1.0E-8);
    }

    public void testIsCCW() {
        this.checkIsCCW("POLYGON ((30 90, 80 50, 20 20, 30 90))", false);
        this.checkIsCCW("POLYGON ((90 90, 20 40, 10 10, 90 90))", true);
    }

    public void checkIsCCW(String wkt, boolean expectedValue) {
        Coordinate[] pt = this.read(wkt).getCoordinates();
        boolean actual = Triangle.isCCW((Coordinate)pt[0], (Coordinate)pt[1], (Coordinate)pt[2]);
        TriangleTest.assertEquals((boolean)expectedValue, (boolean)actual);
    }

    public void testIntersects() {
        this.checkIntersects("POLYGON ((30 90, 80 50, 20 20, 30 90))", "POINT (70 20)", false);
        this.checkIntersects("POLYGON ((30 90, 80 50, 20 20, 30 90))", "POINT (30 90)", true);
        this.checkIntersects("POLYGON ((30 90, 80 50, 20 20, 30 90))", "POINT (40 40)", true);
        this.checkIntersects("POLYGON ((30 90, 70 50, 71.5 16.5, 30 90))", "POINT (50 70)", true);
    }

    public void checkIntersects(String wktTri, String wktPt, boolean expectedValue) {
        Coordinate[] tri = this.read(wktTri).getCoordinates();
        Coordinate pt = this.read(wktPt).getCoordinate();
        boolean actual = Triangle.intersects((Coordinate)tri[0], (Coordinate)tri[1], (Coordinate)tri[2], (Coordinate)pt);
        TriangleTest.assertEquals((boolean)expectedValue, (boolean)actual);
    }
}

