/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.geom;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTReader;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class PredicateShortCircuitTest
extends TestCase {
    WKTReader rdr = new WKTReader();
    String[] polyInsidePoly = new String[]{"POLYGON (( 0 0, 100 0, 100 100, 0 100, 0 0 ))", "POLYGON (( 10 10, 90 10, 90 90, 10 90, 10 10 ))"};
    String[] polyPartiallyOverlapsPoly = new String[]{"POLYGON (( 10 10, 100 10, 100 100, 10 100, 10 10 ))", "POLYGON (( 0 0, 90 0, 90 90, 0 90, 0 0 ))"};
    String[] polyTouchesPolyAtPoint = new String[]{"POLYGON (( 10 10, 100 10, 100 100, 10 100, 10 10 ))", "POLYGON (( 0 0, 10 0, 10 10, 0 10, 0 0 ))"};
    String[] polyTouchesPolyAtLine = new String[]{"POLYGON (( 10 10, 100 10, 100 100, 10 100, 10 10 ))", "POLYGON (( 10 0, 10 10, 20 10, 20 0, 10 0 ))"};
    String[] polyInsideHoleInPoly = new String[]{"POLYGON (( 40 40, 40 60, 60 60, 60 40, 40 40 ))", "POLYGON (( 0 0, 100 0, 100 100, 0 100, 0 0), ( 10 10, 90 10, 90 90, 10 90, 10 10))"};

    public static void main(String[] args) {
        TestRunner.run(PredicateShortCircuitTest.class);
    }

    public PredicateShortCircuitTest(String name) {
        super(name);
    }

    public void testAll() throws Exception {
        this.doPredicates(this.polyInsidePoly);
        this.doPredicates(this.polyPartiallyOverlapsPoly);
        this.doPredicates(this.polyTouchesPolyAtPoint);
        this.doPredicates(this.polyTouchesPolyAtLine);
        this.doPredicates(this.polyInsideHoleInPoly);
    }

    public void doPredicates(String[] wkt) throws Exception {
        Geometry a = this.rdr.read(wkt[0]);
        Geometry b = this.rdr.read(wkt[1]);
        this.doPredicates(a, b);
        this.doPredicates(b, a);
    }

    public void doPredicates(Geometry a, Geometry b) throws Exception {
        PredicateShortCircuitTest.assertTrue((a.contains(b) == a.relate(b).isContains() ? 1 : 0) != 0);
        PredicateShortCircuitTest.assertTrue((a.crosses(b) == a.relate(b).isCrosses(a.getDimension(), b.getDimension()) ? 1 : 0) != 0);
        PredicateShortCircuitTest.assertTrue((a.disjoint(b) == a.relate(b).isDisjoint() ? 1 : 0) != 0);
        PredicateShortCircuitTest.assertTrue((a.equals(b) == a.relate(b).isEquals(a.getDimension(), b.getDimension()) ? 1 : 0) != 0);
        PredicateShortCircuitTest.assertTrue((a.intersects(b) == a.relate(b).isIntersects() ? 1 : 0) != 0);
        PredicateShortCircuitTest.assertTrue((a.overlaps(b) == a.relate(b).isOverlaps(a.getDimension(), b.getDimension()) ? 1 : 0) != 0);
        PredicateShortCircuitTest.assertTrue((a.touches(b) == a.relate(b).isTouches(a.getDimension(), b.getDimension()) ? 1 : 0) != 0);
        PredicateShortCircuitTest.assertTrue((a.within(b) == a.relate(b).isWithin() ? 1 : 0) != 0);
    }
}

