/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.geom;

import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequence;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryCollection;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.Point;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;
import test.jts.GeometryTestData;

public class GeometryReverseTest
extends GeometryTestCase {
    public static void main(String[] args) throws Exception {
        TestRunner.run(GeometryReverseTest.class);
    }

    public GeometryReverseTest(String name) {
        super(name);
    }

    public void testReverse() {
        for (String wkt : GeometryTestData.WKT_ALL) {
            this.checkReverse(this.read(wkt));
        }
    }

    private void checkReverse(Geometry g) {
        int SRID = 123;
        g.setSRID(SRID);
        Geometry reverse = g.reverse();
        GeometryReverseTest.assertTrue((String)(g.getGeometryType() + ": Geometry types are not the same"), (g.getGeometryType() == reverse.getGeometryType() ? 1 : 0) != 0);
        GeometryReverseTest.assertEquals((String)(g.getGeometryType() + ": Geometry.getSRID() values are not the same"), (int)g.getSRID(), (int)reverse.getSRID());
        GeometryReverseTest.assertTrue((String)(g.getGeometryType() + ": Sequences are not opposite"), (boolean)this.checkSequences(g, reverse));
    }

    private boolean checkSequences(Geometry g1, Geometry g2) {
        int numGeometries = g1.getNumGeometries();
        if (numGeometries != g2.getNumGeometries()) {
            return false;
        }
        for (int i = 0; i < numGeometries; ++i) {
            Geometry gt1 = g1.getGeometryN(i);
            int j = i;
            Geometry gt2 = g2.getGeometryN(j);
            if (gt1.getGeometryType() != gt2.getGeometryType()) {
                return false;
            }
            if (gt1 instanceof Point) {
                if (this.checkSequences(((Point)gt1).getCoordinateSequence(), ((Point)gt2).getCoordinateSequence())) continue;
                return false;
            }
            if (gt1 instanceof LineString) {
                if (this.checkSequences(((LineString)gt1).getCoordinateSequence(), ((LineString)gt2).getCoordinateSequence())) continue;
                return false;
            }
            if (gt1 instanceof Polygon) {
                Polygon pt1 = (Polygon)gt1;
                Polygon pt2 = (Polygon)gt2;
                if (!this.checkSequences(pt1.getExteriorRing().getCoordinateSequence(), pt2.getExteriorRing().getCoordinateSequence())) {
                    return false;
                }
                for (int k = 0; k < pt1.getNumInteriorRing(); ++k) {
                    if (this.checkSequences(pt1.getInteriorRingN(k).getCoordinateSequence(), pt2.getInteriorRingN(k).getCoordinateSequence())) continue;
                    return false;
                }
                continue;
            }
            if (gt1 instanceof GeometryCollection) {
                this.checkSequences(gt1, gt2);
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean checkSequences(CoordinateSequence c1, CoordinateSequence c2) {
        if (c1.size() != c2.size()) {
            return false;
        }
        if (c1.getDimension() != c2.getDimension()) {
            return false;
        }
        if (c1.getMeasures() != c2.getMeasures()) {
            return false;
        }
        for (int i = 0; i < c1.size(); ++i) {
            int j = c1.size() - i - 1;
            for (int k = 0; k < c1.getDimension(); ++k) {
                if (c1.getOrdinate(i, k) == c2.getOrdinate(j, k) || Double.isNaN(c1.getOrdinate(i, k)) && Double.isNaN(c2.getOrdinate(j, k))) continue;
                return false;
            }
        }
        return true;
    }
}

