/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.geom;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class GeometryOpGCUnsupportedTest
extends GeometryTestCase {
    static String WKT_GC = "GEOMETRYCOLLECTION (POLYGON ((100 200, 200 200, 200 100, 100 100, 100 200)), LINESTRING (150 250, 250 250))";
    static String WKT_POLY = "POLYGON ((50 50, 50 150, 150 150, 150 50, 50 50))";

    public static void main(String[] args) throws Exception {
        TestRunner.run(GeometryOpGCUnsupportedTest.class);
    }

    public GeometryOpGCUnsupportedTest(String name) {
        super(name);
    }

    public void testBoundary() {
        final Geometry a = this.read(WKT_GC);
        Geometry b = this.read(WKT_POLY);
        new FailureChecker(){

            @Override
            void operation() {
                a.getBoundary();
            }
        }.check(IllegalArgumentException.class);
    }

    public void testRelate() {
        final Geometry a = this.read(WKT_GC);
        final Geometry b = this.read(WKT_POLY);
        new FailureChecker(){

            @Override
            void operation() {
                a.relate(b);
            }
        }.check(IllegalArgumentException.class);
        new FailureChecker(){

            @Override
            void operation() {
                b.relate(a);
            }
        }.check(IllegalArgumentException.class);
    }

    public void testUnion() {
        final Geometry a = this.read(WKT_GC);
        final Geometry b = this.read(WKT_POLY);
        new FailureChecker(){

            @Override
            void operation() {
                a.union(b);
            }
        }.check(IllegalArgumentException.class);
        new FailureChecker(){

            @Override
            void operation() {
                b.union(a);
            }
        }.check(IllegalArgumentException.class);
    }

    public void testDifference() {
        final Geometry a = this.read(WKT_GC);
        final Geometry b = this.read(WKT_POLY);
        new FailureChecker(){

            @Override
            void operation() {
                a.difference(b);
            }
        }.check(IllegalArgumentException.class);
        new FailureChecker(){

            @Override
            void operation() {
                b.difference(a);
            }
        }.check(IllegalArgumentException.class);
    }

    public void testSymDifference() {
        final Geometry a = this.read(WKT_GC);
        final Geometry b = this.read(WKT_POLY);
        new FailureChecker(){

            @Override
            void operation() {
                a.symDifference(b);
            }
        }.check(IllegalArgumentException.class);
        new FailureChecker(){

            @Override
            void operation() {
                b.symDifference(a);
            }
        }.check(IllegalArgumentException.class);
    }

    static abstract class FailureChecker {
        FailureChecker() {
        }

        abstract void operation();

        void check(Class exClz) {
            TestCase.assertTrue((boolean)this.isError(exClz));
        }

        boolean isError(Class exClz) {
            try {
                this.operation();
                return false;
            }
            catch (Throwable t) {
                return t.getClass() == exClz;
            }
        }
    }
}

