/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.geom;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryCollection;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryCollectionIterator;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.Point;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTReader;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GeometryCollectionImplTest
extends TestCase {
    PrecisionModel precisionModel = new PrecisionModel(1000.0);
    GeometryFactory geometryFactory = new GeometryFactory(this.precisionModel, 0);
    WKTReader reader = new WKTReader(this.geometryFactory);

    public static void main(String[] args) {
        TestRunner.run((Test)GeometryCollectionImplTest.suite());
    }

    public GeometryCollectionImplTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(GeometryCollectionImplTest.class);
    }

    public void testGetDimension() throws Exception {
        GeometryCollection g = (GeometryCollection)this.reader.read("GEOMETRYCOLLECTION (POINT (10 10), POINT (30 30), LINESTRING (15 15, 20 20))");
        GeometryCollectionImplTest.assertEquals((int)1, (int)g.getDimension());
    }

    public void testGetCoordinates() throws Exception {
        GeometryCollection g = (GeometryCollection)this.reader.read("GEOMETRYCOLLECTION (POINT (10 10), POINT (30 30), LINESTRING (15 15, 20 20))");
        Coordinate[] coordinates = g.getCoordinates();
        GeometryCollectionImplTest.assertEquals((int)4, (int)g.getNumPoints());
        GeometryCollectionImplTest.assertEquals((int)4, (int)coordinates.length);
        GeometryCollectionImplTest.assertEquals((Object)new Coordinate(10.0, 10.0), (Object)coordinates[0]);
        GeometryCollectionImplTest.assertEquals((Object)new Coordinate(20.0, 20.0), (Object)coordinates[3]);
    }

    public void testGeometryCollectionIterator() throws Exception {
        GeometryCollection g = (GeometryCollection)this.reader.read("GEOMETRYCOLLECTION (GEOMETRYCOLLECTION (POINT (10 10)))");
        GeometryCollectionIterator i = new GeometryCollectionIterator((Geometry)g);
        GeometryCollectionImplTest.assertTrue((boolean)i.hasNext());
        GeometryCollectionImplTest.assertTrue((boolean)(i.next() instanceof GeometryCollection));
        GeometryCollectionImplTest.assertTrue((boolean)(i.next() instanceof GeometryCollection));
        GeometryCollectionImplTest.assertTrue((boolean)(i.next() instanceof Point));
    }

    public void testGetLength() throws Exception {
        GeometryCollection g = (GeometryCollection)new WKTReader().read("MULTIPOLYGON(((0 0, 10 0, 10 10, 0 10, 0 0), (3 3, 3 7, 7 7, 7 3, 3 3)),((100 100, 110 100, 110 110, 100 110, 100 100), (103 103, 103 107, 107 107, 107 103, 103 103)))");
        GeometryCollectionImplTest.assertEquals((double)112.0, (double)g.getLength(), (double)1.0E-15);
    }
}

