/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.geom;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateList;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class CoordinateListTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(CoordinateListTest.class);
    }

    public CoordinateListTest(String name) {
        super(name);
    }

    public void testForward() {
        this.checkValue(this.coordList(0.0, 0.0, 1.0, 1.0, 2.0, 2.0).toCoordinateArray(true), 0.0, 0.0, 1.0, 1.0, 2.0, 2.0);
    }

    public void testReverse() {
        this.checkValue(this.coordList(0.0, 0.0, 1.0, 1.0, 2.0, 2.0).toCoordinateArray(false), 2.0, 2.0, 1.0, 1.0, 0.0, 0.0);
    }

    public void testReverseEmpty() {
        this.checkValue(this.coordList(new double[0]).toCoordinateArray(false), new double[0]);
    }

    private void checkValue(Coordinate[] coordArray, double ... ords) {
        CoordinateListTest.assertEquals((int)(coordArray.length * 2), (int)ords.length);
        for (int i = 0; i < coordArray.length; i += 2) {
            Coordinate pt = coordArray[i];
            CoordinateListTest.assertEquals((Object)pt.getX(), (Object)ords[2 * i]);
            CoordinateListTest.assertEquals((Object)pt.getY(), (Object)ords[2 * i + 1]);
        }
    }

    private CoordinateList coordList(double ... ords) {
        CoordinateList cl = new CoordinateList();
        for (int i = 0; i < ords.length; i += 2) {
            cl.add(new Coordinate(ords[i], ords[i + 1]), false);
        }
        return cl;
    }
}

