/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.generator;

import com.hazelcast.shaded.org.locationtech.jts.generator.GeometryGenerator;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.LinearRing;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.operation.valid.IsValidOp;

public class PolygonGenerator
extends GeometryGenerator {
    protected int numberPoints = 4;
    protected int numberHoles = 0;
    protected int generationAlgorithm = 0;
    public static final int BOX = 0;
    public static final int ARC = 1;
    private static final int RUNS = 5;

    @Override
    public Geometry create() {
        if (this.geometryFactory == null) {
            throw new NullPointerException("GeometryFactory is not declared");
        }
        if (this.boundingBox == null || this.boundingBox.isNull()) {
            throw new NullPointerException("Bounding Box is not declared");
        }
        if (this.numberPoints < 4) {
            throw new IllegalStateException("Too few points");
        }
        double x = this.boundingBox.getMinX();
        double dx = this.boundingBox.getMaxX() - x;
        double y = this.boundingBox.getMinY();
        double dy = this.boundingBox.getMaxY() - y;
        Polygon p = null;
        for (int i = 0; i < 5; ++i) {
            switch (this.getGenerationAlgorithm()) {
                case 0: {
                    p = PolygonGenerator.createBox(x, dx, y, dy, this.numberHoles, this.numberPoints, this.geometryFactory);
                    break;
                }
                case 1: {
                    p = PolygonGenerator.createArc(x, dx, y, dy, this.numberHoles, this.numberPoints, this.geometryFactory);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid Alg. Specified");
                }
            }
            IsValidOp valid = new IsValidOp((Geometry)p);
            if (!valid.isValid()) continue;
            return p;
        }
        return null;
    }

    private static Polygon createArc(double x, double dx, double y, double dy, int nholes, int npoints, GeometryFactory gf) {
        double radius = dx < dy ? dx / 3.0 : dy / 3.0;
        double cx = x + dx / 2.0;
        double cy = y + dy / 2.0;
        LinearRing outer = PolygonGenerator.createArc(cx, cy, radius, npoints, gf);
        if (nholes == 0) {
            return gf.createPolygon(outer, null);
        }
        LinearRing[] inner = new LinearRing[nholes];
        radius *= 0.75;
        int degreesPerHole = 360 / (nholes + 1);
        int degreesPerGap = degreesPerHole / nholes;
        degreesPerGap = degreesPerGap < 2 ? 2 : degreesPerGap;
        degreesPerHole = (360 - degreesPerGap * nholes) / nholes;
        if (degreesPerHole < 2) {
            throw new RuntimeException("Slices too small for poly. Use Box alg.");
        }
        int start = degreesPerGap / 2;
        for (int i = 0; i < nholes; ++i) {
            int st = start + i * (degreesPerHole + degreesPerGap);
            inner[i] = PolygonGenerator.createTri(cx, cy, st, st + degreesPerHole, radius, gf);
        }
        return gf.createPolygon(outer, inner);
    }

    private static LinearRing createTri(double cx, double cy, int startAngle, int endAngle, double radius, GeometryFactory gf) {
        Coordinate[] coords = new Coordinate[4];
        double angle = Math.toRadians(startAngle);
        double fx1 = Math.sin(angle) * radius;
        double fy1 = Math.cos(angle) * radius;
        angle = Math.toRadians(endAngle);
        double fx2 = Math.sin(angle) * radius;
        double fy2 = Math.cos(angle) * radius;
        coords[0] = new Coordinate(cx, cy);
        gf.getPrecisionModel().makePrecise(coords[0]);
        coords[1] = new Coordinate(cx + fx1, cy + fy1);
        gf.getPrecisionModel().makePrecise(coords[1]);
        coords[2] = new Coordinate(cx + fx2, cy + fy2);
        gf.getPrecisionModel().makePrecise(coords[2]);
        coords[3] = new Coordinate(cx, cy);
        gf.getPrecisionModel().makePrecise(coords[3]);
        return gf.createLinearRing(coords);
    }

    private static LinearRing createArc(double cx, double cy, double radius, int npoints, GeometryFactory gf) {
        Coordinate[] coords = new Coordinate[npoints + 1];
        double theta = 360 / npoints;
        for (int i = 0; i < npoints; ++i) {
            double angle = Math.toRadians(theta * (double)i);
            double fx = Math.sin(angle) * radius;
            double fy = Math.cos(angle) * radius;
            coords[i] = new Coordinate(cx + fx, cy + fy);
            gf.getPrecisionModel().makePrecise(coords[i]);
        }
        coords[npoints] = new Coordinate(coords[0]);
        gf.getPrecisionModel().makePrecise(coords[npoints]);
        return gf.createLinearRing(coords);
    }

    private static Polygon createBox(double x, double dx, double y, double dy, int nholes, int npoints, GeometryFactory gf) {
        LinearRing outer = PolygonGenerator.createBox(x, dx, y, dy, npoints, gf);
        if (nholes == 0) {
            return gf.createPolygon(outer, null);
        }
        LinearRing[] inner = new LinearRing[nholes];
        int nrow = (int)Math.sqrt(nholes);
        int ncol = nholes / nrow;
        double ddx = dx / (double)(ncol + 1);
        double ddy = dy / (double)(nrow + 1);
        double spx = ddx / (double)(ncol + 1);
        double spy = ddy / (double)(nrow + 1);
        int cindex = 0;
        for (int i = 0; i < nrow; ++i) {
            for (int j = 0; j < ncol; ++j) {
                if (cindex >= nholes) continue;
                int pts = npoints / 2;
                pts = pts < 4 ? 4 : pts;
                inner[cindex++] = PolygonGenerator.createBox(spx + x + (double)j * (ddx + spx), ddx, spy + y + (double)i * (ddy + spy), ddy, pts, gf);
            }
        }
        return gf.createPolygon(outer, inner);
    }

    private static LinearRing createBox(double x, double dx, double y, double dy, int npoints, GeometryFactory gf) {
        int ptsPerSide = npoints / 4;
        int rPtsPerSide = npoints % 4;
        Coordinate[] coords = new Coordinate[npoints + 1];
        coords[0] = new Coordinate(x, y);
        gf.getPrecisionModel().makePrecise(coords[0]);
        int cindex = 1;
        for (int i = 0; i < 4; ++i) {
            int j;
            int npts = ptsPerSide + (rPtsPerSide-- > 0 ? 1 : 0);
            if (i % 2 == 1) {
                double cy = dy / (double)npts;
                if (i > 1) {
                    cy *= -1.0;
                }
                double tx = coords[cindex - 1].x;
                double sy = coords[cindex - 1].y;
                for (j = 0; j < npts; ++j) {
                    coords[cindex] = new Coordinate(tx, sy + (double)(j + 1) * cy);
                    gf.getPrecisionModel().makePrecise(coords[cindex++]);
                }
                continue;
            }
            double cx = dx / (double)npts;
            if (i > 1) {
                cx *= -1.0;
            }
            double ty = coords[cindex - 1].y;
            double sx = coords[cindex - 1].x;
            for (j = 0; j < npts; ++j) {
                coords[cindex] = new Coordinate(sx + (double)(j + 1) * cx, ty);
                gf.getPrecisionModel().makePrecise(coords[cindex++]);
            }
        }
        coords[npoints] = new Coordinate(x, y);
        gf.getPrecisionModel().makePrecise(coords[npoints]);
        return gf.createLinearRing(coords);
    }

    public int getGenerationAlgorithm() {
        return this.generationAlgorithm;
    }

    public void setGenerationAlgorithm(int generationAlgorithm) {
        this.generationAlgorithm = generationAlgorithm;
    }

    public int getNumberHoles() {
        return this.numberHoles;
    }

    public void setNumberHoles(int numberHoles) {
        this.numberHoles = numberHoles;
    }

    public int getNumberPoints() {
        return this.numberPoints;
    }

    public void setNumberPoints(int numberPoints) {
        this.numberPoints = numberPoints;
    }
}

