/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.densify;

import com.hazelcast.shaded.org.locationtech.jts.densify.Densifier;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateXY;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineString;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class DensifierTest
extends GeometryTestCase {
    private static final double TOLERANCE = 1.0E-6;

    public static void main(String[] args) {
        TestRunner.run(DensifierTest.class);
    }

    public DensifierTest(String name) {
        super(name);
    }

    public void testLine() {
        this.checkDensify("LINESTRING (0 0, 30 40, 35 35)", 10.0, "LINESTRING (0 0, 6 8, 12 16, 18 24, 24 32, 30 40, 35 35)");
    }

    public void testLineOfToleranceLength() {
        this.checkDensify("LINESTRING (0 0, 10 0)", 10.0, "LINESTRING (0 0, 10 0)");
    }

    public void testLineWithToleranceLengthSeg() {
        this.checkDensify("LINESTRING (0 0, 12 0, 22 0, 34 0)", 10.0, "LINESTRING (0 0, 6 0, 12 0, 22 0, 28 0, 34 0)");
    }

    public void testLineEmpty() {
        this.checkDensify("LINESTRING EMPTY", 10.0, "LINESTRING EMPTY");
    }

    public void testPointUnchanged() {
        this.checkDensify("POINT (0 0)", 10.0, "POINT (0 0)");
    }

    public void testPolygonEmpty() {
        this.checkDensify("POLYGON EMPTY", 10.0, "POLYGON EMPTY");
    }

    public void testBox() {
        this.checkDensify("POLYGON ((10 30, 30 30, 30 10, 10 10, 10 30))", 10.0, "POLYGON ((10 10, 10 20, 10 30, 20 30, 30 30, 30 20, 30 10, 20 10, 10 10))");
    }

    public void testBoxNoValidate() {
        this.checkDensifyNoValidate("POLYGON ((10 30, 30 30, 30 10, 10 10, 10 30))", 10.0, "POLYGON ((10 10, 10 20, 10 30, 20 30, 30 30, 30 20, 30 10, 20 10, 10 10))");
    }

    public void testLineDensify3D() {
        this.checkDensifyXYZ("POLYGON Z((10 30 10, 30 30 10, 30 10 15, 10 10 10, 10 30 20))", 10.0, "POLYGON Z((10 30 10, 20 30 10, 30 30 10, 30 20 12.5, 30 10 15, 20 10 12.5, 10 10 10, 10 20 15, 10 30 20))");
    }

    public void testDimension2d() {
        GeometryFactory gf = new GeometryFactory();
        LineString line = gf.createLineString(new Coordinate[]{new CoordinateXY(1.0, 2.0), new CoordinateXY(3.0, 4.0)});
        DensifierTest.assertEquals((int)2, (int)line.getCoordinateSequence().getDimension());
        line = (LineString)Densifier.densify((Geometry)line, (double)0.1);
        DensifierTest.assertEquals((int)2, (int)line.getCoordinateSequence().getDimension());
    }

    public void testDimension3d() {
        GeometryFactory gf = new GeometryFactory();
        LineString line = gf.createLineString(new Coordinate[]{new Coordinate(1.0, 2.0, 3.0), new Coordinate(3.0, 4.0, 5.0)});
        DensifierTest.assertEquals((int)3, (int)line.getCoordinateSequence().getDimension());
        line = (LineString)Densifier.densify((Geometry)line, (double)0.1);
        DensifierTest.assertEquals((int)3, (int)line.getCoordinateSequence().getDimension());
    }

    private void checkDensify(String wkt, double distanceTolerance, String wktExpected) {
        Geometry geom = this.read(wkt);
        Geometry expected = this.read(wktExpected);
        Geometry actual = Densifier.densify((Geometry)geom, (double)distanceTolerance);
        this.checkEqual(expected, actual, 1.0E-6);
    }

    private void checkDensifyXYZ(String wkt, double distanceTolerance, String wktExpected) {
        Geometry geom = this.read(wkt);
        Geometry expected = this.read(wktExpected);
        Geometry actual = Densifier.densify((Geometry)geom, (double)distanceTolerance);
        this.checkEqualXYZ(expected, actual);
    }

    private void checkDensifyNoValidate(String wkt, double distanceTolerance, String wktExpected) {
        Geometry geom = this.read(wkt);
        Geometry expected = this.read(wktExpected);
        Densifier den = new Densifier(geom);
        den.setDistanceTolerance(distanceTolerance);
        den.setValidate(false);
        Geometry actual = den.getResultGeometry();
        this.checkEqual(expected, actual, 1.0E-6);
    }
}

