/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.algorithm;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.MinimumBoundingCircle;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.MultiPoint;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.io.ParseException;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTReader;
import junit.textui.TestRunner;
import test.jts.GeometryTestCase;

public class MinimumBoundingCircleTest
extends GeometryTestCase {
    private PrecisionModel precisionModel = new PrecisionModel(1.0);
    private GeometryFactory geometryFactory = new GeometryFactory(this.precisionModel, 0);
    WKTReader reader = new WKTReader(this.geometryFactory);
    static final double TOLERANCE = 1.0E-5;

    public static void main(String[] args) {
        TestRunner.run(MinimumBoundingCircleTest.class);
    }

    public MinimumBoundingCircleTest(String name) {
        super(name);
    }

    public void testEmptyPoint() throws Exception {
        this.doMinimumBoundingCircleTest("POINT EMPTY", "MULTIPOINT EMPTY");
    }

    public void testPoint() throws Exception {
        this.doMinimumBoundingCircleTest("POINT (10 10)", "POINT (10 10)", new Coordinate(10.0, 10.0), 0.0);
    }

    public void testPoints2() throws Exception {
        this.doMinimumBoundingCircleTest("MULTIPOINT ((10 10), (20 20))", "MULTIPOINT ((10 10), (20 20))", new Coordinate(15.0, 15.0), 7.0710678118654755);
    }

    public void testPointsInLine() throws Exception {
        this.doMinimumBoundingCircleTest("MULTIPOINT ((10 10), (20 20), (30 30))", "MULTIPOINT ((10 10), (30 30))", new Coordinate(20.0, 20.0), 14.142135623730951);
    }

    public void testPoints3() throws Exception {
        this.doMinimumBoundingCircleTest("MULTIPOINT ((10 10), (20 20), (10 20))", "MULTIPOINT ((10 10), (20 20), (10 20))", new Coordinate(15.0, 15.0), 7.0710678118654755);
    }

    public void testObtuseTriangle() throws Exception {
        this.doMinimumBoundingCircleTest("POLYGON ((100 100, 200 100, 150 90, 100 100))", "MULTIPOINT ((100 100), (200 100))", new Coordinate(150.0, 100.0), 50.0);
    }

    public void testTriangleWithMiddlePoint() throws Exception {
        this.doMinimumBoundingCircleTest("MULTIPOINT ((10 10), (20 20), (10 20), (15 19))", "MULTIPOINT ((10 10), (20 20), (10 20))", new Coordinate(15.0, 15.0), 7.0710678118654755);
    }

    public void testQuadrilateral() throws Exception {
        this.doMinimumBoundingCircleTest("POLYGON ((26426 65078, 26531 65242, 26096 65427, 26075 65136, 26426 65078))", "MULTIPOINT ((26531 65242), (26075 65136), (26096 65427))", new Coordinate(26284.84180271327, 65267.114509082545), 247.4360455914027);
    }

    public void testMaxDiameterLine() {
        this.doMaxDiameterTest("LINESTRING (100 200, 300 100)", "LINESTRING (100 200, 300 100)");
    }

    public void testMaxDiameterPolygon() {
        this.doMaxDiameterTest("POLYGON ((100 200, 300 150, 110 100, 100 200))", "LINESTRING (300 150, 100 200)");
        this.doMaxDiameterTest("POLYGON ((110 200, 300 150, 100 100, 110 200))", "LINESTRING (300 150, 100 100)");
        this.doMaxDiameterTest("POLYGON ((0 0, 6 0, 5 5, 0 0))", "LINESTRING (5 5, 0 0)");
    }

    private void doMaxDiameterTest(String wkt, String expectedWKT) {
        MinimumBoundingCircle mbc = new MinimumBoundingCircle(this.read(wkt));
        Geometry diamActual = mbc.getMaximumDiameter();
        Geometry expected = this.read(expectedWKT);
        this.checkEqual(expected, diamActual);
    }

    private void doMinimumBoundingCircleTest(String wkt, String expectedWKT) throws ParseException {
        this.doMinimumBoundingCircleTest(wkt, expectedWKT, null, -1.0);
    }

    private void doMinimumBoundingCircleTest(String wkt, String expectedWKT, Coordinate expectedCentre, double expectedRadius) {
        MinimumBoundingCircle mbc = new MinimumBoundingCircle(this.read(wkt));
        Coordinate[] exPts = mbc.getExtremalPoints();
        MultiPoint actual = this.geometryFactory.createMultiPointFromCoords(exPts);
        double actualRadius = mbc.getRadius();
        Coordinate actualCentre = mbc.getCentre();
        Geometry expected = this.read(expectedWKT);
        boolean isEqual = actual.equals(expected);
        if (actual.isEmpty() && expected.isEmpty()) {
            isEqual = true;
        }
        if (!isEqual) {
            System.out.println("Actual = " + actual + ", Expected = " + expected);
        }
        MinimumBoundingCircleTest.assertTrue((boolean)isEqual);
        if (expectedCentre != null) {
            MinimumBoundingCircleTest.assertTrue((expectedCentre.distance(actualCentre) < 1.0E-5 ? 1 : 0) != 0);
        }
        if (expectedRadius >= 0.0) {
            MinimumBoundingCircleTest.assertTrue((Math.abs(expectedRadius - actualRadius) < 1.0E-5 ? 1 : 0) != 0);
        }
    }
}

