/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.algorithm;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.Angle;
import com.hazelcast.shaded.org.locationtech.jts.algorithm.Orientation;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequence;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequenceFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequences;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.shape.random.RandomPointsBuilder;
import java.util.Arrays;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class AngleTest
extends TestCase {
    private static final double TOLERANCE = 1.0E-5;

    public static void main(String[] args) {
        TestRunner.run(AngleTest.class);
    }

    public AngleTest(String name) {
        super(name);
    }

    public void testAngle() {
        AngleTest.assertEquals((double)Angle.angle((Coordinate)AngleTest.p(10.0, 0.0)), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.angle((Coordinate)AngleTest.p(10.0, 10.0)), (double)0.7853981633974483, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.angle((Coordinate)AngleTest.p(0.0, 10.0)), (double)1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.angle((Coordinate)AngleTest.p(-10.0, 10.0)), (double)2.356194490192345, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.angle((Coordinate)AngleTest.p(-10.0, 0.0)), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.angle((Coordinate)AngleTest.p(-10.0, -0.1)), (double)-3.131592986903128, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.angle((Coordinate)AngleTest.p(-10.0, -10.0)), (double)-2.356194490192345, (double)1.0E-5);
    }

    public void testIsAcute() {
        AngleTest.assertEquals((boolean)Angle.isAcute((Coordinate)AngleTest.p(10.0, 0.0), (Coordinate)AngleTest.p(0.0, 0.0), (Coordinate)AngleTest.p(5.0, 10.0)), (boolean)true);
        AngleTest.assertEquals((boolean)Angle.isAcute((Coordinate)AngleTest.p(10.0, 0.0), (Coordinate)AngleTest.p(0.0, 0.0), (Coordinate)AngleTest.p(5.0, -10.0)), (boolean)true);
        AngleTest.assertEquals((boolean)Angle.isAcute((Coordinate)AngleTest.p(10.0, 0.0), (Coordinate)AngleTest.p(0.0, 0.0), (Coordinate)AngleTest.p(10.0, 0.0)), (boolean)true);
        AngleTest.assertEquals((boolean)Angle.isAcute((Coordinate)AngleTest.p(10.0, 0.0), (Coordinate)AngleTest.p(0.0, 0.0), (Coordinate)AngleTest.p(-5.0, 10.0)), (boolean)false);
        AngleTest.assertEquals((boolean)Angle.isAcute((Coordinate)AngleTest.p(10.0, 0.0), (Coordinate)AngleTest.p(0.0, 0.0), (Coordinate)AngleTest.p(-5.0, -10.0)), (boolean)false);
    }

    public void testNormalizePositive() {
        AngleTest.assertEquals((double)Angle.normalizePositive((double)0.0), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)-1.5707963267948966), (double)4.71238898038469, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)(-Math.PI)), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)-4.71238898038469), (double)1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)(Math.PI * -2)), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)-7.853981633974483), (double)4.71238898038469, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)(Math.PI * -3)), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)(Math.PI * -4)), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)1.5707963267948966), (double)1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)Math.PI), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)4.71238898038469), (double)4.71238898038469, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)(Math.PI * 2)), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)7.853981633974483), (double)1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)(Math.PI * 3)), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)(Math.PI * 4)), (double)0.0, (double)1.0E-5);
    }

    public void testNormalize() {
        AngleTest.assertEquals((double)Angle.normalize((double)0.0), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)-1.5707963267948966), (double)-1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)(-Math.PI)), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)-4.71238898038469), (double)1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)(Math.PI * -2)), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)-7.853981633974483), (double)-1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)(Math.PI * -3)), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)(Math.PI * -4)), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)1.5707963267948966), (double)1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)Math.PI), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)4.71238898038469), (double)-1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)(Math.PI * 2)), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)7.853981633974483), (double)1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)(Math.PI * 3)), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)(Math.PI * 4)), (double)0.0, (double)1.0E-5);
    }

    public void testInteriorAngle() {
        Coordinate p1 = AngleTest.p(1.0, 2.0);
        Coordinate p2 = AngleTest.p(3.0, 2.0);
        Coordinate p3 = AngleTest.p(2.0, 1.0);
        AngleTest.assertEquals((double)45.0, (double)Math.toDegrees(Angle.interiorAngle((Coordinate)p1, (Coordinate)p2, (Coordinate)p3)), (double)0.01);
        AngleTest.assertEquals((double)90.0, (double)Math.toDegrees(Angle.interiorAngle((Coordinate)p2, (Coordinate)p3, (Coordinate)p1)), (double)0.01);
        AngleTest.assertEquals((double)45.0, (double)Math.toDegrees(Angle.interiorAngle((Coordinate)p3, (Coordinate)p1, (Coordinate)p2)), (double)0.01);
        AngleTest.assertEquals((double)315.0, (double)Math.toDegrees(Angle.interiorAngle((Coordinate)p3, (Coordinate)p2, (Coordinate)p1)), (double)0.01);
        AngleTest.assertEquals((double)270.0, (double)Math.toDegrees(Angle.interiorAngle((Coordinate)p1, (Coordinate)p3, (Coordinate)p2)), (double)0.01);
        AngleTest.assertEquals((double)315.0, (double)Math.toDegrees(Angle.interiorAngle((Coordinate)p2, (Coordinate)p1, (Coordinate)p3)), (double)0.01);
    }

    public void testInteriorAngle_randomTriangles() {
        GeometryFactory geometryFactory = new GeometryFactory();
        CoordinateSequenceFactory coordinateSequenceFactory = geometryFactory.getCoordinateSequenceFactory();
        for (int i = 0; i < 100; ++i) {
            RandomPointsBuilder builder = new RandomPointsBuilder();
            builder.setNumPoints(3);
            Geometry threeRandomPoints = builder.getGeometry();
            Polygon triangle = geometryFactory.createPolygon(CoordinateSequences.ensureValidRing((CoordinateSequenceFactory)coordinateSequenceFactory, (CoordinateSequence)coordinateSequenceFactory.create(threeRandomPoints.getCoordinates())));
            Object[] c = Orientation.isCCW((Coordinate[])triangle.getCoordinates()) ? triangle.reverse().getCoordinates() : triangle.getCoordinates();
            double sumOfInteriorAngles = Angle.interiorAngle((Coordinate)c[0], (Coordinate)c[1], (Coordinate)c[2]) + Angle.interiorAngle((Coordinate)c[1], (Coordinate)c[2], (Coordinate)c[0]) + Angle.interiorAngle((Coordinate)c[2], (Coordinate)c[0], (Coordinate)c[1]);
            AngleTest.assertEquals((String)(i + ": The sum of the angles of a triangle is not equal to two right angles for points: " + Arrays.toString(c)), (double)Math.PI, (double)sumOfInteriorAngles, (double)0.01);
        }
    }

    public void testAngleBisector() {
        AngleTest.assertEquals((double)45.0, (double)Math.toDegrees(Angle.bisector((Coordinate)AngleTest.p(0.0, 1.0), (Coordinate)AngleTest.p(0.0, 0.0), (Coordinate)AngleTest.p(1.0, 0.0))), (double)0.01);
        AngleTest.assertEquals((double)22.5, (double)Math.toDegrees(Angle.bisector((Coordinate)AngleTest.p(1.0, 1.0), (Coordinate)AngleTest.p(0.0, 0.0), (Coordinate)AngleTest.p(1.0, 0.0))), (double)0.01);
        AngleTest.assertEquals((double)67.5, (double)Math.toDegrees(Angle.bisector((Coordinate)AngleTest.p(-1.0, 1.0), (Coordinate)AngleTest.p(0.0, 0.0), (Coordinate)AngleTest.p(1.0, 0.0))), (double)0.01);
        AngleTest.assertEquals((double)-45.0, (double)Math.toDegrees(Angle.bisector((Coordinate)AngleTest.p(0.0, -1.0), (Coordinate)AngleTest.p(0.0, 0.0), (Coordinate)AngleTest.p(1.0, 0.0))), (double)0.01);
        AngleTest.assertEquals((double)180.0, (double)Math.toDegrees(Angle.bisector((Coordinate)AngleTest.p(-1.0, -1.0), (Coordinate)AngleTest.p(0.0, 0.0), (Coordinate)AngleTest.p(-1.0, 1.0))), (double)0.01);
        AngleTest.assertEquals((double)45.0, (double)Math.toDegrees(Angle.bisector((Coordinate)AngleTest.p(13.0, 10.0), (Coordinate)AngleTest.p(10.0, 10.0), (Coordinate)AngleTest.p(10.0, 20.0))), (double)0.01);
    }

    private static Coordinate p(double x, double y) {
        return new Coordinate(x, y);
    }
}

