/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.util;

import com.hazelcast.shaded.org.apache.commons.math3.distribution.UniformRealDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathArithmeticException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotFiniteNumberException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NullArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.util.Localizable;
import com.hazelcast.shaded.org.apache.commons.math3.exception.util.LocalizedFormats;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomDataGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import com.hazelcast.shaded.org.apache.commons.math3.util.MathUtils;
import org.junit.Assert;
import org.junit.Test;

public final class MathUtilsTest {
    @Test
    public void testEqualsDouble() {
        double x = 1234.5678;
        Assert.assertTrue((boolean)MathUtils.equals((double)1234.5678, (double)1234.5678));
        Assert.assertFalse((boolean)MathUtils.equals((double)1234.5678, (double)-1234.5678));
        Assert.assertTrue((boolean)MathUtils.equals((double)Double.NaN, (double)Double.NaN));
        double mZero = -0.0;
        double zero = 0.0;
        Assert.assertTrue((boolean)MathUtils.equals((double)0.0, (double)0.0));
        Assert.assertTrue((boolean)MathUtils.equals((double)-0.0, (double)-0.0));
        Assert.assertFalse((boolean)MathUtils.equals((double)-0.0, (double)0.0));
    }

    @Test
    public void testHash() {
        double[] testArray = new double[]{Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1.0, 0.0, 1.0E-14, 1.00000000000001, Double.MIN_VALUE, Double.MAX_VALUE};
        for (int i = 0; i < testArray.length; ++i) {
            for (int j = 0; j < testArray.length; ++j) {
                if (i == j) {
                    Assert.assertEquals((long)MathUtils.hash((double)testArray[i]), (long)MathUtils.hash((double)testArray[j]));
                    Assert.assertEquals((long)MathUtils.hash((double)testArray[j]), (long)MathUtils.hash((double)testArray[i]));
                    continue;
                }
                Assert.assertTrue((MathUtils.hash((double)testArray[i]) != MathUtils.hash((double)testArray[j]) ? 1 : 0) != 0);
                Assert.assertTrue((MathUtils.hash((double)testArray[j]) != MathUtils.hash((double)testArray[i]) ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testArrayHash() {
        Assert.assertEquals((long)0L, (long)MathUtils.hash((double[])null));
        Assert.assertEquals((long)MathUtils.hash((double[])new double[]{Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1.0, 0.0}), (long)MathUtils.hash((double[])new double[]{Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1.0, 0.0}));
        Assert.assertFalse((MathUtils.hash((double[])new double[]{1.0}) == MathUtils.hash((double[])new double[]{FastMath.nextAfter((double)1.0, (double)2.0)}) ? 1 : 0) != 0);
        Assert.assertFalse((MathUtils.hash((double[])new double[]{1.0}) == MathUtils.hash((double[])new double[]{1.0, 1.0}) ? 1 : 0) != 0);
    }

    @Test
    public void testPermutedArrayHash() {
        double[] original = new double[10];
        double[] permuted = new double[10];
        RandomDataGenerator random = new RandomDataGenerator();
        for (int i = 0; i < 10; ++i) {
            UniformRealDistribution u = new UniformRealDistribution((double)i + 0.5, (double)i + 0.75);
            original[i] = u.sample();
        }
        boolean isIdentity = true;
        do {
            int[] permutation = random.nextPermutation(10, 10);
            for (int i = 0; i < 10; ++i) {
                if (i != permutation[i]) {
                    isIdentity = false;
                }
                permuted[i] = original[permutation[i]];
            }
        } while (isIdentity);
        Assert.assertFalse((MathUtils.hash((double[])original) == MathUtils.hash((double[])permuted) ? 1 : 0) != 0);
    }

    @Test
    public void testIndicatorByte() {
        Assert.assertEquals((long)1L, (long)MathUtils.copySign((byte)1, (byte)2));
        Assert.assertEquals((long)1L, (long)MathUtils.copySign((byte)1, (byte)0));
        Assert.assertEquals((long)-1L, (long)MathUtils.copySign((byte)1, (byte)-2));
    }

    @Test
    public void testIndicatorInt() {
        Assert.assertEquals((long)1L, (long)MathUtils.copySign((int)1, (int)2));
        Assert.assertEquals((long)1L, (long)MathUtils.copySign((int)1, (int)0));
        Assert.assertEquals((long)-1L, (long)MathUtils.copySign((int)1, (int)-2));
    }

    @Test
    public void testIndicatorLong() {
        Assert.assertEquals((long)1L, (long)MathUtils.copySign((long)1L, (long)2L));
        Assert.assertEquals((long)1L, (long)MathUtils.copySign((long)1L, (long)0L));
        Assert.assertEquals((long)-1L, (long)MathUtils.copySign((long)1L, (long)-2L));
    }

    @Test
    public void testIndicatorShort() {
        Assert.assertEquals((long)1L, (long)MathUtils.copySign((short)1, (short)2));
        Assert.assertEquals((long)1L, (long)MathUtils.copySign((short)1, (short)0));
        Assert.assertEquals((long)-1L, (long)MathUtils.copySign((short)1, (short)-2));
    }

    @Test
    public void testNormalizeAngle() {
        for (double a = -15.0; a <= 15.0; a += 0.1) {
            for (double b = -15.0; b <= 15.0; b += 0.2) {
                double c = MathUtils.normalizeAngle((double)a, (double)b);
                Assert.assertTrue((b - Math.PI <= c ? 1 : 0) != 0);
                Assert.assertTrue((c <= b + Math.PI ? 1 : 0) != 0);
                double twoK = FastMath.rint((double)((a - c) / Math.PI));
                Assert.assertEquals((double)c, (double)(a - twoK * Math.PI), (double)1.0E-14);
            }
        }
    }

    @Test
    public void testReduce() {
        double period = -12.222;
        double offset = 13.0;
        double delta = 1.5;
        double orig = -1.496666860658E9;
        double expected = 1.5;
        Assert.assertEquals((double)expected, (double)MathUtils.reduce((double)orig, (double)-12.222, (double)13.0), (double)1.0E-7);
        Assert.assertEquals((double)expected, (double)MathUtils.reduce((double)orig, (double)12.222, (double)13.0), (double)1.0E-7);
        orig = 1.507666686658E9;
        expected = FastMath.abs((double)-12.222) - 1.5;
        Assert.assertEquals((double)expected, (double)MathUtils.reduce((double)orig, (double)-12.222, (double)13.0), (double)1.0E-6);
        Assert.assertEquals((double)expected, (double)MathUtils.reduce((double)orig, (double)12.222, (double)13.0), (double)1.0E-6);
        orig = 1.508766669658E9;
        expected = 1.5;
        Assert.assertEquals((double)expected, (double)MathUtils.reduce((double)orig, (double)-12.222, (double)13.0), (double)1.0E-6);
        Assert.assertEquals((double)expected, (double)MathUtils.reduce((double)orig, (double)12.222, (double)13.0), (double)1.0E-6);
        Assert.assertTrue((boolean)Double.isNaN(MathUtils.reduce((double)orig, (double)Double.NaN, (double)13.0)));
        Assert.assertTrue((boolean)Double.isNaN(MathUtils.reduce((double)Double.NaN, (double)-12.222, (double)13.0)));
        Assert.assertTrue((boolean)Double.isNaN(MathUtils.reduce((double)orig, (double)-12.222, (double)Double.NaN)));
        Assert.assertTrue((boolean)Double.isNaN(MathUtils.reduce((double)orig, (double)-12.222, (double)Double.POSITIVE_INFINITY)));
        Assert.assertTrue((boolean)Double.isNaN(MathUtils.reduce((double)Double.POSITIVE_INFINITY, (double)-12.222, (double)13.0)));
        Assert.assertTrue((boolean)Double.isNaN(MathUtils.reduce((double)orig, (double)Double.POSITIVE_INFINITY, (double)13.0)));
        Assert.assertTrue((boolean)Double.isNaN(MathUtils.reduce((double)orig, (double)Double.POSITIVE_INFINITY, (double)Double.POSITIVE_INFINITY)));
        Assert.assertTrue((boolean)Double.isNaN(MathUtils.reduce((double)Double.POSITIVE_INFINITY, (double)-12.222, (double)Double.POSITIVE_INFINITY)));
        Assert.assertTrue((boolean)Double.isNaN(MathUtils.reduce((double)Double.POSITIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (double)13.0)));
        Assert.assertTrue((boolean)Double.isNaN(MathUtils.reduce((double)Double.POSITIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (double)Double.POSITIVE_INFINITY)));
    }

    @Test
    public void testReduceComparedWithNormalizeAngle() {
        double tol = Math.ulp(1.0);
        double period = Math.PI * 2;
        for (double a = -15.0; a <= 15.0; a += 0.5) {
            for (double center = -15.0; center <= 15.0; center += 1.0) {
                double nA = MathUtils.normalizeAngle((double)a, (double)center);
                double offset = center - Math.PI;
                double r = MathUtils.reduce((double)a, (double)(Math.PI * 2), (double)offset);
                Assert.assertEquals((double)nA, (double)(r + offset), (double)tol);
            }
        }
    }

    @Test
    public void testSignByte() {
        boolean one = true;
        Assert.assertEquals((long)1L, (long)MathUtils.copySign((byte)1, (byte)2));
        Assert.assertEquals((long)-1L, (long)MathUtils.copySign((byte)1, (byte)-2));
    }

    @Test
    public void testSignInt() {
        boolean one = true;
        Assert.assertEquals((long)1L, (long)MathUtils.copySign((int)1, (int)2));
        Assert.assertEquals((long)-1L, (long)MathUtils.copySign((int)1, (int)-2));
    }

    @Test
    public void testSignLong() {
        long one = 1L;
        Assert.assertEquals((long)1L, (long)MathUtils.copySign((long)1L, (long)2L));
        Assert.assertEquals((long)-1L, (long)MathUtils.copySign((long)1L, (long)-2L));
    }

    @Test
    public void testSignShort() {
        boolean one = true;
        Assert.assertEquals((long)1L, (long)MathUtils.copySign((short)1, (short)2));
        Assert.assertEquals((long)-1L, (long)MathUtils.copySign((short)1, (short)-2));
    }

    @Test
    public void testCheckFinite() {
        try {
            MathUtils.checkFinite((double)Double.POSITIVE_INFINITY);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NotFiniteNumberException notFiniteNumberException) {
            // empty catch block
        }
        try {
            MathUtils.checkFinite((double)Double.NEGATIVE_INFINITY);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NotFiniteNumberException notFiniteNumberException) {
            // empty catch block
        }
        try {
            MathUtils.checkFinite((double)Double.NaN);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NotFiniteNumberException notFiniteNumberException) {
            // empty catch block
        }
        try {
            MathUtils.checkFinite((double[])new double[]{0.0, -1.0, Double.POSITIVE_INFINITY, -2.0, 3.0});
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NotFiniteNumberException notFiniteNumberException) {
            // empty catch block
        }
        try {
            MathUtils.checkFinite((double[])new double[]{1.0, Double.NEGATIVE_INFINITY, -2.0, 3.0});
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NotFiniteNumberException notFiniteNumberException) {
            // empty catch block
        }
        try {
            MathUtils.checkFinite((double[])new double[]{4.0, 3.0, -1.0, Double.NaN, -2.0, 1.0});
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NotFiniteNumberException notFiniteNumberException) {
            // empty catch block
        }
    }

    @Test
    public void testCheckNotNull1() {
        try {
            Object obj = null;
            MathUtils.checkNotNull(obj);
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCheckNotNull2() {
        try {
            Object array = null;
            MathUtils.checkNotNull(array, (Localizable)LocalizedFormats.INPUT_ARRAY, (Object[])new Object[0]);
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCopySignByte() {
        byte a = MathUtils.copySign((byte)-128, (byte)-1);
        Assert.assertEquals((long)-128L, (long)a);
        int minValuePlusOne = -127;
        a = MathUtils.copySign((byte)-127, (byte)1);
        Assert.assertEquals((long)127L, (long)a);
        a = MathUtils.copySign((byte)127, (byte)-1);
        Assert.assertEquals((long)-127L, (long)a);
        boolean one = true;
        byte val = -2;
        a = MathUtils.copySign((byte)val, (byte)1);
        Assert.assertEquals((long)(-val), (long)a);
        int minusOne = -1;
        val = 2;
        a = MathUtils.copySign((byte)val, (byte)-1);
        Assert.assertEquals((long)(-val), (long)a);
        val = 0;
        a = MathUtils.copySign((byte)val, (byte)-1);
        Assert.assertEquals((long)val, (long)a);
        val = 0;
        a = MathUtils.copySign((byte)val, (byte)1);
        Assert.assertEquals((long)val, (long)a);
    }

    @Test(expected=MathArithmeticException.class)
    public void testCopySignByte2() {
        MathUtils.copySign((byte)-128, (byte)1);
    }
}

