/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.util;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathArithmeticException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NoDataException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NonMonotonicSequenceException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotANumberException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotPositiveException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NullArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.Well1024a;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import com.hazelcast.shaded.org.apache.commons.math3.util.MathArrays;
import com.hazelcast.shaded.org.apache.commons.math3.util.Precision;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class MathArraysTest {
    private double[] testArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
    private double[] testWeightsArray = new double[]{0.3, 0.2, 1.3, 1.1, 1.0, 1.8};
    private double[] testNegativeWeightsArray = new double[]{-0.3, 0.2, -1.3, 1.1, 1.0, 1.8};
    private double[] nullArray = null;
    private double[] singletonArray = new double[]{0.0};

    @Test
    public void testScale() {
        int i;
        double[] test = new double[]{-2.5, -1.0, 0.0, 1.0, 2.5};
        double[] correctTest = MathArrays.copyOf((double[])test);
        double[] correctScaled = new double[]{5.25, 2.1, 0.0, -2.1, -5.25};
        double[] scaled = MathArrays.scale((double)-2.1, (double[])test);
        for (i = 0; i < test.length; ++i) {
            Assert.assertEquals((double)correctTest[i], (double)test[i], (double)0.0);
        }
        for (i = 0; i < scaled.length; ++i) {
            Assert.assertEquals((double)correctScaled[i], (double)scaled[i], (double)0.0);
        }
    }

    @Test
    public void testScaleInPlace() {
        double[] test = new double[]{-2.5, -1.0, 0.0, 1.0, 2.5};
        double[] correctScaled = new double[]{5.25, 2.1, 0.0, -2.1, -5.25};
        MathArrays.scaleInPlace((double)-2.1, (double[])test);
        for (int i = 0; i < test.length; ++i) {
            Assert.assertEquals((double)correctScaled[i], (double)test[i], (double)0.0);
        }
    }

    @Test(expected=DimensionMismatchException.class)
    public void testEbeAddPrecondition() {
        MathArrays.ebeAdd((double[])new double[3], (double[])new double[4]);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testEbeSubtractPrecondition() {
        MathArrays.ebeSubtract((double[])new double[3], (double[])new double[4]);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testEbeMultiplyPrecondition() {
        MathArrays.ebeMultiply((double[])new double[3], (double[])new double[4]);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testEbeDividePrecondition() {
        MathArrays.ebeDivide((double[])new double[3], (double[])new double[4]);
    }

    @Test
    public void testEbeAdd() {
        double[] a = new double[]{0.0, 1.0, 2.0};
        double[] b = new double[]{3.0, 5.0, 7.0};
        double[] r = MathArrays.ebeAdd((double[])a, (double[])b);
        for (int i = 0; i < a.length; ++i) {
            Assert.assertEquals((double)(a[i] + b[i]), (double)r[i], (double)0.0);
        }
    }

    @Test
    public void testEbeSubtract() {
        double[] a = new double[]{0.0, 1.0, 2.0};
        double[] b = new double[]{3.0, 5.0, 7.0};
        double[] r = MathArrays.ebeSubtract((double[])a, (double[])b);
        for (int i = 0; i < a.length; ++i) {
            Assert.assertEquals((double)(a[i] - b[i]), (double)r[i], (double)0.0);
        }
    }

    @Test
    public void testEbeMultiply() {
        double[] a = new double[]{0.0, 1.0, 2.0};
        double[] b = new double[]{3.0, 5.0, 7.0};
        double[] r = MathArrays.ebeMultiply((double[])a, (double[])b);
        for (int i = 0; i < a.length; ++i) {
            Assert.assertEquals((double)(a[i] * b[i]), (double)r[i], (double)0.0);
        }
    }

    @Test
    public void testEbeDivide() {
        double[] a = new double[]{0.0, 1.0, 2.0};
        double[] b = new double[]{3.0, 5.0, 7.0};
        double[] r = MathArrays.ebeDivide((double[])a, (double[])b);
        for (int i = 0; i < a.length; ++i) {
            Assert.assertEquals((double)(a[i] / b[i]), (double)r[i], (double)0.0);
        }
    }

    @Test
    public void testL1DistanceDouble() {
        double[] p1 = new double[]{2.5, 0.0};
        double[] p2 = new double[]{-0.5, 4.0};
        Assert.assertTrue((boolean)Precision.equals((double)7.0, (double)MathArrays.distance1((double[])p1, (double[])p2), (int)1));
    }

    @Test
    public void testL1DistanceInt() {
        int[] p1 = new int[]{3, 0};
        int[] p2 = new int[]{0, 4};
        Assert.assertEquals((long)7L, (long)MathArrays.distance1((int[])p1, (int[])p2));
    }

    @Test
    public void testL2DistanceDouble() {
        double[] p1 = new double[]{2.5, 0.0};
        double[] p2 = new double[]{-0.5, 4.0};
        Assert.assertTrue((boolean)Precision.equals((double)5.0, (double)MathArrays.distance((double[])p1, (double[])p2), (int)1));
    }

    @Test
    public void testL2DistanceInt() {
        int[] p1 = new int[]{3, 0};
        int[] p2 = new int[]{0, 4};
        Assert.assertTrue((boolean)Precision.equals((double)5.0, (double)MathArrays.distance((int[])p1, (int[])p2), (int)1));
    }

    @Test
    public void testLInfDistanceDouble() {
        double[] p1 = new double[]{2.5, 0.0};
        double[] p2 = new double[]{-0.5, 4.0};
        Assert.assertTrue((boolean)Precision.equals((double)4.0, (double)MathArrays.distanceInf((double[])p1, (double[])p2), (int)1));
    }

    @Test
    public void testLInfDistanceInt() {
        int[] p1 = new int[]{3, 0};
        int[] p2 = new int[]{0, 4};
        Assert.assertEquals((long)4L, (long)MathArrays.distanceInf((int[])p1, (int[])p2));
    }

    @Test
    public void testCosAngle2D() {
        double[] v1 = new double[]{1.0, 0.0};
        double expected = 1.0;
        Assert.assertEquals((double)expected, (double)MathArrays.cosAngle((double[])v1, (double[])v1), (double)0.0);
        double[] v2 = new double[]{0.0, 1.0};
        expected = 0.0;
        Assert.assertEquals((double)expected, (double)MathArrays.cosAngle((double[])v1, (double[])v2), (double)0.0);
        double[] v3 = new double[]{7.0, 7.0};
        expected = Math.sqrt(2.0) / 2.0;
        Assert.assertEquals((double)expected, (double)MathArrays.cosAngle((double[])v1, (double[])v3), (double)1.0E-15);
        Assert.assertEquals((double)expected, (double)MathArrays.cosAngle((double[])v3, (double[])v2), (double)1.0E-15);
        double[] v4 = new double[]{-5.0, 0.0};
        expected = -1.0;
        Assert.assertEquals((double)expected, (double)MathArrays.cosAngle((double[])v1, (double[])v4), (double)0.0);
        double[] v5 = new double[]{-100.0, 100.0};
        expected = 0.0;
        Assert.assertEquals((double)expected, (double)MathArrays.cosAngle((double[])v3, (double[])v5), (double)0.0);
    }

    @Test
    public void testCosAngle3D() {
        double[] v1 = new double[]{1.0, 1.0, 0.0};
        double expected = 1.0;
        Assert.assertEquals((double)expected, (double)MathArrays.cosAngle((double[])v1, (double[])v1), (double)1.0E-15);
        double[] v2 = new double[]{1.0, 1.0, 1.0};
        expected = Math.sqrt(2.0) / Math.sqrt(3.0);
        Assert.assertEquals((double)expected, (double)MathArrays.cosAngle((double[])v1, (double[])v2), (double)1.0E-15);
    }

    @Test
    public void testCosAngleExtreme() {
        double tiny = 1.0E-200;
        double[] v1 = new double[]{1.0E-200, 1.0E-200};
        double big = 1.0E200;
        double[] v2 = new double[]{-1.0E200, -1.0E200};
        double expected = -1.0;
        Assert.assertEquals((double)expected, (double)MathArrays.cosAngle((double[])v1, (double[])v2), (double)1.0E-15);
        double[] v3 = new double[]{1.0E200, -1.0E200};
        expected = 0.0;
        Assert.assertEquals((double)expected, (double)MathArrays.cosAngle((double[])v1, (double[])v3), (double)1.0E-15);
    }

    @Test
    public void testCheckOrder() {
        MathArrays.checkOrder((double[])new double[]{-15.0, -5.5, -1.0, 2.0, 15.0}, (MathArrays.OrderDirection)MathArrays.OrderDirection.INCREASING, (boolean)true);
        MathArrays.checkOrder((double[])new double[]{-15.0, -5.5, -1.0, 2.0, 2.0}, (MathArrays.OrderDirection)MathArrays.OrderDirection.INCREASING, (boolean)false);
        MathArrays.checkOrder((double[])new double[]{3.0, -5.5, -11.0, -27.5}, (MathArrays.OrderDirection)MathArrays.OrderDirection.DECREASING, (boolean)true);
        MathArrays.checkOrder((double[])new double[]{3.0, 0.0, 0.0, -5.5, -11.0, -27.5}, (MathArrays.OrderDirection)MathArrays.OrderDirection.DECREASING, (boolean)false);
        try {
            MathArrays.checkOrder((double[])new double[]{-15.0, -5.5, -1.0, -1.0, 2.0, 15.0}, (MathArrays.OrderDirection)MathArrays.OrderDirection.INCREASING, (boolean)true);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NonMonotonicSequenceException nonMonotonicSequenceException) {
            // empty catch block
        }
        try {
            MathArrays.checkOrder((double[])new double[]{-15.0, -5.5, -1.0, -2.0, 2.0}, (MathArrays.OrderDirection)MathArrays.OrderDirection.INCREASING, (boolean)false);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NonMonotonicSequenceException nonMonotonicSequenceException) {
            // empty catch block
        }
        try {
            MathArrays.checkOrder((double[])new double[]{3.0, 3.0, -5.5, -11.0, -27.5}, (MathArrays.OrderDirection)MathArrays.OrderDirection.DECREASING, (boolean)true);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NonMonotonicSequenceException nonMonotonicSequenceException) {
            // empty catch block
        }
        try {
            MathArrays.checkOrder((double[])new double[]{3.0, -1.0, 0.0, -5.5, -11.0, -27.5}, (MathArrays.OrderDirection)MathArrays.OrderDirection.DECREASING, (boolean)false);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NonMonotonicSequenceException nonMonotonicSequenceException) {
            // empty catch block
        }
        try {
            MathArrays.checkOrder((double[])new double[]{3.0, 0.0, -5.5, -11.0, -10.0}, (MathArrays.OrderDirection)MathArrays.OrderDirection.DECREASING, (boolean)false);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NonMonotonicSequenceException nonMonotonicSequenceException) {
            // empty catch block
        }
    }

    @Test
    public void testIsMonotonic() {
        Assert.assertFalse((boolean)MathArrays.isMonotonic((double[])new double[]{-15.0, -5.5, -1.0, -1.0, 2.0, 15.0}, (MathArrays.OrderDirection)MathArrays.OrderDirection.INCREASING, (boolean)true));
        Assert.assertTrue((boolean)MathArrays.isMonotonic((double[])new double[]{-15.0, -5.5, -1.0, 0.0, 2.0, 15.0}, (MathArrays.OrderDirection)MathArrays.OrderDirection.INCREASING, (boolean)true));
        Assert.assertFalse((boolean)MathArrays.isMonotonic((double[])new double[]{-15.0, -5.5, -1.0, -2.0, 2.0}, (MathArrays.OrderDirection)MathArrays.OrderDirection.INCREASING, (boolean)false));
        Assert.assertTrue((boolean)MathArrays.isMonotonic((double[])new double[]{-15.0, -5.5, -1.0, -1.0, 2.0}, (MathArrays.OrderDirection)MathArrays.OrderDirection.INCREASING, (boolean)false));
        Assert.assertFalse((boolean)MathArrays.isMonotonic((double[])new double[]{3.0, 3.0, -5.5, -11.0, -27.5}, (MathArrays.OrderDirection)MathArrays.OrderDirection.DECREASING, (boolean)true));
        Assert.assertTrue((boolean)MathArrays.isMonotonic((double[])new double[]{3.0, 2.0, -5.5, -11.0, -27.5}, (MathArrays.OrderDirection)MathArrays.OrderDirection.DECREASING, (boolean)true));
        Assert.assertFalse((boolean)MathArrays.isMonotonic((double[])new double[]{3.0, -1.0, 0.0, -5.5, -11.0, -27.5}, (MathArrays.OrderDirection)MathArrays.OrderDirection.DECREASING, (boolean)false));
        Assert.assertTrue((boolean)MathArrays.isMonotonic((double[])new double[]{3.0, 0.0, 0.0, -5.5, -11.0, -27.5}, (MathArrays.OrderDirection)MathArrays.OrderDirection.DECREASING, (boolean)false));
    }

    @Test
    public void testIsMonotonicComparable() {
        Assert.assertFalse((boolean)MathArrays.isMonotonic((Comparable[])new Double[]{new Double(-15.0), new Double(-5.5), new Double(-1.0), new Double(-1.0), new Double(2.0), new Double(15.0)}, (MathArrays.OrderDirection)MathArrays.OrderDirection.INCREASING, (boolean)true));
        Assert.assertTrue((boolean)MathArrays.isMonotonic((Comparable[])new Double[]{new Double(-15.0), new Double(-5.5), new Double(-1.0), new Double(0.0), new Double(2.0), new Double(15.0)}, (MathArrays.OrderDirection)MathArrays.OrderDirection.INCREASING, (boolean)true));
        Assert.assertFalse((boolean)MathArrays.isMonotonic((Comparable[])new Double[]{new Double(-15.0), new Double(-5.5), new Double(-1.0), new Double(-2.0), new Double(2.0)}, (MathArrays.OrderDirection)MathArrays.OrderDirection.INCREASING, (boolean)false));
        Assert.assertTrue((boolean)MathArrays.isMonotonic((Comparable[])new Double[]{new Double(-15.0), new Double(-5.5), new Double(-1.0), new Double(-1.0), new Double(2.0)}, (MathArrays.OrderDirection)MathArrays.OrderDirection.INCREASING, (boolean)false));
        Assert.assertFalse((boolean)MathArrays.isMonotonic((Comparable[])new Double[]{new Double(3.0), new Double(3.0), new Double(-5.5), new Double(-11.0), new Double(-27.5)}, (MathArrays.OrderDirection)MathArrays.OrderDirection.DECREASING, (boolean)true));
        Assert.assertTrue((boolean)MathArrays.isMonotonic((Comparable[])new Double[]{new Double(3.0), new Double(2.0), new Double(-5.5), new Double(-11.0), new Double(-27.5)}, (MathArrays.OrderDirection)MathArrays.OrderDirection.DECREASING, (boolean)true));
        Assert.assertFalse((boolean)MathArrays.isMonotonic((Comparable[])new Double[]{new Double(3.0), new Double(-1.0), new Double(0.0), new Double(-5.5), new Double(-11.0), new Double(-27.5)}, (MathArrays.OrderDirection)MathArrays.OrderDirection.DECREASING, (boolean)false));
        Assert.assertTrue((boolean)MathArrays.isMonotonic((Comparable[])new Double[]{new Double(3.0), new Double(0.0), new Double(0.0), new Double(-5.5), new Double(-11.0), new Double(-27.5)}, (MathArrays.OrderDirection)MathArrays.OrderDirection.DECREASING, (boolean)false));
    }

    @Test
    public void testCheckRectangular() {
        long[][] rect = new long[][]{{0L, 1L}, {2L, 3L}};
        long[][] ragged = new long[][]{{0L, 1L}, {2L}};
        long[][] nullArray = null;
        long[][] empty = new long[][]{};
        MathArrays.checkRectangular((long[][])rect);
        MathArrays.checkRectangular((long[][])empty);
        try {
            MathArrays.checkRectangular((long[][])ragged);
            Assert.fail((String)"Expecting DimensionMismatchException");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            MathArrays.checkRectangular((long[][])nullArray);
            Assert.fail((String)"Expecting NullArgumentException");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCheckPositive() {
        double[] positive = new double[]{1.0, 2.0, 3.0};
        double[] nonNegative = new double[]{0.0, 1.0, 2.0};
        double[] nullArray = null;
        double[] empty = new double[]{};
        MathArrays.checkPositive((double[])positive);
        MathArrays.checkPositive((double[])empty);
        try {
            MathArrays.checkPositive(nullArray);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            MathArrays.checkPositive((double[])nonNegative);
            Assert.fail((String)"Expecting NotStrictlyPositiveException");
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            // empty catch block
        }
    }

    @Test
    public void testCheckNonNegative() {
        long[] nonNegative = new long[]{0L, 1L};
        long[] hasNegative = new long[]{-1L};
        long[] nullArray = null;
        long[] empty = new long[]{};
        MathArrays.checkNonNegative((long[])nonNegative);
        MathArrays.checkNonNegative((long[])empty);
        try {
            MathArrays.checkNonNegative(nullArray);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            MathArrays.checkNonNegative((long[])hasNegative);
            Assert.fail((String)"Expecting NotPositiveException");
        }
        catch (NotPositiveException notPositiveException) {
            // empty catch block
        }
    }

    @Test
    public void testCheckNonNegative2D() {
        long[][] nonNegative = new long[][]{{0L, 1L}, {1L, 0L}};
        long[][] hasNegative = new long[][]{{-1L}, {0L}};
        long[][] nullArray = null;
        long[][] empty = new long[][]{};
        MathArrays.checkNonNegative((long[][])nonNegative);
        MathArrays.checkNonNegative((long[][])empty);
        try {
            MathArrays.checkNonNegative((long[][])nullArray);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            MathArrays.checkNonNegative((long[][])hasNegative);
            Assert.fail((String)"Expecting NotPositiveException");
        }
        catch (NotPositiveException notPositiveException) {
            // empty catch block
        }
    }

    @Test
    public void testCheckNotNaN() {
        double[] withoutNaN = new double[]{Double.NEGATIVE_INFINITY, -1.7976931348623157E308, -1.0, 0.0, Double.MIN_VALUE, FastMath.ulp((double)1.0), 1.0, 3.0, 113.0, 4769.0, Double.MAX_VALUE, Double.POSITIVE_INFINITY};
        double[] withNaN = new double[]{Double.NEGATIVE_INFINITY, -1.7976931348623157E308, -1.0, 0.0, Double.MIN_VALUE, FastMath.ulp((double)1.0), 1.0, 3.0, 113.0, 4769.0, Double.MAX_VALUE, Double.POSITIVE_INFINITY, Double.NaN};
        double[] nullArray = null;
        double[] empty = new double[]{};
        MathArrays.checkNotNaN((double[])withoutNaN);
        MathArrays.checkNotNaN((double[])empty);
        try {
            MathArrays.checkNotNaN(nullArray);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            MathArrays.checkNotNaN((double[])withNaN);
            Assert.fail((String)"Expecting NotANumberException");
        }
        catch (NotANumberException notANumberException) {
            // empty catch block
        }
    }

    @Test(expected=DimensionMismatchException.class)
    public void testCheckEqualLength1() {
        MathArrays.checkEqualLength((double[])new double[]{1.0, 2.0, 3.0}, (double[])new double[]{1.0, 2.0, 3.0, 4.0});
    }

    @Test
    public void testCheckEqualLength2() {
        double[] a = new double[]{-1.0, -12.0, -23.0, -34.0};
        double[] b = new double[]{56.0, 67.0, 78.0, 89.0};
        Assert.assertTrue((boolean)MathArrays.checkEqualLength((double[])a, (double[])b, (boolean)false));
    }

    @Test
    public void testSortInPlace() {
        double[] x1 = new double[]{2.0, 5.0, -3.0, 1.0, 4.0};
        double[] x2 = new double[]{4.0, 25.0, 9.0, 1.0, 16.0};
        double[] x3 = new double[]{8.0, 125.0, -27.0, 1.0, 64.0};
        MathArrays.sortInPlace((double[])x1, (double[][])new double[][]{x2, x3});
        Assert.assertEquals((double)-3.0, (double)x1[0], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)9.0, (double)x2[0], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)-27.0, (double)x3[0], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)1.0, (double)x1[1], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)1.0, (double)x2[1], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)1.0, (double)x3[1], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)2.0, (double)x1[2], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)4.0, (double)x2[2], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)8.0, (double)x3[2], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)4.0, (double)x1[3], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)16.0, (double)x2[3], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)64.0, (double)x3[3], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)5.0, (double)x1[4], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)25.0, (double)x2[4], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)125.0, (double)x3[4], (double)FastMath.ulp((double)1.0));
    }

    @Test
    public void testSortInPlaceDecresasingOrder() {
        double[] x1 = new double[]{2.0, 5.0, -3.0, 1.0, 4.0};
        double[] x2 = new double[]{4.0, 25.0, 9.0, 1.0, 16.0};
        double[] x3 = new double[]{8.0, 125.0, -27.0, 1.0, 64.0};
        MathArrays.sortInPlace((double[])x1, (MathArrays.OrderDirection)MathArrays.OrderDirection.DECREASING, (double[][])new double[][]{x2, x3});
        Assert.assertEquals((double)-3.0, (double)x1[4], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)9.0, (double)x2[4], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)-27.0, (double)x3[4], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)1.0, (double)x1[3], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)1.0, (double)x2[3], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)1.0, (double)x3[3], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)2.0, (double)x1[2], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)4.0, (double)x2[2], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)8.0, (double)x3[2], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)4.0, (double)x1[1], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)16.0, (double)x2[1], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)64.0, (double)x3[1], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)5.0, (double)x1[0], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)25.0, (double)x2[0], (double)FastMath.ulp((double)1.0));
        Assert.assertEquals((double)125.0, (double)x3[0], (double)FastMath.ulp((double)1.0));
    }

    @Test
    public void testSortInPlaceExample() {
        double[] x = new double[]{3.0, 1.0, 2.0};
        double[] y = new double[]{1.0, 2.0, 3.0};
        double[] z = new double[]{0.0, 5.0, 7.0};
        MathArrays.sortInPlace((double[])x, (double[][])new double[][]{y, z});
        double[] sx = new double[]{1.0, 2.0, 3.0};
        double[] sy = new double[]{2.0, 3.0, 1.0};
        double[] sz = new double[]{5.0, 7.0, 0.0};
        Assert.assertTrue((boolean)Arrays.equals(sx, x));
        Assert.assertTrue((boolean)Arrays.equals(sy, y));
        Assert.assertTrue((boolean)Arrays.equals(sz, z));
    }

    @Test
    public void testSortInPlaceFailures() {
        Object nullArray = null;
        double[] one = new double[]{1.0};
        double[] two = new double[]{1.0, 2.0};
        double[] onep = new double[]{2.0};
        try {
            MathArrays.sortInPlace((double[])one, (double[][])new double[][]{two});
            Assert.fail((String)"Expecting DimensionMismatchException");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            MathArrays.sortInPlace((double[])one, (double[][])new double[][]{nullArray});
            Assert.fail((String)"Expecting NullArgumentException");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            MathArrays.sortInPlace((double[])one, (double[][])new double[][]{onep, nullArray});
            Assert.fail((String)"Expecting NullArgumentException");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCopyOfInt() {
        int[] source = new int[]{Integer.MIN_VALUE, -1, 0, 1, 3, 113, 4769, Integer.MAX_VALUE};
        int[] dest = MathArrays.copyOf((int[])source);
        Assert.assertEquals((long)dest.length, (long)source.length);
        for (int i = 0; i < source.length; ++i) {
            Assert.assertEquals((long)source[i], (long)dest[i]);
        }
    }

    @Test
    public void testCopyOfInt2() {
        int[] source = new int[]{Integer.MIN_VALUE, -1, 0, 1, 3, 113, 4769, Integer.MAX_VALUE};
        int offset = 3;
        int[] dest = MathArrays.copyOf((int[])source, (int)(source.length - 3));
        Assert.assertEquals((long)dest.length, (long)(source.length - 3));
        for (int i = 0; i < source.length - 3; ++i) {
            Assert.assertEquals((long)source[i], (long)dest[i]);
        }
    }

    @Test
    public void testCopyOfInt3() {
        int i;
        int[] source = new int[]{Integer.MIN_VALUE, -1, 0, 1, 3, 113, 4769, Integer.MAX_VALUE};
        int offset = 3;
        int[] dest = MathArrays.copyOf((int[])source, (int)(source.length + 3));
        Assert.assertEquals((long)dest.length, (long)(source.length + 3));
        for (i = 0; i < source.length; ++i) {
            Assert.assertEquals((long)source[i], (long)dest[i]);
        }
        for (i = source.length; i < source.length + 3; ++i) {
            Assert.assertEquals((float)0.0f, (float)dest[i], (float)0.0f);
        }
    }

    @Test
    public void testCopyOfDouble() {
        double[] source = new double[]{Double.NEGATIVE_INFINITY, -1.7976931348623157E308, -1.0, 0.0, Double.MIN_VALUE, FastMath.ulp((double)1.0), 1.0, 3.0, 113.0, 4769.0, Double.MAX_VALUE, Double.POSITIVE_INFINITY};
        double[] dest = MathArrays.copyOf((double[])source);
        Assert.assertEquals((long)dest.length, (long)source.length);
        for (int i = 0; i < source.length; ++i) {
            Assert.assertEquals((double)source[i], (double)dest[i], (double)0.0);
        }
    }

    @Test
    public void testCopyOfDouble2() {
        double[] source = new double[]{Double.NEGATIVE_INFINITY, -1.7976931348623157E308, -1.0, 0.0, Double.MIN_VALUE, FastMath.ulp((double)1.0), 1.0, 3.0, 113.0, 4769.0, Double.MAX_VALUE, Double.POSITIVE_INFINITY};
        int offset = 3;
        double[] dest = MathArrays.copyOf((double[])source, (int)(source.length - 3));
        Assert.assertEquals((long)dest.length, (long)(source.length - 3));
        for (int i = 0; i < source.length - 3; ++i) {
            Assert.assertEquals((double)source[i], (double)dest[i], (double)0.0);
        }
    }

    @Test
    public void testCopyOfDouble3() {
        int i;
        double[] source = new double[]{Double.NEGATIVE_INFINITY, -1.7976931348623157E308, -1.0, 0.0, Double.MIN_VALUE, FastMath.ulp((double)1.0), 1.0, 3.0, 113.0, 4769.0, Double.MAX_VALUE, Double.POSITIVE_INFINITY};
        int offset = 3;
        double[] dest = MathArrays.copyOf((double[])source, (int)(source.length + 3));
        Assert.assertEquals((long)dest.length, (long)(source.length + 3));
        for (i = 0; i < source.length; ++i) {
            Assert.assertEquals((double)source[i], (double)dest[i], (double)0.0);
        }
        for (i = source.length; i < source.length + 3; ++i) {
            Assert.assertEquals((double)0.0, (double)dest[i], (double)0.0);
        }
    }

    @Test
    public void testCopyOfRange() {
        int i;
        double[] source = new double[]{Double.NEGATIVE_INFINITY, -1.7976931348623157E308, -1.0, 0.0, Double.MIN_VALUE, FastMath.ulp((double)1.0), 1.0, 3.0, 113.0, 4769.0, Double.MAX_VALUE, Double.POSITIVE_INFINITY};
        int from = 3;
        int to = source.length + 14;
        double[] dest = MathArrays.copyOfRange((double[])source, (int)3, (int)to);
        Assert.assertEquals((long)dest.length, (long)(to - 3));
        for (i = 3; i < source.length; ++i) {
            Assert.assertEquals((double)source[i], (double)dest[i - 3], (double)0.0);
        }
        for (i = source.length; i < dest.length; ++i) {
            Assert.assertEquals((double)0.0, (double)dest[i - 3], (double)0.0);
        }
    }

    @Test
    public void testLinearCombinationWithSingleElementArray() {
        double[] a = new double[]{1.23456789};
        double[] b = new double[]{9.87654321E7};
        Assert.assertEquals((double)(a[0] * b[0]), (double)MathArrays.linearCombination((double[])a, (double[])b), (double)0.0);
    }

    @Test
    public void testLinearCombination1() {
        double[] a = new double[]{-4921140.837095533, -2.1512094250440013E7, -890093.2794263769};
        double[] b = new double[]{-2.7238580938724895E9, -2.1696649213418756E9, 6.7496887088853004E10};
        double abSumInline = MathArrays.linearCombination((double)a[0], (double)b[0], (double)a[1], (double)b[1], (double)a[2], (double)b[2]);
        double abSumArray = MathArrays.linearCombination((double[])a, (double[])b);
        Assert.assertEquals((double)abSumInline, (double)abSumArray, (double)0.0);
        Assert.assertEquals((double)-1.8551294182586249, (double)abSumInline, (double)1.0E-15);
        double naive = a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
        Assert.assertTrue((FastMath.abs((double)(naive - abSumInline)) > 1.5 ? 1 : 0) != 0);
    }

    @Test
    public void testLinearCombination2() {
        Well1024a random = new Well1024a(553267312521321234L);
        for (int i = 0; i < 10000; ++i) {
            double ux = 1.0E17 * random.nextDouble();
            double uy = 1.0E17 * random.nextDouble();
            double uz = 1.0E17 * random.nextDouble();
            double vx = 1.0E17 * random.nextDouble();
            double vy = 1.0E17 * random.nextDouble();
            double vz = 1.0E17 * random.nextDouble();
            double sInline = MathArrays.linearCombination((double)ux, (double)vx, (double)uy, (double)vy, (double)uz, (double)vz);
            double sArray = MathArrays.linearCombination((double[])new double[]{ux, uy, uz}, (double[])new double[]{vx, vy, vz});
            Assert.assertEquals((double)sInline, (double)sArray, (double)0.0);
        }
    }

    @Test
    public void testLinearCombinationHuge() {
        int scale = 971;
        double[] a = new double[]{-4921140.837095533, -2.1512094250440013E7, -890093.2794263769};
        double[] b = new double[]{-2.7238580938724895E9, -2.1696649213418756E9, 6.7496887088853004E10};
        double[] scaledA = new double[a.length];
        double[] scaledB = new double[b.length];
        for (int i = 0; i < scaledA.length; ++i) {
            scaledA[i] = FastMath.scalb((double)a[i], (int)(-scale));
            scaledB[i] = FastMath.scalb((double)b[i], (int)scale);
        }
        double abSumInline = MathArrays.linearCombination((double)scaledA[0], (double)scaledB[0], (double)scaledA[1], (double)scaledB[1], (double)scaledA[2], (double)scaledB[2]);
        double abSumArray = MathArrays.linearCombination((double[])scaledA, (double[])scaledB);
        Assert.assertEquals((double)abSumInline, (double)abSumArray, (double)0.0);
        Assert.assertEquals((double)-1.8551294182586249, (double)abSumInline, (double)1.0E-15);
        double naive = scaledA[0] * scaledB[0] + scaledA[1] * scaledB[1] + scaledA[2] * scaledB[2];
        Assert.assertTrue((FastMath.abs((double)(naive - abSumInline)) > 1.5 ? 1 : 0) != 0);
    }

    @Test
    public void testLinearCombinationInfinite() {
        double[][] a = new double[][]{{1.0, 2.0, 3.0, 4.0}, {1.0, Double.POSITIVE_INFINITY, 3.0, 4.0}, {1.0, 2.0, Double.POSITIVE_INFINITY, 4.0}, {1.0, Double.POSITIVE_INFINITY, 3.0, Double.NEGATIVE_INFINITY}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}, {1.0, 2.0, 3.0, 4.0}};
        double[][] b = new double[][]{{1.0, -2.0, 3.0, 4.0}, {1.0, -2.0, 3.0, 4.0}, {1.0, -2.0, 3.0, 4.0}, {1.0, -2.0, 3.0, 4.0}, {1.0, Double.POSITIVE_INFINITY, 3.0, 4.0}, {1.0, -2.0, Double.POSITIVE_INFINITY, 4.0}, {1.0, Double.POSITIVE_INFINITY, 3.0, Double.NEGATIVE_INFINITY}, {Double.NaN, -2.0, 3.0, 4.0}};
        Assert.assertEquals((double)-3.0, (double)MathArrays.linearCombination((double)a[0][0], (double)b[0][0], (double)a[0][1], (double)b[0][1]), (double)1.0E-10);
        Assert.assertEquals((double)6.0, (double)MathArrays.linearCombination((double)a[0][0], (double)b[0][0], (double)a[0][1], (double)b[0][1], (double)a[0][2], (double)b[0][2]), (double)1.0E-10);
        Assert.assertEquals((double)22.0, (double)MathArrays.linearCombination((double)a[0][0], (double)b[0][0], (double)a[0][1], (double)b[0][1], (double)a[0][2], (double)b[0][2], (double)a[0][3], (double)b[0][3]), (double)1.0E-10);
        Assert.assertEquals((double)22.0, (double)MathArrays.linearCombination((double[])a[0], (double[])b[0]), (double)1.0E-10);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)MathArrays.linearCombination((double)a[1][0], (double)b[1][0], (double)a[1][1], (double)b[1][1]), (double)1.0E-10);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)MathArrays.linearCombination((double)a[1][0], (double)b[1][0], (double)a[1][1], (double)b[1][1], (double)a[1][2], (double)b[1][2]), (double)1.0E-10);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)MathArrays.linearCombination((double)a[1][0], (double)b[1][0], (double)a[1][1], (double)b[1][1], (double)a[1][2], (double)b[1][2], (double)a[1][3], (double)b[1][3]), (double)1.0E-10);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)MathArrays.linearCombination((double[])a[1], (double[])b[1]), (double)1.0E-10);
        Assert.assertEquals((double)-3.0, (double)MathArrays.linearCombination((double)a[2][0], (double)b[2][0], (double)a[2][1], (double)b[2][1]), (double)1.0E-10);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)MathArrays.linearCombination((double)a[2][0], (double)b[2][0], (double)a[2][1], (double)b[2][1], (double)a[2][2], (double)b[2][2]), (double)1.0E-10);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)MathArrays.linearCombination((double)a[2][0], (double)b[2][0], (double)a[2][1], (double)b[2][1], (double)a[2][2], (double)b[2][2], (double)a[2][3], (double)b[2][3]), (double)1.0E-10);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)MathArrays.linearCombination((double[])a[2], (double[])b[2]), (double)1.0E-10);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)MathArrays.linearCombination((double)a[3][0], (double)b[3][0], (double)a[3][1], (double)b[3][1]), (double)1.0E-10);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)MathArrays.linearCombination((double)a[3][0], (double)b[3][0], (double)a[3][1], (double)b[3][1], (double)a[3][2], (double)b[3][2]), (double)1.0E-10);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)MathArrays.linearCombination((double)a[3][0], (double)b[3][0], (double)a[3][1], (double)b[3][1], (double)a[3][2], (double)b[3][2], (double)a[3][3], (double)b[3][3]), (double)1.0E-10);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)MathArrays.linearCombination((double[])a[3], (double[])b[3]), (double)1.0E-10);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)MathArrays.linearCombination((double)a[4][0], (double)b[4][0], (double)a[4][1], (double)b[4][1]), (double)1.0E-10);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)MathArrays.linearCombination((double)a[4][0], (double)b[4][0], (double)a[4][1], (double)b[4][1], (double)a[4][2], (double)b[4][2]), (double)1.0E-10);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)MathArrays.linearCombination((double)a[4][0], (double)b[4][0], (double)a[4][1], (double)b[4][1], (double)a[4][2], (double)b[4][2], (double)a[4][3], (double)b[4][3]), (double)1.0E-10);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)MathArrays.linearCombination((double[])a[4], (double[])b[4]), (double)1.0E-10);
        Assert.assertEquals((double)-3.0, (double)MathArrays.linearCombination((double)a[5][0], (double)b[5][0], (double)a[5][1], (double)b[5][1]), (double)1.0E-10);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)MathArrays.linearCombination((double)a[5][0], (double)b[5][0], (double)a[5][1], (double)b[5][1], (double)a[5][2], (double)b[5][2]), (double)1.0E-10);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)MathArrays.linearCombination((double)a[5][0], (double)b[5][0], (double)a[5][1], (double)b[5][1], (double)a[5][2], (double)b[5][2], (double)a[5][3], (double)b[5][3]), (double)1.0E-10);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)MathArrays.linearCombination((double[])a[5], (double[])b[5]), (double)1.0E-10);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)MathArrays.linearCombination((double)a[6][0], (double)b[6][0], (double)a[6][1], (double)b[6][1]), (double)1.0E-10);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)MathArrays.linearCombination((double)a[6][0], (double)b[6][0], (double)a[6][1], (double)b[6][1], (double)a[6][2], (double)b[6][2]), (double)1.0E-10);
        Assert.assertTrue((boolean)Double.isNaN(MathArrays.linearCombination((double)a[6][0], (double)b[6][0], (double)a[6][1], (double)b[6][1], (double)a[6][2], (double)b[6][2], (double)a[6][3], (double)b[6][3])));
        Assert.assertTrue((boolean)Double.isNaN(MathArrays.linearCombination((double[])a[6], (double[])b[6])));
        Assert.assertTrue((boolean)Double.isNaN(MathArrays.linearCombination((double)a[7][0], (double)b[7][0], (double)a[7][1], (double)b[7][1])));
        Assert.assertTrue((boolean)Double.isNaN(MathArrays.linearCombination((double)a[7][0], (double)b[7][0], (double)a[7][1], (double)b[7][1], (double)a[7][2], (double)b[7][2])));
        Assert.assertTrue((boolean)Double.isNaN(MathArrays.linearCombination((double)a[7][0], (double)b[7][0], (double)a[7][1], (double)b[7][1], (double)a[7][2], (double)b[7][2], (double)a[7][3], (double)b[7][3])));
        Assert.assertTrue((boolean)Double.isNaN(MathArrays.linearCombination((double[])a[7], (double[])b[7])));
    }

    @Test
    public void testArrayEquals() {
        Assert.assertFalse((boolean)MathArrays.equals((double[])new double[]{1.0}, null));
        Assert.assertFalse((boolean)MathArrays.equals(null, (double[])new double[]{1.0}));
        Assert.assertTrue((boolean)MathArrays.equals((double[])null, (double[])null));
        Assert.assertFalse((boolean)MathArrays.equals((double[])new double[]{1.0}, (double[])new double[0]));
        Assert.assertTrue((boolean)MathArrays.equals((double[])new double[]{1.0}, (double[])new double[]{1.0}));
        Assert.assertTrue((boolean)MathArrays.equals((double[])new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1.0, 0.0}, (double[])new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1.0, 0.0}));
        Assert.assertFalse((boolean)MathArrays.equals((double[])new double[]{Double.NaN}, (double[])new double[]{Double.NaN}));
        Assert.assertFalse((boolean)MathArrays.equals((double[])new double[]{Double.POSITIVE_INFINITY}, (double[])new double[]{Double.NEGATIVE_INFINITY}));
        Assert.assertFalse((boolean)MathArrays.equals((double[])new double[]{1.0}, (double[])new double[]{FastMath.nextAfter((double)FastMath.nextAfter((double)1.0, (double)2.0), (double)2.0)}));
    }

    @Test
    public void testArrayEqualsIncludingNaN() {
        Assert.assertFalse((boolean)MathArrays.equalsIncludingNaN((double[])new double[]{1.0}, null));
        Assert.assertFalse((boolean)MathArrays.equalsIncludingNaN(null, (double[])new double[]{1.0}));
        Assert.assertTrue((boolean)MathArrays.equalsIncludingNaN((double[])null, (double[])null));
        Assert.assertFalse((boolean)MathArrays.equalsIncludingNaN((double[])new double[]{1.0}, (double[])new double[0]));
        Assert.assertTrue((boolean)MathArrays.equalsIncludingNaN((double[])new double[]{1.0}, (double[])new double[]{1.0}));
        Assert.assertTrue((boolean)MathArrays.equalsIncludingNaN((double[])new double[]{Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1.0, 0.0}, (double[])new double[]{Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1.0, 0.0}));
        Assert.assertFalse((boolean)MathArrays.equalsIncludingNaN((double[])new double[]{Double.POSITIVE_INFINITY}, (double[])new double[]{Double.NEGATIVE_INFINITY}));
        Assert.assertFalse((boolean)MathArrays.equalsIncludingNaN((double[])new double[]{1.0}, (double[])new double[]{FastMath.nextAfter((double)FastMath.nextAfter((double)1.0, (double)2.0), (double)2.0)}));
    }

    @Test
    public void testNormalizeArray() {
        double[] testValues1 = new double[]{1.0, 1.0, 2.0};
        TestUtils.assertEquals(new double[]{0.25, 0.25, 0.5}, MathArrays.normalizeArray((double[])testValues1, (double)1.0), Double.MIN_VALUE);
        double[] testValues2 = new double[]{-1.0, -1.0, 1.0};
        TestUtils.assertEquals(new double[]{1.0, 1.0, -1.0}, MathArrays.normalizeArray((double[])testValues2, (double)1.0), Double.MIN_VALUE);
        double[] testValues3 = new double[]{-1.0, -1.0, Double.NaN, 1.0, Double.NaN};
        TestUtils.assertEquals(new double[]{1.0, 1.0, Double.NaN, -1.0, Double.NaN}, MathArrays.normalizeArray((double[])testValues3, (double)1.0), Double.MIN_VALUE);
        double[] zeroSum = new double[]{-1.0, 1.0};
        try {
            MathArrays.normalizeArray((double[])zeroSum, (double)1.0);
            Assert.fail((String)"expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        double[] hasInf = new double[]{1.0, 2.0, 1.0, Double.NEGATIVE_INFINITY};
        try {
            MathArrays.normalizeArray((double[])hasInf, (double)1.0);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            MathArrays.normalizeArray((double[])testValues1, (double)Double.POSITIVE_INFINITY);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            MathArrays.normalizeArray((double[])testValues1, (double)Double.NaN);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testConvolve() {
        double[] x1 = new double[]{1.2, -1.8, 1.4};
        double[] h1 = new double[]{1.0, 0.8, 0.5, 0.3};
        double[] y1 = new double[]{1.2, -0.84, 0.56, 0.58, 0.16, 0.42};
        double tolerance = 1.0E-13;
        double[] yActual = MathArrays.convolve((double[])x1, (double[])h1);
        Assert.assertArrayEquals((double[])y1, (double[])yActual, (double)tolerance);
        double[] x2 = new double[]{1.0, 2.0, 3.0};
        double[] h2 = new double[]{0.0, 1.0, 0.5};
        double[] y2 = new double[]{0.0, 1.0, 2.5, 4.0, 1.5};
        yActual = MathArrays.convolve((double[])x2, (double[])h2);
        Assert.assertArrayEquals((double[])y2, (double[])yActual, (double)tolerance);
        try {
            MathArrays.convolve((double[])new double[]{1.0, 2.0}, null);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            MathArrays.convolve(null, (double[])new double[]{1.0, 2.0});
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            MathArrays.convolve((double[])new double[]{1.0, 2.0}, (double[])new double[0]);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NoDataException noDataException) {
            // empty catch block
        }
        try {
            MathArrays.convolve((double[])new double[0], (double[])new double[]{1.0, 2.0});
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NoDataException noDataException) {
            // empty catch block
        }
        try {
            MathArrays.convolve((double[])new double[0], (double[])new double[0]);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NoDataException noDataException) {
            // empty catch block
        }
    }

    @Test
    public void testShuffleTail() {
        int[] orig = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        int[] list = (int[])orig.clone();
        int start = 4;
        MathArrays.shuffle((int[])list, (int)4, (MathArrays.Position)MathArrays.Position.TAIL, (RandomGenerator)new Well1024a(7654321L));
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals((long)orig[i], (long)list[i]);
        }
        boolean ok = false;
        for (int i = 4; i < orig.length - 1; ++i) {
            if (orig[i] == list[i]) continue;
            ok = true;
            break;
        }
        Assert.assertTrue((boolean)ok);
    }

    @Test
    public void testShuffleHead() {
        int[] orig = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        int[] list = (int[])orig.clone();
        int start = 4;
        MathArrays.shuffle((int[])list, (int)4, (MathArrays.Position)MathArrays.Position.HEAD, (RandomGenerator)new Well1024a(1234567L));
        for (int i = 5; i < orig.length; ++i) {
            Assert.assertEquals((long)orig[i], (long)list[i]);
        }
        boolean ok = false;
        for (int i = 0; i <= 4; ++i) {
            if (orig[i] == list[i]) continue;
            ok = true;
            break;
        }
        Assert.assertTrue((boolean)ok);
    }

    @Test
    public void testNatural() {
        int n = 4;
        int[] expected = new int[]{0, 1, 2, 3};
        int[] natural = MathArrays.natural((int)4);
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals((long)expected[i], (long)natural[i]);
        }
    }

    @Test
    public void testNaturalZero() {
        int[] natural = MathArrays.natural((int)0);
        Assert.assertEquals((long)0L, (long)natural.length);
    }

    @Test
    public void testSequence() {
        int size = 4;
        int start = 5;
        int stride = 2;
        int[] expected = new int[]{5, 7, 9, 11};
        int[] seq = MathArrays.sequence((int)4, (int)5, (int)2);
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals((long)expected[i], (long)seq[i]);
        }
    }

    @Test
    public void testSequenceZero() {
        int[] seq = MathArrays.sequence((int)0, (int)12345, (int)6789);
        Assert.assertEquals((long)0L, (long)seq.length);
    }

    @Test
    public void testVerifyValuesPositive() {
        for (int j = 0; j < 6; ++j) {
            for (int i = 1; i < 7 - j; ++i) {
                Assert.assertTrue((boolean)MathArrays.verifyValues((double[])this.testArray, (int)0, (int)i));
            }
        }
        Assert.assertTrue((boolean)MathArrays.verifyValues((double[])this.singletonArray, (int)0, (int)1));
        Assert.assertTrue((boolean)MathArrays.verifyValues((double[])this.singletonArray, (int)0, (int)0, (boolean)true));
    }

    @Test
    public void testVerifyValuesNegative() {
        Assert.assertFalse((boolean)MathArrays.verifyValues((double[])this.singletonArray, (int)0, (int)0));
        Assert.assertFalse((boolean)MathArrays.verifyValues((double[])this.testArray, (int)0, (int)0));
        try {
            MathArrays.verifyValues((double[])this.singletonArray, (int)2, (int)1);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            MathArrays.verifyValues((double[])this.testArray, (int)0, (int)7);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            MathArrays.verifyValues((double[])this.testArray, (int)-1, (int)1);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            MathArrays.verifyValues((double[])this.testArray, (int)0, (int)-1);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            MathArrays.verifyValues((double[])this.nullArray, (int)0, (int)1);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            MathArrays.verifyValues((double[])this.testArray, (double[])this.nullArray, (int)0, (int)1);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            MathArrays.verifyValues((double[])this.singletonArray, (double[])this.testWeightsArray, (int)0, (int)1);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            MathArrays.verifyValues((double[])this.testArray, (double[])this.testNegativeWeightsArray, (int)0, (int)6);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testConcatenate() {
        double[] u = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0};
        double[] x = new double[]{0.0, 1.0, 2.0};
        double[] y = new double[]{3.0, 4.0, 5.0, 6.0, 7.0, 8.0};
        double[] z = new double[]{9.0};
        Assert.assertArrayEquals((double[])u, (double[])MathArrays.concatenate((double[][])new double[][]{x, y, z}), (double)0.0);
    }

    @Test
    public void testConcatentateSingle() {
        double[] x = new double[]{0.0, 1.0, 2.0};
        Assert.assertArrayEquals((double[])x, (double[])MathArrays.concatenate((double[][])new double[][]{x}), (double)0.0);
    }

    public void testConcatenateEmptyArguments() {
        double[] x = new double[]{0.0, 1.0, 2.0};
        double[] y = new double[]{3.0};
        double[] z = new double[]{};
        double[] u = new double[]{0.0, 1.0, 2.0, 3.0};
        Assert.assertArrayEquals((double[])u, (double[])MathArrays.concatenate((double[][])new double[][]{x, z, y}), (double)0.0);
        Assert.assertArrayEquals((double[])u, (double[])MathArrays.concatenate((double[][])new double[][]{x, y, z}), (double)0.0);
        Assert.assertArrayEquals((double[])u, (double[])MathArrays.concatenate((double[][])new double[][]{z, x, y}), (double)0.0);
        Assert.assertEquals((long)0L, (long)MathArrays.concatenate((double[][])new double[][]{z, z, z}).length);
    }

    @Test(expected=NullPointerException.class)
    public void testConcatenateNullArguments() {
        double[] x = new double[]{0.0, 1.0, 2.0};
        MathArrays.concatenate((double[][])new double[][]{x, null});
    }

    @Test
    public void testUnique() {
        double[] x = new double[]{0.0, 9.0, 3.0, 0.0, 11.0, 7.0, 3.0, 5.0, -1.0, -2.0};
        double[] values = new double[]{11.0, 9.0, 7.0, 5.0, 3.0, 0.0, -1.0, -2.0};
        Assert.assertArrayEquals((double[])values, (double[])MathArrays.unique((double[])x), (double)0.0);
    }

    @Test
    public void testUniqueInfiniteValues() {
        double[] x = new double[]{0.0, Double.NEGATIVE_INFINITY, 3.0, Double.NEGATIVE_INFINITY, 3.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
        double[] u = new double[]{Double.POSITIVE_INFINITY, 3.0, 0.0, Double.NEGATIVE_INFINITY};
        Assert.assertArrayEquals((double[])u, (double[])MathArrays.unique((double[])x), (double)0.0);
    }

    @Test
    public void testUniqueNaNValues() {
        double[] x = new double[]{10.0, 2.0, Double.NaN, Double.NaN, Double.NaN, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        double[] u = MathArrays.unique((double[])x);
        Assert.assertEquals((long)5L, (long)u.length);
        Assert.assertTrue((boolean)Double.isNaN(u[0]));
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)u[1], (double)0.0);
        Assert.assertEquals((double)10.0, (double)u[2], (double)0.0);
        Assert.assertEquals((double)2.0, (double)u[3], (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)u[4], (double)0.0);
    }

    @Test(expected=NullPointerException.class)
    public void testUniqueNullArgument() {
        MathArrays.unique(null);
    }
}

