/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.util;

import com.hazelcast.shaded.org.apache.commons.math3.exception.MathArithmeticException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomDataGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.util.ArithmeticUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class ArithmeticUtilsTest {
    @Test
    public void testAddAndCheck() {
        int big = Integer.MAX_VALUE;
        int bigNeg = Integer.MIN_VALUE;
        Assert.assertEquals((long)big, (long)ArithmeticUtils.addAndCheck((int)big, (int)0));
        try {
            ArithmeticUtils.addAndCheck((int)big, (int)1);
            Assert.fail((String)"Expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        try {
            ArithmeticUtils.addAndCheck((int)bigNeg, (int)-1);
            Assert.fail((String)"Expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testAddAndCheckLong() {
        long max = Long.MAX_VALUE;
        long min = Long.MIN_VALUE;
        Assert.assertEquals((long)max, (long)ArithmeticUtils.addAndCheck((long)max, (long)0L));
        Assert.assertEquals((long)min, (long)ArithmeticUtils.addAndCheck((long)min, (long)0L));
        Assert.assertEquals((long)max, (long)ArithmeticUtils.addAndCheck((long)0L, (long)max));
        Assert.assertEquals((long)min, (long)ArithmeticUtils.addAndCheck((long)0L, (long)min));
        Assert.assertEquals((long)1L, (long)ArithmeticUtils.addAndCheck((long)-1L, (long)2L));
        Assert.assertEquals((long)1L, (long)ArithmeticUtils.addAndCheck((long)2L, (long)-1L));
        Assert.assertEquals((long)-3L, (long)ArithmeticUtils.addAndCheck((long)-2L, (long)-1L));
        Assert.assertEquals((long)min, (long)ArithmeticUtils.addAndCheck((long)(min + 1L), (long)-1L));
        Assert.assertEquals((long)-1L, (long)ArithmeticUtils.addAndCheck((long)min, (long)max));
        this.testAddAndCheckLongFailure(max, 1L);
        this.testAddAndCheckLongFailure(min, -1L);
        this.testAddAndCheckLongFailure(1L, max);
        this.testAddAndCheckLongFailure(-1L, min);
        this.testAddAndCheckLongFailure(max, max);
        this.testAddAndCheckLongFailure(min, min);
    }

    @Test
    public void testGcd() {
        int a = 30;
        int b = 50;
        int c = 77;
        Assert.assertEquals((long)0L, (long)ArithmeticUtils.gcd((int)0, (int)0));
        Assert.assertEquals((long)b, (long)ArithmeticUtils.gcd((int)0, (int)b));
        Assert.assertEquals((long)a, (long)ArithmeticUtils.gcd((int)a, (int)0));
        Assert.assertEquals((long)b, (long)ArithmeticUtils.gcd((int)0, (int)(-b)));
        Assert.assertEquals((long)a, (long)ArithmeticUtils.gcd((int)(-a), (int)0));
        Assert.assertEquals((long)10L, (long)ArithmeticUtils.gcd((int)a, (int)b));
        Assert.assertEquals((long)10L, (long)ArithmeticUtils.gcd((int)(-a), (int)b));
        Assert.assertEquals((long)10L, (long)ArithmeticUtils.gcd((int)a, (int)(-b)));
        Assert.assertEquals((long)10L, (long)ArithmeticUtils.gcd((int)(-a), (int)(-b)));
        Assert.assertEquals((long)1L, (long)ArithmeticUtils.gcd((int)a, (int)c));
        Assert.assertEquals((long)1L, (long)ArithmeticUtils.gcd((int)(-a), (int)c));
        Assert.assertEquals((long)1L, (long)ArithmeticUtils.gcd((int)a, (int)(-c)));
        Assert.assertEquals((long)1L, (long)ArithmeticUtils.gcd((int)(-a), (int)(-c)));
        Assert.assertEquals((long)98304L, (long)ArithmeticUtils.gcd((int)0x300000, (int)294912));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)ArithmeticUtils.gcd((int)Integer.MAX_VALUE, (int)0));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)ArithmeticUtils.gcd((int)-2147483647, (int)0));
        Assert.assertEquals((long)0x40000000L, (long)ArithmeticUtils.gcd((int)0x40000000, (int)Integer.MIN_VALUE));
        try {
            ArithmeticUtils.gcd((int)Integer.MIN_VALUE, (int)0);
            Assert.fail((String)"expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        try {
            ArithmeticUtils.gcd((int)0, (int)Integer.MIN_VALUE);
            Assert.fail((String)"expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        try {
            ArithmeticUtils.gcd((int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE);
            Assert.fail((String)"expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testGcdConsistency() {
        int[] primeList = new int[]{19, 23, 53, 67, 73, 79, 101, 103, 111, 131};
        ArrayList<Integer> primes = new ArrayList<Integer>();
        for (int i = 0; i < primeList.length; ++i) {
            primes.add(primeList[i]);
        }
        RandomDataGenerator randomData = new RandomDataGenerator();
        for (int i = 0; i < 20; ++i) {
            Object[] sample = randomData.nextSample(primes, 4);
            int p1 = (Integer)sample[0];
            int p2 = (Integer)sample[1];
            int p3 = (Integer)sample[2];
            int p4 = (Integer)sample[3];
            int i1 = p1 * p2 * p3;
            int i2 = p1 * p2 * p4;
            int gcd = p1 * p2;
            Assert.assertEquals((long)gcd, (long)ArithmeticUtils.gcd((int)i1, (int)i2));
            long l1 = i1;
            long l2 = i2;
            Assert.assertEquals((long)gcd, (long)ArithmeticUtils.gcd((long)l1, (long)l2));
        }
    }

    @Test
    public void testGcdLong() {
        long a = 30L;
        long b = 50L;
        long c = 77L;
        Assert.assertEquals((long)0L, (long)ArithmeticUtils.gcd((long)0L, (long)0L));
        Assert.assertEquals((long)b, (long)ArithmeticUtils.gcd((long)0L, (long)b));
        Assert.assertEquals((long)a, (long)ArithmeticUtils.gcd((long)a, (long)0L));
        Assert.assertEquals((long)b, (long)ArithmeticUtils.gcd((long)0L, (long)(-b)));
        Assert.assertEquals((long)a, (long)ArithmeticUtils.gcd((long)(-a), (long)0L));
        Assert.assertEquals((long)10L, (long)ArithmeticUtils.gcd((long)a, (long)b));
        Assert.assertEquals((long)10L, (long)ArithmeticUtils.gcd((long)(-a), (long)b));
        Assert.assertEquals((long)10L, (long)ArithmeticUtils.gcd((long)a, (long)(-b)));
        Assert.assertEquals((long)10L, (long)ArithmeticUtils.gcd((long)(-a), (long)(-b)));
        Assert.assertEquals((long)1L, (long)ArithmeticUtils.gcd((long)a, (long)c));
        Assert.assertEquals((long)1L, (long)ArithmeticUtils.gcd((long)(-a), (long)c));
        Assert.assertEquals((long)1L, (long)ArithmeticUtils.gcd((long)a, (long)(-c)));
        Assert.assertEquals((long)1L, (long)ArithmeticUtils.gcd((long)(-a), (long)(-c)));
        Assert.assertEquals((long)0x600000000000L, (long)ArithmeticUtils.gcd((long)0xC000000000000L, (long)0x1200000000000L));
        Assert.assertEquals((long)0x200000000000L, (long)ArithmeticUtils.gcd((long)0x200000000000L, (long)Long.MIN_VALUE));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)ArithmeticUtils.gcd((long)Long.MAX_VALUE, (long)0L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)ArithmeticUtils.gcd((long)-9223372036854775807L, (long)0L));
        Assert.assertEquals((long)1L, (long)ArithmeticUtils.gcd((long)60247241209L, (long)153092023L));
        try {
            ArithmeticUtils.gcd((long)Long.MIN_VALUE, (long)0L);
            Assert.fail((String)"expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        try {
            ArithmeticUtils.gcd((long)0L, (long)Long.MIN_VALUE);
            Assert.fail((String)"expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        try {
            ArithmeticUtils.gcd((long)Long.MIN_VALUE, (long)Long.MIN_VALUE);
            Assert.fail((String)"expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testLcm() {
        int a = 30;
        int b = 50;
        int c = 77;
        Assert.assertEquals((long)0L, (long)ArithmeticUtils.lcm((int)0, (int)b));
        Assert.assertEquals((long)0L, (long)ArithmeticUtils.lcm((int)a, (int)0));
        Assert.assertEquals((long)b, (long)ArithmeticUtils.lcm((int)1, (int)b));
        Assert.assertEquals((long)a, (long)ArithmeticUtils.lcm((int)a, (int)1));
        Assert.assertEquals((long)150L, (long)ArithmeticUtils.lcm((int)a, (int)b));
        Assert.assertEquals((long)150L, (long)ArithmeticUtils.lcm((int)(-a), (int)b));
        Assert.assertEquals((long)150L, (long)ArithmeticUtils.lcm((int)a, (int)(-b)));
        Assert.assertEquals((long)150L, (long)ArithmeticUtils.lcm((int)(-a), (int)(-b)));
        Assert.assertEquals((long)2310L, (long)ArithmeticUtils.lcm((int)a, (int)c));
        Assert.assertEquals((long)0xF00000L, (long)ArithmeticUtils.lcm((int)0x300000, (int)0x500000));
        Assert.assertEquals((long)0L, (long)ArithmeticUtils.lcm((int)0, (int)0));
        try {
            ArithmeticUtils.lcm((int)Integer.MIN_VALUE, (int)1);
            Assert.fail((String)"Expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        try {
            ArithmeticUtils.lcm((int)Integer.MIN_VALUE, (int)0x100000);
            Assert.fail((String)"Expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        try {
            ArithmeticUtils.lcm((int)Integer.MAX_VALUE, (int)0x7FFFFFFE);
            Assert.fail((String)"Expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testLcmLong() {
        long a = 30L;
        long b = 50L;
        long c = 77L;
        Assert.assertEquals((long)0L, (long)ArithmeticUtils.lcm((long)0L, (long)b));
        Assert.assertEquals((long)0L, (long)ArithmeticUtils.lcm((long)a, (long)0L));
        Assert.assertEquals((long)b, (long)ArithmeticUtils.lcm((long)1L, (long)b));
        Assert.assertEquals((long)a, (long)ArithmeticUtils.lcm((long)a, (long)1L));
        Assert.assertEquals((long)150L, (long)ArithmeticUtils.lcm((long)a, (long)b));
        Assert.assertEquals((long)150L, (long)ArithmeticUtils.lcm((long)(-a), (long)b));
        Assert.assertEquals((long)150L, (long)ArithmeticUtils.lcm((long)a, (long)(-b)));
        Assert.assertEquals((long)150L, (long)ArithmeticUtils.lcm((long)(-a), (long)(-b)));
        Assert.assertEquals((long)2310L, (long)ArithmeticUtils.lcm((long)a, (long)c));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)ArithmeticUtils.lcm((long)60247241209L, (long)153092023L));
        Assert.assertEquals((long)0x3C000000000000L, (long)ArithmeticUtils.lcm((long)0x600000000000L, (long)0x14000000000000L));
        Assert.assertEquals((long)0L, (long)ArithmeticUtils.lcm((long)0L, (long)0L));
        try {
            ArithmeticUtils.lcm((long)Long.MIN_VALUE, (long)1L);
            Assert.fail((String)"Expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        try {
            ArithmeticUtils.lcm((long)Long.MIN_VALUE, (long)0x100000L);
            Assert.fail((String)"Expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        Assert.assertEquals((long)4611686011984936962L, (long)ArithmeticUtils.lcm((long)Integer.MAX_VALUE, (long)0x7FFFFFFEL));
        try {
            ArithmeticUtils.lcm((long)Long.MAX_VALUE, (long)0x7FFFFFFFFFFFFFFEL);
            Assert.fail((String)"Expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testMulAndCheck() {
        int big = Integer.MAX_VALUE;
        int bigNeg = Integer.MIN_VALUE;
        Assert.assertEquals((long)big, (long)ArithmeticUtils.mulAndCheck((int)big, (int)1));
        try {
            ArithmeticUtils.mulAndCheck((int)big, (int)2);
            Assert.fail((String)"Expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        try {
            ArithmeticUtils.mulAndCheck((int)bigNeg, (int)2);
            Assert.fail((String)"Expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testMulAndCheckLong() {
        long max = Long.MAX_VALUE;
        long min = Long.MIN_VALUE;
        Assert.assertEquals((long)max, (long)ArithmeticUtils.mulAndCheck((long)max, (long)1L));
        Assert.assertEquals((long)min, (long)ArithmeticUtils.mulAndCheck((long)min, (long)1L));
        Assert.assertEquals((long)0L, (long)ArithmeticUtils.mulAndCheck((long)max, (long)0L));
        Assert.assertEquals((long)0L, (long)ArithmeticUtils.mulAndCheck((long)min, (long)0L));
        Assert.assertEquals((long)max, (long)ArithmeticUtils.mulAndCheck((long)1L, (long)max));
        Assert.assertEquals((long)min, (long)ArithmeticUtils.mulAndCheck((long)1L, (long)min));
        Assert.assertEquals((long)0L, (long)ArithmeticUtils.mulAndCheck((long)0L, (long)max));
        Assert.assertEquals((long)0L, (long)ArithmeticUtils.mulAndCheck((long)0L, (long)min));
        Assert.assertEquals((long)1L, (long)ArithmeticUtils.mulAndCheck((long)-1L, (long)-1L));
        Assert.assertEquals((long)min, (long)ArithmeticUtils.mulAndCheck((long)(min / 2L), (long)2L));
        this.testMulAndCheckLongFailure(max, 2L);
        this.testMulAndCheckLongFailure(2L, max);
        this.testMulAndCheckLongFailure(min, 2L);
        this.testMulAndCheckLongFailure(2L, min);
        this.testMulAndCheckLongFailure(min, -1L);
        this.testMulAndCheckLongFailure(-1L, min);
    }

    @Test
    public void testSubAndCheck() {
        int big = Integer.MAX_VALUE;
        int bigNeg = Integer.MIN_VALUE;
        Assert.assertEquals((long)big, (long)ArithmeticUtils.subAndCheck((int)big, (int)0));
        Assert.assertEquals((long)(bigNeg + 1), (long)ArithmeticUtils.subAndCheck((int)bigNeg, (int)-1));
        Assert.assertEquals((long)-1L, (long)ArithmeticUtils.subAndCheck((int)bigNeg, (int)(-big)));
        try {
            ArithmeticUtils.subAndCheck((int)big, (int)-1);
            Assert.fail((String)"Expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        try {
            ArithmeticUtils.subAndCheck((int)bigNeg, (int)1);
            Assert.fail((String)"Expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testSubAndCheckErrorMessage() {
        int big = Integer.MAX_VALUE;
        try {
            ArithmeticUtils.subAndCheck((int)big, (int)-1);
            Assert.fail((String)"Expecting MathArithmeticException");
        }
        catch (MathArithmeticException ex) {
            Assert.assertTrue((ex.getMessage().length() > 1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSubAndCheckLong() {
        long max = Long.MAX_VALUE;
        long min = Long.MIN_VALUE;
        Assert.assertEquals((long)max, (long)ArithmeticUtils.subAndCheck((long)max, (long)0L));
        Assert.assertEquals((long)min, (long)ArithmeticUtils.subAndCheck((long)min, (long)0L));
        Assert.assertEquals((long)(-max), (long)ArithmeticUtils.subAndCheck((long)0L, (long)max));
        Assert.assertEquals((long)(min + 1L), (long)ArithmeticUtils.subAndCheck((long)min, (long)-1L));
        Assert.assertEquals((long)-1L, (long)ArithmeticUtils.subAndCheck((long)(-max - 1L), (long)(-max)));
        Assert.assertEquals((long)max, (long)ArithmeticUtils.subAndCheck((long)-1L, (long)(-1L - max)));
        this.testSubAndCheckLongFailure(0L, min);
        this.testSubAndCheckLongFailure(max, -1L);
        this.testSubAndCheckLongFailure(min, 1L);
    }

    @Test
    public void testPow() {
        Assert.assertEquals((long)1801088541L, (long)ArithmeticUtils.pow((int)21, (int)7));
        Assert.assertEquals((long)1L, (long)ArithmeticUtils.pow((int)21, (int)0));
        try {
            ArithmeticUtils.pow((int)21, (int)-7);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)1801088541L, (long)ArithmeticUtils.pow((int)21, (int)7));
        Assert.assertEquals((long)1L, (long)ArithmeticUtils.pow((int)21, (int)0));
        try {
            ArithmeticUtils.pow((int)21, (int)-7);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)1801088541L, (long)ArithmeticUtils.pow((long)21L, (int)7));
        Assert.assertEquals((long)1L, (long)ArithmeticUtils.pow((long)21L, (int)0));
        try {
            ArithmeticUtils.pow((long)21L, (int)-7);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        BigInteger twentyOne = BigInteger.valueOf(21L);
        Assert.assertEquals((Object)BigInteger.valueOf(1801088541L), (Object)ArithmeticUtils.pow((BigInteger)twentyOne, (int)7));
        Assert.assertEquals((Object)BigInteger.ONE, (Object)ArithmeticUtils.pow((BigInteger)twentyOne, (int)0));
        try {
            ArithmeticUtils.pow((BigInteger)twentyOne, (int)-7);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)BigInteger.valueOf(1801088541L), (Object)ArithmeticUtils.pow((BigInteger)twentyOne, (long)7L));
        Assert.assertEquals((Object)BigInteger.ONE, (Object)ArithmeticUtils.pow((BigInteger)twentyOne, (long)0L));
        try {
            ArithmeticUtils.pow((BigInteger)twentyOne, (long)-7L);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)BigInteger.valueOf(1801088541L), (Object)ArithmeticUtils.pow((BigInteger)twentyOne, (BigInteger)BigInteger.valueOf(7L)));
        Assert.assertEquals((Object)BigInteger.ONE, (Object)ArithmeticUtils.pow((BigInteger)twentyOne, (BigInteger)BigInteger.ZERO));
        try {
            ArithmeticUtils.pow((BigInteger)twentyOne, (BigInteger)BigInteger.valueOf(-7L));
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        BigInteger bigOne = new BigInteger("15437869221994480283513897692658148826618371484763915343722775611762713982220306372888519211560905579993523402015636025177602059044911261");
        Assert.assertEquals((Object)bigOne, (Object)ArithmeticUtils.pow((BigInteger)twentyOne, (int)103));
        Assert.assertEquals((Object)bigOne, (Object)ArithmeticUtils.pow((BigInteger)twentyOne, (long)103L));
        Assert.assertEquals((Object)bigOne, (Object)ArithmeticUtils.pow((BigInteger)twentyOne, (BigInteger)BigInteger.valueOf(103L)));
    }

    @Test
    @Deprecated
    public void testPowDeprecated() {
        Assert.assertEquals((long)1801088541L, (long)ArithmeticUtils.pow((long)21L, (long)7L));
        Assert.assertEquals((long)1L, (long)ArithmeticUtils.pow((long)21L, (long)0L));
        try {
            ArithmeticUtils.pow((long)21L, (long)-7L);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test(expected=MathArithmeticException.class)
    public void testPowIntOverflow() {
        ArithmeticUtils.pow((int)21, (int)8);
    }

    @Test
    public void testPowInt() {
        int base = 21;
        Assert.assertEquals((long)85766121L, (long)ArithmeticUtils.pow((int)21, (int)6));
        Assert.assertEquals((long)1801088541L, (long)ArithmeticUtils.pow((int)21, (int)7));
    }

    @Test(expected=MathArithmeticException.class)
    public void testPowNegativeIntOverflow() {
        ArithmeticUtils.pow((int)-21, (int)8);
    }

    @Test
    public void testPowNegativeInt() {
        int base = -21;
        Assert.assertEquals((long)85766121L, (long)ArithmeticUtils.pow((int)-21, (int)6));
        Assert.assertEquals((long)-1801088541L, (long)ArithmeticUtils.pow((int)-21, (int)7));
    }

    @Test
    public void testPowMinusOneInt() {
        int base = -1;
        for (int i = 0; i < 100; ++i) {
            int pow = ArithmeticUtils.pow((int)-1, (int)i);
            Assert.assertEquals((String)("i: " + i), (long)(i % 2 == 0 ? 1L : -1L), (long)pow);
        }
    }

    @Test
    public void testPowOneInt() {
        boolean base = true;
        for (int i = 0; i < 100; ++i) {
            int pow = ArithmeticUtils.pow((int)1, (int)i);
            Assert.assertEquals((String)("i: " + i), (long)1L, (long)pow);
        }
    }

    @Test(expected=MathArithmeticException.class)
    public void testPowLongOverflow() {
        ArithmeticUtils.pow((int)21, (int)15);
    }

    @Test
    public void testPowLong() {
        long base = 21L;
        Assert.assertEquals((long)154472377739119461L, (long)ArithmeticUtils.pow((long)21L, (int)13));
        Assert.assertEquals((long)3243919932521508681L, (long)ArithmeticUtils.pow((long)21L, (int)14));
    }

    @Test(expected=MathArithmeticException.class)
    public void testPowNegativeLongOverflow() {
        ArithmeticUtils.pow((long)-21L, (int)15);
    }

    @Test
    public void testPowNegativeLong() {
        long base = -21L;
        Assert.assertEquals((long)-154472377739119461L, (long)ArithmeticUtils.pow((long)-21L, (int)13));
        Assert.assertEquals((long)3243919932521508681L, (long)ArithmeticUtils.pow((long)-21L, (int)14));
    }

    @Test
    public void testPowMinusOneLong() {
        long base = -1L;
        for (int i = 0; i < 100; ++i) {
            long pow = ArithmeticUtils.pow((long)-1L, (int)i);
            Assert.assertEquals((String)("i: " + i), (long)(i % 2 == 0 ? 1L : -1L), (long)pow);
        }
    }

    @Test
    public void testPowOneLong() {
        long base = 1L;
        for (int i = 0; i < 100; ++i) {
            long pow = ArithmeticUtils.pow((long)1L, (int)i);
            Assert.assertEquals((String)("i: " + i), (long)1L, (long)pow);
        }
    }

    @Test
    public void testIsPowerOfTwo() {
        int i;
        int n = 1025;
        boolean[] expected = new boolean[1025];
        Arrays.fill(expected, false);
        for (i = 1; i < expected.length; i *= 2) {
            expected[i] = true;
        }
        for (i = 0; i < expected.length; ++i) {
            boolean actual = ArithmeticUtils.isPowerOfTwo((long)i);
            Assert.assertTrue((String)Integer.toString(i), (actual == expected[i] ? 1 : 0) != 0);
        }
    }

    private void testAddAndCheckLongFailure(long a, long b) {
        try {
            ArithmeticUtils.addAndCheck((long)a, (long)b);
            Assert.fail((String)"Expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
    }

    private void testMulAndCheckLongFailure(long a, long b) {
        try {
            ArithmeticUtils.mulAndCheck((long)a, (long)b);
            Assert.fail((String)"Expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
    }

    private void testSubAndCheckLongFailure(long a, long b) {
        try {
            ArithmeticUtils.subAndCheck((long)a, (long)b);
            Assert.fail((String)"Expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
    }
}

