/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.transform;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Sin;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Sinc;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalStateException;
import com.hazelcast.shaded.org.apache.commons.math3.transform.DstNormalization;
import com.hazelcast.shaded.org.apache.commons.math3.transform.FastSineTransformer;
import com.hazelcast.shaded.org.apache.commons.math3.transform.RealTransformer;
import com.hazelcast.shaded.org.apache.commons.math3.transform.RealTransformerAbstractTest;
import com.hazelcast.shaded.org.apache.commons.math3.transform.TransformType;
import com.hazelcast.shaded.org.apache.commons.math3.transform.TransformUtils;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public final class FastSineTransformerTest
extends RealTransformerAbstractTest {
    private final DstNormalization normalization;
    private final int[] invalidDataSize;
    private final double[] relativeTolerance;
    private final int[] validDataSize;

    public FastSineTransformerTest(DstNormalization normalization) {
        this.normalization = normalization;
        this.validDataSize = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        this.invalidDataSize = new int[]{129};
        this.relativeTolerance = new double[]{1.0E-15, 1.0E-15, 1.0E-14, 1.0E-14, 1.0E-13, 1.0E-12, 1.0E-11, 1.0E-11};
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        DstNormalization[] normalization = DstNormalization.values();
        DstNormalization[][] data = new DstNormalization[normalization.length][1];
        for (int i = 0; i < normalization.length; ++i) {
            data[i][0] = normalization[i];
        }
        return Arrays.asList(data);
    }

    @Override
    double[] createRealData(int n) {
        double[] data = super.createRealData(n);
        data[0] = 0.0;
        return data;
    }

    @Override
    RealTransformer createRealTransformer() {
        return new FastSineTransformer(this.normalization);
    }

    @Override
    int getInvalidDataSize(int i) {
        return this.invalidDataSize[i];
    }

    @Override
    int getNumberOfInvalidDataSizes() {
        return this.invalidDataSize.length;
    }

    @Override
    int getNumberOfValidDataSizes() {
        return this.validDataSize.length;
    }

    @Override
    double getRelativeTolerance(int i) {
        return this.relativeTolerance[i];
    }

    @Override
    int getValidDataSize(int i) {
        return this.validDataSize[i];
    }

    @Override
    UnivariateFunction getValidFunction() {
        return new Sinc();
    }

    @Override
    double getValidLowerBound() {
        return 0.0;
    }

    @Override
    double getValidUpperBound() {
        return Math.PI;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    double[] transform(double[] x, TransformType type) {
        double s;
        int n = x.length;
        double[] y = new double[n];
        double[] sin = new double[2 * n];
        for (int i = 0; i < sin.length; ++i) {
            sin[i] = FastMath.sin((double)(Math.PI * (double)i / (double)n));
        }
        for (int j = 0; j < n; ++j) {
            double yj = 0.0;
            for (int i = 0; i < n; ++i) {
                yj += x[i] * sin[i * j % sin.length];
            }
            y[j] = yj;
        }
        if (type == TransformType.FORWARD) {
            if (this.normalization == DstNormalization.STANDARD_DST_I) {
                s = 1.0;
            } else {
                if (this.normalization != DstNormalization.ORTHOGONAL_DST_I) throw new MathIllegalStateException();
                s = FastMath.sqrt((double)(2.0 / (double)n));
            }
        } else {
            if (type != TransformType.INVERSE) throw new MathIllegalStateException();
            if (this.normalization == DstNormalization.STANDARD_DST_I) {
                s = 2.0 / (double)n;
            } else {
                if (this.normalization != DstNormalization.ORTHOGONAL_DST_I) throw new MathIllegalStateException();
                s = FastMath.sqrt((double)(2.0 / (double)n));
            }
        }
        TransformUtils.scaleArray((double[])y, (double)s);
        return y;
    }

    @Test
    public void testTransformRealFirstElementNotZero() {
        TransformType[] type = TransformType.values();
        double[] data = new double[]{1.0, 1.0, 1.0, 1.0};
        RealTransformer transformer = this.createRealTransformer();
        for (int j = 0; j < type.length; ++j) {
            try {
                transformer.transform(data, type[j]);
                Assert.fail((String)type[j].toString());
                continue;
            }
            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testAdHocData() {
        int i;
        FastSineTransformer transformer = new FastSineTransformer(DstNormalization.STANDARD_DST_I);
        double tolerance = 1.0E-12;
        double[] x = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0};
        double[] y = new double[]{0.0, 20.1093579685034, -9.65685424949238, 5.98642305066196, -4.0, 2.6727145516772, -1.65685424949238, 0.795649469518633};
        double[] result = transformer.transform(x, TransformType.FORWARD);
        for (i = 0; i < result.length; ++i) {
            Assert.assertEquals((double)y[i], (double)result[i], (double)tolerance);
        }
        result = transformer.transform(y, TransformType.INVERSE);
        for (i = 0; i < result.length; ++i) {
            Assert.assertEquals((double)x[i], (double)result[i], (double)tolerance);
        }
        TransformUtils.scaleArray((double[])x, (double)FastMath.sqrt((double)((double)x.length / 2.0)));
        transformer = new FastSineTransformer(DstNormalization.ORTHOGONAL_DST_I);
        result = transformer.transform(y, TransformType.FORWARD);
        for (i = 0; i < result.length; ++i) {
            Assert.assertEquals((double)x[i], (double)result[i], (double)tolerance);
        }
        result = transformer.transform(x, TransformType.INVERSE);
        for (i = 0; i < result.length; ++i) {
            Assert.assertEquals((double)y[i], (double)result[i], (double)tolerance);
        }
    }

    @Test
    public void testSinFunction() {
        int i;
        Sin f = new Sin();
        FastSineTransformer transformer = new FastSineTransformer(DstNormalization.STANDARD_DST_I);
        double tolerance = 1.0E-12;
        int N = 256;
        double min = 0.0;
        double max = Math.PI * 2;
        double[] result = transformer.transform((UnivariateFunction)f, min, max, N, TransformType.FORWARD);
        Assert.assertEquals((double)(N >> 1), (double)result[2], (double)tolerance);
        for (i = 0; i < N; i += i == 1 ? 2 : 1) {
            Assert.assertEquals((double)0.0, (double)result[i], (double)tolerance);
        }
        min = -Math.PI;
        max = Math.PI;
        result = transformer.transform((UnivariateFunction)f, min, max, N, TransformType.FORWARD);
        Assert.assertEquals((double)(-(N >> 1)), (double)result[2], (double)tolerance);
        for (i = 0; i < N; i += i == 1 ? 2 : 1) {
            Assert.assertEquals((double)0.0, (double)result[i], (double)tolerance);
        }
    }

    @Test
    public void testParameters() throws Exception {
        Sin f = new Sin();
        FastSineTransformer transformer = new FastSineTransformer(DstNormalization.STANDARD_DST_I);
        try {
            transformer.transform((UnivariateFunction)f, 1.0, -1.0, 64, TransformType.FORWARD);
            Assert.fail((String)"Expecting IllegalArgumentException - bad interval");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            transformer.transform((UnivariateFunction)f, -1.0, 1.0, 0, TransformType.FORWARD);
            Assert.fail((String)"Expecting IllegalArgumentException - bad samples number");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            transformer.transform((UnivariateFunction)f, -1.0, 1.0, 100, TransformType.FORWARD);
            Assert.fail((String)"Expecting IllegalArgumentException - bad samples number");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

