/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.stat.inference;

import com.hazelcast.shaded.org.apache.commons.math3.exception.NullArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.OutOfRangeException;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import com.hazelcast.shaded.org.apache.commons.math3.stat.inference.TTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TTestTest {
    protected TTest testStatistic = new TTest();
    private double[] tooShortObs = new double[]{1.0};
    private double[] emptyObs = new double[0];
    private SummaryStatistics emptyStats = new SummaryStatistics();
    SummaryStatistics tooShortStats = null;

    @Before
    public void setUp() {
        this.tooShortStats = new SummaryStatistics();
        this.tooShortStats.addValue(0.0);
    }

    @Test
    public void testOneSampleT() {
        double[] observed = new double[]{93.0, 103.0, 95.0, 101.0, 91.0, 105.0, 96.0, 94.0, 101.0, 88.0, 98.0, 94.0, 101.0, 92.0, 95.0};
        double mu = 100.0;
        SummaryStatistics sampleStats = null;
        sampleStats = new SummaryStatistics();
        for (int i = 0; i < observed.length; ++i) {
            sampleStats.addValue(observed[i]);
        }
        Assert.assertEquals((String)"t statistic", (double)-2.81976445346, (double)this.testStatistic.t(mu, observed), (double)1.0E-9);
        Assert.assertEquals((String)"t statistic", (double)-2.81976445346, (double)this.testStatistic.t(mu, (StatisticalSummary)sampleStats), (double)1.0E-9);
        Assert.assertEquals((String)"p value", (double)0.0136390585873, (double)this.testStatistic.tTest(mu, observed), (double)1.0E-9);
        Assert.assertEquals((String)"p value", (double)0.0136390585873, (double)this.testStatistic.tTest(mu, (StatisticalSummary)sampleStats), (double)1.0E-9);
        try {
            this.testStatistic.t(mu, (double[])null);
            Assert.fail((String)"arguments too short, NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.t(mu, (StatisticalSummary)((SummaryStatistics)null));
            Assert.fail((String)"arguments too short, NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.t(mu, this.emptyObs);
            Assert.fail((String)"arguments too short, NumberIsTooSmallException expected");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
        try {
            this.testStatistic.t(mu, (StatisticalSummary)this.emptyStats);
            Assert.fail((String)"arguments too short, NumberIsTooSmallException expected");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
        try {
            this.testStatistic.t(mu, this.tooShortObs);
            Assert.fail((String)"insufficient data to compute t statistic, NumberIsTooSmallException expected");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
        try {
            this.testStatistic.tTest(mu, this.tooShortObs);
            Assert.fail((String)"insufficient data to perform t test, NumberIsTooSmallException expected");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
        try {
            this.testStatistic.t(mu, (StatisticalSummary)this.tooShortStats);
            Assert.fail((String)"insufficient data to compute t statistic, NumberIsTooSmallException expected");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
        try {
            this.testStatistic.tTest(mu, (StatisticalSummary)this.tooShortStats);
            Assert.fail((String)"insufficient data to perform t test, NumberIsTooSmallException expected");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
    }

    @Test
    public void testOneSampleTTest() {
        double[] oneSidedP = new double[]{2.0, 0.0, 6.0, 6.0, 3.0, 3.0, 2.0, 3.0, -6.0, 6.0, 6.0, 6.0, 3.0, 0.0, 1.0, 1.0, 0.0, 2.0, 3.0, 3.0};
        SummaryStatistics oneSidedPStats = new SummaryStatistics();
        for (int i = 0; i < oneSidedP.length; ++i) {
            oneSidedPStats.addValue(oneSidedP[i]);
        }
        Assert.assertEquals((String)"one sample t stat", (double)3.86485535541, (double)this.testStatistic.t(0.0, oneSidedP), (double)1.0E-9);
        Assert.assertEquals((String)"one sample t stat", (double)3.86485535541, (double)this.testStatistic.t(0.0, (StatisticalSummary)oneSidedPStats), (double)1.0E-10);
        Assert.assertEquals((String)"one sample p value", (double)5.21637019637E-4, (double)(this.testStatistic.tTest(0.0, oneSidedP) / 2.0), (double)1.0E-9);
        Assert.assertEquals((String)"one sample p value", (double)5.21637019637E-4, (double)(this.testStatistic.tTest(0.0, (StatisticalSummary)oneSidedPStats) / 2.0), (double)1.0E-4);
        Assert.assertTrue((String)"one sample t-test reject", (boolean)this.testStatistic.tTest(0.0, oneSidedP, 0.01));
        Assert.assertTrue((String)"one sample t-test reject", (boolean)this.testStatistic.tTest(0.0, (StatisticalSummary)oneSidedPStats, 0.01));
        Assert.assertTrue((String)"one sample t-test accept", (!this.testStatistic.tTest(0.0, oneSidedP, 1.0E-4) ? 1 : 0) != 0);
        Assert.assertTrue((String)"one sample t-test accept", (!this.testStatistic.tTest(0.0, (StatisticalSummary)oneSidedPStats, 1.0E-4) ? 1 : 0) != 0);
        try {
            this.testStatistic.tTest(0.0, oneSidedP, 95.0);
            Assert.fail((String)"alpha out of range, OutOfRangeException expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            this.testStatistic.tTest(0.0, (StatisticalSummary)oneSidedPStats, 95.0);
            Assert.fail((String)"alpha out of range, OutOfRangeException expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testTwoSampleTHeterscedastic() {
        double[] sample1 = new double[]{7.0, -4.0, 18.0, 17.0, -3.0, -5.0, 1.0, 10.0, 11.0, -2.0};
        double[] sample2 = new double[]{-1.0, 12.0, -1.0, -3.0, 3.0, -5.0, 5.0, 2.0, -11.0, -1.0, -3.0};
        SummaryStatistics sampleStats1 = new SummaryStatistics();
        for (int i = 0; i < sample1.length; ++i) {
            sampleStats1.addValue(sample1[i]);
        }
        SummaryStatistics sampleStats2 = new SummaryStatistics();
        for (int i = 0; i < sample2.length; ++i) {
            sampleStats2.addValue(sample2[i]);
        }
        Assert.assertEquals((String)"two sample heteroscedastic t stat", (double)1.60371728768, (double)this.testStatistic.t(sample1, sample2), (double)1.0E-10);
        Assert.assertEquals((String)"two sample heteroscedastic t stat", (double)1.60371728768, (double)this.testStatistic.t((StatisticalSummary)sampleStats1, (StatisticalSummary)sampleStats2), (double)1.0E-10);
        Assert.assertEquals((String)"two sample heteroscedastic p value", (double)0.128839369622, (double)this.testStatistic.tTest(sample1, sample2), (double)1.0E-10);
        Assert.assertEquals((String)"two sample heteroscedastic p value", (double)0.128839369622, (double)this.testStatistic.tTest((StatisticalSummary)sampleStats1, (StatisticalSummary)sampleStats2), (double)1.0E-10);
        Assert.assertTrue((String)"two sample heteroscedastic t-test reject", (boolean)this.testStatistic.tTest(sample1, sample2, 0.2));
        Assert.assertTrue((String)"two sample heteroscedastic t-test reject", (boolean)this.testStatistic.tTest((StatisticalSummary)sampleStats1, (StatisticalSummary)sampleStats2, 0.2));
        Assert.assertTrue((String)"two sample heteroscedastic t-test accept", (!this.testStatistic.tTest(sample1, sample2, 0.1) ? 1 : 0) != 0);
        Assert.assertTrue((String)"two sample heteroscedastic t-test accept", (!this.testStatistic.tTest((StatisticalSummary)sampleStats1, (StatisticalSummary)sampleStats2, 0.1) ? 1 : 0) != 0);
        try {
            this.testStatistic.tTest(sample1, sample2, 0.95);
            Assert.fail((String)"alpha out of range, OutOfRangeException expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            this.testStatistic.tTest((StatisticalSummary)sampleStats1, (StatisticalSummary)sampleStats2, 0.95);
            Assert.fail((String)"alpha out of range, OutOfRangeException expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            this.testStatistic.tTest(sample1, this.tooShortObs, 0.01);
            Assert.fail((String)"insufficient data, NumberIsTooSmallException expected");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
        try {
            this.testStatistic.tTest((StatisticalSummary)sampleStats1, (StatisticalSummary)this.tooShortStats, 0.01);
            Assert.fail((String)"insufficient data, NumberIsTooSmallException expected");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
        try {
            this.testStatistic.tTest(sample1, this.tooShortObs);
            Assert.fail((String)"insufficient data, NumberIsTooSmallException expected");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
        try {
            this.testStatistic.tTest((StatisticalSummary)sampleStats1, (StatisticalSummary)this.tooShortStats);
            Assert.fail((String)"insufficient data, NumberIsTooSmallException expected");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
        try {
            this.testStatistic.t(sample1, this.tooShortObs);
            Assert.fail((String)"insufficient data, NumberIsTooSmallException expected");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
        try {
            this.testStatistic.t((StatisticalSummary)sampleStats1, (StatisticalSummary)this.tooShortStats);
            Assert.fail((String)"insufficient data, NumberIsTooSmallException expected");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
    }

    @Test
    public void testTwoSampleTHomoscedastic() {
        double[] sample1 = new double[]{2.0, 4.0, 6.0, 8.0, 10.0, 97.0};
        double[] sample2 = new double[]{4.0, 6.0, 8.0, 10.0, 16.0};
        SummaryStatistics sampleStats1 = new SummaryStatistics();
        for (int i = 0; i < sample1.length; ++i) {
            sampleStats1.addValue(sample1[i]);
        }
        SummaryStatistics sampleStats2 = new SummaryStatistics();
        for (int i = 0; i < sample2.length; ++i) {
            sampleStats2.addValue(sample2[i]);
        }
        Assert.assertEquals((String)"two sample homoscedastic t stat", (double)0.73096310086, (double)this.testStatistic.homoscedasticT(sample1, sample2), (double)1.0E-10);
        Assert.assertEquals((String)"two sample homoscedastic p value", (double)0.4833963785, (double)this.testStatistic.homoscedasticTTest((StatisticalSummary)sampleStats1, (StatisticalSummary)sampleStats2), (double)1.0E-10);
        Assert.assertTrue((String)"two sample homoscedastic t-test reject", (boolean)this.testStatistic.homoscedasticTTest(sample1, sample2, 0.49));
        Assert.assertTrue((String)"two sample homoscedastic t-test accept", (!this.testStatistic.homoscedasticTTest(sample1, sample2, 0.48) ? 1 : 0) != 0);
    }

    @Test
    public void testSmallSamples() {
        double[] sample1 = new double[]{1.0, 3.0};
        double[] sample2 = new double[]{4.0, 5.0};
        Assert.assertEquals((double)-2.2360679775, (double)this.testStatistic.t(sample1, sample2), (double)1.0E-10);
        Assert.assertEquals((double)0.198727388935, (double)this.testStatistic.tTest(sample1, sample2), (double)1.0E-10);
    }

    @Test
    public void testPaired() {
        double[] sample1 = new double[]{1.0, 3.0, 5.0, 7.0};
        double[] sample2 = new double[]{0.0, 6.0, 11.0, 2.0};
        double[] sample3 = new double[]{5.0, 7.0, 8.0, 10.0};
        Assert.assertEquals((double)-0.3133, (double)this.testStatistic.pairedT(sample1, sample2), (double)1.0E-4);
        Assert.assertEquals((double)0.774544295819, (double)this.testStatistic.pairedTTest(sample1, sample2), (double)1.0E-10);
        Assert.assertEquals((double)0.001208, (double)this.testStatistic.pairedTTest(sample1, sample3), (double)1.0E-6);
        Assert.assertFalse((boolean)this.testStatistic.pairedTTest(sample1, sample3, 0.001));
        Assert.assertTrue((boolean)this.testStatistic.pairedTTest(sample1, sample3, 0.002));
    }
}

