/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.rank;

import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatisticAbstractTest;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.UnivariateStatistic;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.rank.Max;
import org.junit.Assert;
import org.junit.Test;

public class MaxTest
extends StorelessUnivariateStatisticAbstractTest {
    protected Max stat;

    public UnivariateStatistic getUnivariateStatistic() {
        return new Max();
    }

    public double expectedValue() {
        return this.max;
    }

    @Test
    public void testSpecialValues() {
        double[] testArray = new double[]{0.0, Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
        Max max = new Max();
        Assert.assertTrue((boolean)Double.isNaN(max.getResult()));
        max.increment(testArray[0]);
        Assert.assertEquals((double)0.0, (double)max.getResult(), (double)0.0);
        max.increment(testArray[1]);
        Assert.assertEquals((double)0.0, (double)max.getResult(), (double)0.0);
        max.increment(testArray[2]);
        Assert.assertEquals((double)0.0, (double)max.getResult(), (double)0.0);
        max.increment(testArray[3]);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)max.getResult(), (double)0.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)max.evaluate(testArray), (double)0.0);
    }

    @Test
    public void testNaNs() {
        Max max = new Max();
        double nan = Double.NaN;
        Assert.assertEquals((double)3.0, (double)max.evaluate(new double[]{nan, 2.0, 3.0}), (double)0.0);
        Assert.assertEquals((double)3.0, (double)max.evaluate(new double[]{1.0, nan, 3.0}), (double)0.0);
        Assert.assertEquals((double)2.0, (double)max.evaluate(new double[]{1.0, 2.0, nan}), (double)0.0);
        Assert.assertTrue((boolean)Double.isNaN(max.evaluate(new double[]{nan, nan, nan})));
    }
}

