/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.moment;

import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatisticAbstractTest;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.UnivariateStatistic;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.moment.Mean;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.moment.SecondMoment;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class StandardDeviationTest
extends StorelessUnivariateStatisticAbstractTest {
    protected StandardDeviation stat;

    public UnivariateStatistic getUnivariateStatistic() {
        return new StandardDeviation();
    }

    public double expectedValue() {
        return this.std;
    }

    @Test
    public void testNaN() {
        StandardDeviation std = new StandardDeviation();
        Assert.assertTrue((boolean)Double.isNaN(std.getResult()));
        std.increment(1.0);
        Assert.assertEquals((double)0.0, (double)std.getResult(), (double)0.0);
    }

    @Test
    public void testPopulation() {
        double[] values = new double[]{-1.0, 3.1, 4.0, -2.1, 22.0, 11.7, 3.0, 14.0};
        double sigma = this.populationStandardDeviation(values);
        SecondMoment m = new SecondMoment();
        m.evaluate(values);
        StandardDeviation s1 = new StandardDeviation();
        s1.setBiasCorrected(false);
        Assert.assertEquals((double)sigma, (double)s1.evaluate(values), (double)1.0E-14);
        s1.incrementAll(values);
        Assert.assertEquals((double)sigma, (double)s1.getResult(), (double)1.0E-14);
        s1 = new StandardDeviation(false, m);
        Assert.assertEquals((double)sigma, (double)s1.getResult(), (double)1.0E-14);
        s1 = new StandardDeviation(false);
        Assert.assertEquals((double)sigma, (double)s1.evaluate(values), (double)1.0E-14);
        s1.incrementAll(values);
        Assert.assertEquals((double)sigma, (double)s1.getResult(), (double)1.0E-14);
    }

    protected double populationStandardDeviation(double[] v) {
        double mean = new Mean().evaluate(v);
        double sum = 0.0;
        for (int i = 0; i < v.length; ++i) {
            sum += (v[i] - mean) * (v[i] - mean);
        }
        return FastMath.sqrt((double)(sum / (double)v.length));
    }
}

