/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.stat.correlation;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.linear.BlockRealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.random.Well1024a;
import com.hazelcast.shaded.org.apache.commons.math3.stat.correlation.KendallsCorrelation;
import com.hazelcast.shaded.org.apache.commons.math3.stat.correlation.PearsonsCorrelationTest;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KendallsCorrelationTest
extends PearsonsCorrelationTest {
    private KendallsCorrelation correlation;

    @Before
    public void setUp() {
        this.correlation = new KendallsCorrelation();
    }

    @Test
    public void testLongly() {
        RealMatrix matrix = this.createRealMatrix(this.longleyData, 16, 7);
        KendallsCorrelation corrInstance = new KendallsCorrelation(matrix);
        RealMatrix correlationMatrix = corrInstance.getCorrelationMatrix();
        double[] rData = new double[]{1.0, 0.9166666666666666, 0.9333333333333332, 0.3666666666666666, 0.05, 0.8999999999999999, 0.8999999999999999, 0.9166666666666666, 1.0, 0.9833333333333333, 0.45, 0.03333333333333333, 0.9833333333333333, 0.9833333333333333, 0.9333333333333332, 0.9833333333333333, 1.0, 0.4333333333333333, 0.05, 0.9666666666666666, 0.9666666666666666, 0.3666666666666666, 0.45, 0.4333333333333333, 1.0, -0.2166666666666666, 0.4666666666666666, 0.4666666666666666, 0.05, 0.03333333333333333, 0.05, -0.2166666666666666, 1.0, 0.05, 0.05, 0.8999999999999999, 0.9833333333333333, 0.9666666666666666, 0.4666666666666666, 0.05, 1.0, 0.9999999999999999, 0.8999999999999999, 0.9833333333333333, 0.9666666666666666, 0.4666666666666666, 0.05, 0.9999999999999999, 1.0};
        TestUtils.assertEquals("Kendall's correlation matrix", this.createRealMatrix(rData, 7, 7), correlationMatrix, 1.0E-14);
    }

    @Test
    public void testSwiss() {
        RealMatrix matrix = this.createRealMatrix(this.swissData, 47, 5);
        KendallsCorrelation corrInstance = new KendallsCorrelation(matrix);
        RealMatrix correlationMatrix = corrInstance.getCorrelationMatrix();
        double[] rData = new double[]{1.0, 0.1795465254708308, -0.4762437404200669, -0.3306111613580587, 0.2453703703703704, 0.1795465254708308, 1.0, -0.4505221560842292, -0.4761645631778491, 0.2054604569820847, -0.4762437404200669, -0.4505221560842292, 1.0, 0.528943683925829, -0.3212755391722673, -0.3306111613580587, -0.4761645631778491, 0.528943683925829, 1.0, -0.08479652265379604, 0.2453703703703704, 0.2054604569820847, -0.3212755391722673, -0.08479652265379604, 1.0};
        TestUtils.assertEquals("Kendall's correlation matrix", this.createRealMatrix(rData, 5, 5), correlationMatrix, 1.0E-14);
    }

    @Test
    public void testSimpleOrdered() {
        int length = 10;
        double[] xArray = new double[10];
        double[] yArray = new double[10];
        for (int i = 0; i < 10; ++i) {
            xArray[i] = i;
            yArray[i] = i;
        }
        Assert.assertEquals((double)1.0, (double)this.correlation.correlation(xArray, yArray), (double)Double.MIN_VALUE);
    }

    @Test
    public void testSimpleReversed() {
        int length = 10;
        double[] xArray = new double[10];
        double[] yArray = new double[10];
        for (int i = 0; i < 10; ++i) {
            xArray[10 - i - 1] = i;
            yArray[i] = i;
        }
        Assert.assertEquals((double)-1.0, (double)this.correlation.correlation(xArray, yArray), (double)Double.MIN_VALUE);
    }

    @Test
    public void testSimpleOrderedPowerOf2() {
        int length = 16;
        double[] xArray = new double[16];
        double[] yArray = new double[16];
        for (int i = 0; i < 16; ++i) {
            xArray[i] = i;
            yArray[i] = i;
        }
        Assert.assertEquals((double)1.0, (double)this.correlation.correlation(xArray, yArray), (double)Double.MIN_VALUE);
    }

    @Test
    public void testSimpleReversedPowerOf2() {
        int length = 16;
        double[] xArray = new double[16];
        double[] yArray = new double[16];
        for (int i = 0; i < 16; ++i) {
            xArray[16 - i - 1] = i;
            yArray[i] = i;
        }
        Assert.assertEquals((double)-1.0, (double)this.correlation.correlation(xArray, yArray), (double)Double.MIN_VALUE);
    }

    @Test
    public void testSimpleJumble() {
        double[] xArray = new double[]{1.0, 2.0, 3.0, 4.0};
        double[] yArray = new double[]{1.0, 3.0, 2.0, 4.0};
        Assert.assertEquals((double)0.6666666666666666, (double)this.correlation.correlation(xArray, yArray), (double)Double.MIN_VALUE);
    }

    @Test
    public void testBalancedJumble() {
        double[] xArray = new double[]{1.0, 2.0, 3.0, 4.0};
        double[] yArray = new double[]{1.0, 4.0, 3.0, 2.0};
        Assert.assertEquals((double)0.0, (double)this.correlation.correlation(xArray, yArray), (double)Double.MIN_VALUE);
    }

    @Test
    public void testOrderedTies() {
        int length = 10;
        double[] xArray = new double[10];
        double[] yArray = new double[10];
        for (int i = 0; i < 10; ++i) {
            xArray[i] = i / 2;
            yArray[i] = i / 2;
        }
        Assert.assertEquals((double)1.0, (double)this.correlation.correlation(xArray, yArray), (double)Double.MIN_VALUE);
    }

    @Test
    public void testAllTiesInBoth() {
        int length = 10;
        double[] xArray = new double[10];
        double[] yArray = new double[10];
        Assert.assertEquals((double)Double.NaN, (double)this.correlation.correlation(xArray, yArray), (double)0.0);
    }

    @Test
    public void testAllTiesInX() {
        int length = 10;
        double[] xArray = new double[10];
        double[] yArray = new double[10];
        for (int i = 0; i < 10; ++i) {
            xArray[i] = i;
        }
        Assert.assertEquals((double)Double.NaN, (double)this.correlation.correlation(xArray, yArray), (double)0.0);
    }

    @Test
    public void testAllTiesInY() {
        int length = 10;
        double[] xArray = new double[10];
        double[] yArray = new double[10];
        for (int i = 0; i < 10; ++i) {
            yArray[i] = i;
        }
        Assert.assertEquals((double)Double.NaN, (double)this.correlation.correlation(xArray, yArray), (double)0.0);
    }

    @Test
    public void testSingleElement() {
        boolean length = true;
        double[] xArray = new double[1];
        double[] yArray = new double[1];
        Assert.assertEquals((double)Double.NaN, (double)this.correlation.correlation(xArray, yArray), (double)0.0);
    }

    @Test
    public void testTwoElements() {
        double[] xArray = new double[]{2.0, 1.0};
        double[] yArray = new double[]{1.0, 2.0};
        Assert.assertEquals((double)-1.0, (double)this.correlation.correlation(xArray, yArray), (double)Double.MIN_VALUE);
    }

    @Test
    public void test2dDoubleArray() {
        double[][] input = new double[][]{{2.0, 1.0, 2.0}, {1.0, 2.0, 1.0}, {0.0, 0.0, 0.0}};
        double[][] expected = new double[][]{{1.0, 0.3333333333333333, 1.0}, {0.3333333333333333, 1.0, 0.3333333333333333}, {1.0, 0.3333333333333333, 1.0}};
        Assert.assertEquals((Object)this.correlation.computeCorrelationMatrix((double[][])input), (Object)new BlockRealMatrix((double[][])expected));
    }

    @Test
    public void testBlockMatrix() {
        double[][] input = new double[][]{{2.0, 1.0, 2.0}, {1.0, 2.0, 1.0}, {0.0, 0.0, 0.0}};
        double[][] expected = new double[][]{{1.0, 0.3333333333333333, 1.0}, {0.3333333333333333, 1.0, 0.3333333333333333}, {1.0, 0.3333333333333333, 1.0}};
        Assert.assertEquals((Object)this.correlation.computeCorrelationMatrix((RealMatrix)new BlockRealMatrix((double[][])input)), (Object)new BlockRealMatrix((double[][])expected));
    }

    @Test
    public void testLargeArray() {
        double[] xArray = new double[100000];
        Arrays.fill(xArray, 0, 2500, 1.0);
        Assert.assertEquals((double)1.0, (double)this.correlation.correlation(xArray, xArray), (double)1.0E-6);
    }

    @Test
    public void testMath1277() {
        int i;
        Well1024a rng = new Well1024a(0);
        double[] xArray = new double[120000];
        double[] yArray = new double[120000];
        for (i = 0; i < xArray.length; ++i) {
            xArray[i] = rng.nextDouble();
        }
        for (i = 0; i < yArray.length; ++i) {
            yArray[i] = rng.nextDouble();
        }
        double coefficient = this.correlation.correlation(xArray, yArray);
        Assert.assertTrue((1.0 >= coefficient && -1.0 <= coefficient ? 1 : 0) != 0);
    }
}

