/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.special;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.special.Erf;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class ErfTest {
    @Test
    public void testErf0() {
        double actual = Erf.erf((double)0.0);
        double expected = 0.0;
        Assert.assertEquals((double)expected, (double)actual, (double)1.0E-15);
        Assert.assertEquals((double)(1.0 - expected), (double)Erf.erfc((double)0.0), (double)1.0E-15);
    }

    @Test
    public void testErf1960() {
        double x = 1.96 / FastMath.sqrt((double)2.0);
        double actual = Erf.erf((double)x);
        double expected = 0.95;
        Assert.assertEquals((double)expected, (double)actual, (double)1.0E-5);
        Assert.assertEquals((double)(1.0 - actual), (double)Erf.erfc((double)x), (double)1.0E-15);
        actual = Erf.erf((double)(-x));
        expected = -expected;
        Assert.assertEquals((double)expected, (double)actual, (double)1.0E-5);
        Assert.assertEquals((double)(1.0 - actual), (double)Erf.erfc((double)(-x)), (double)1.0E-15);
    }

    @Test
    public void testErf2576() {
        double x = 2.576 / FastMath.sqrt((double)2.0);
        double actual = Erf.erf((double)x);
        double expected = 0.99;
        Assert.assertEquals((double)expected, (double)actual, (double)1.0E-5);
        Assert.assertEquals((double)(1.0 - actual), (double)Erf.erfc((double)x), (double)1.0E-15);
        actual = Erf.erf((double)(-x));
        expected = -expected;
        Assert.assertEquals((double)expected, (double)actual, (double)1.0E-5);
        Assert.assertEquals((double)(1.0 - actual), (double)Erf.erfc((double)(-x)), (double)1.0E-15);
    }

    @Test
    public void testErf2807() {
        double x = 2.807 / FastMath.sqrt((double)2.0);
        double actual = Erf.erf((double)x);
        double expected = 0.995;
        Assert.assertEquals((double)expected, (double)actual, (double)1.0E-5);
        Assert.assertEquals((double)(1.0 - actual), (double)Erf.erfc((double)x), (double)1.0E-15);
        actual = Erf.erf((double)(-x));
        expected = -expected;
        Assert.assertEquals((double)expected, (double)actual, (double)1.0E-5);
        Assert.assertEquals((double)(1.0 - actual), (double)Erf.erfc((double)(-x)), (double)1.0E-15);
    }

    @Test
    public void testErf3291() {
        double x = 3.291 / FastMath.sqrt((double)2.0);
        double actual = Erf.erf((double)x);
        double expected = 0.999;
        Assert.assertEquals((double)expected, (double)actual, (double)1.0E-5);
        Assert.assertEquals((double)(1.0 - expected), (double)Erf.erfc((double)x), (double)1.0E-5);
        actual = Erf.erf((double)(-x));
        expected = -expected;
        Assert.assertEquals((double)expected, (double)actual, (double)1.0E-5);
        Assert.assertEquals((double)(1.0 - expected), (double)Erf.erfc((double)(-x)), (double)1.0E-5);
    }

    @Test
    public void testLargeValues() {
        for (int i = 1; i < 200; i *= 10) {
            double result = Erf.erf((double)i);
            Assert.assertFalse((boolean)Double.isNaN(result));
            Assert.assertTrue((result > 0.0 && result <= 1.0 ? 1 : 0) != 0);
            result = Erf.erf((double)(-i));
            Assert.assertFalse((boolean)Double.isNaN(result));
            Assert.assertTrue((result >= -1.0 && result < 0.0 ? 1 : 0) != 0);
            result = Erf.erfc((double)i);
            Assert.assertFalse((boolean)Double.isNaN(result));
            Assert.assertTrue((result >= 0.0 && result < 1.0 ? 1 : 0) != 0);
            result = Erf.erfc((double)(-i));
            Assert.assertFalse((boolean)Double.isNaN(result));
            Assert.assertTrue((result >= 1.0 && result <= 2.0 ? 1 : 0) != 0);
        }
        Assert.assertEquals((double)-1.0, (double)Erf.erf((double)Double.NEGATIVE_INFINITY), (double)0.0);
        Assert.assertEquals((double)1.0, (double)Erf.erf((double)Double.POSITIVE_INFINITY), (double)0.0);
        Assert.assertEquals((double)2.0, (double)Erf.erfc((double)Double.NEGATIVE_INFINITY), (double)0.0);
        Assert.assertEquals((double)0.0, (double)Erf.erfc((double)Double.POSITIVE_INFINITY), (double)0.0);
    }

    @Test
    public void testErfGnu() {
        double tol = 1.0E-15;
        double[] gnuValues = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -0.9999999999999927, -0.9999999999984626, -0.9999999998033839, -0.9999999845827421, -0.9999992569016276, -0.9999779095030014, -0.999593047982555, -0.9953222650189527, -0.9661051464753108, -0.8427007929497149, -0.5204998778130465, 0.0, 0.5204998778130465, 0.8427007929497149, 0.9661051464753108, 0.9953222650189527, 0.999593047982555, 0.9999779095030014, 0.9999992569016276, 0.9999999845827421, 0.9999999998033839, 0.9999999999984626, 0.9999999999999927, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        double x = -10.0;
        for (int i = 0; i < 41; ++i) {
            Assert.assertEquals((double)gnuValues[i], (double)Erf.erf((double)x), (double)1.0E-15);
            x += 0.5;
        }
    }

    @Test
    public void testErfcGnu() {
        double tol = 1.0E-15;
        double[] gnuValues = new double[]{2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 1.9999999999999927, 1.9999999999984626, 1.999999999803384, 1.999999984582742, 1.9999992569016276, 1.9999779095030015, 1.999593047982555, 1.9953222650189528, 1.9661051464753108, 1.8427007929497148, 1.5204998778130465, 1.0, 0.4795001221869535, 0.15729920705028513, 0.033894853524689274, 0.004677734981047266, 4.069520174449589E-4, 2.209049699858544E-5, 7.430983723414128E-7, 1.541725790028002E-8, 1.9661604415428876E-10, 1.537459794428035E-12, 7.357847917974398E-15, 2.1519736712498913E-17, 3.8421483271206475E-20, 4.183825607779414E-23, 2.776649386030569E-26, 1.1224297172982926E-29, 2.7623240713337716E-33, 4.13703174651381E-37, 3.7692144856548797E-41, 2.088487583762545E-45};
        double x = -10.0;
        for (int i = 0; i < 41; ++i) {
            Assert.assertEquals((double)gnuValues[i], (double)Erf.erfc((double)x), (double)1.0E-15);
            x += 0.5;
        }
    }

    @Test
    public void testErfcMaple() {
        double[][] ref = new double[][]{{0.1, 0.460172162722971}, {1.2, 0.115069670221708}, {2.3, 0.0107241100216758}, {3.4, 3.36929265676881E-4}, {4.5, 3.39767312473006E-6}, {5.6, 1.07175902583109E-8}, {6.7, 1.04209769879652E-11}, {7.8, 3.0953587719587E-15}, {8.9, 2.79233437493966E-19}, {10.0, 7.61985302416053E-24}, {11.1, 6.27219439321703E-29}, {12.2, 1.55411978638959E-34}, {13.3, 1.15734162836904E-40}, {14.4, 2.58717592540226E-47}, {15.5, 1.73446079179387E-54}, {16.6, 3.48454651995041E-62}};
        for (int i = 0; i < 15; ++i) {
            double result = 0.5 * Erf.erfc((double)(ref[i][0] / FastMath.sqrt((double)2.0)));
            Assert.assertEquals((double)ref[i][1], (double)result, (double)1.0E-15);
            TestUtils.assertRelativelyEquals(ref[i][1], result, 1.0E-13);
        }
    }

    @Test
    public void testTwoArgumentErf() {
        double[] xi;
        for (double x1 : xi = new double[]{-2.0, -1.0, -0.9, -0.1, 0.0, 0.1, 0.9, 1.0, 2.0}) {
            for (double x2 : xi) {
                double a = Erf.erf((double)x1, (double)x2);
                double b = Erf.erf((double)x2) - Erf.erf((double)x1);
                double c = Erf.erfc((double)x1) - Erf.erfc((double)x2);
                Assert.assertEquals((double)a, (double)b, (double)1.0E-15);
                Assert.assertEquals((double)a, (double)c, (double)1.0E-15);
            }
        }
    }

    @Test
    public void testErfInvNaN() {
        Assert.assertTrue((boolean)Double.isNaN(Erf.erfInv((double)-1.001)));
        Assert.assertTrue((boolean)Double.isNaN(Erf.erfInv((double)1.001)));
    }

    @Test
    public void testErfInvInfinite() {
        Assert.assertTrue((boolean)Double.isInfinite(Erf.erfInv((double)-1.0)));
        Assert.assertTrue((Erf.erfInv((double)-1.0) < 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Double.isInfinite(Erf.erfInv((double)1.0)));
        Assert.assertTrue((Erf.erfInv((double)1.0) > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testErfInv() {
        for (double x = -5.9; x < 5.9; x += 0.01) {
            double y = Erf.erf((double)x);
            double dydx = 2.0 * FastMath.exp((double)(-x * x)) / FastMath.sqrt((double)Math.PI);
            Assert.assertEquals((double)x, (double)Erf.erfInv((double)y), (double)(1.0E-15 / dydx));
        }
    }

    @Test
    public void testErfcInvNaN() {
        Assert.assertTrue((boolean)Double.isNaN(Erf.erfcInv((double)-0.001)));
        Assert.assertTrue((boolean)Double.isNaN(Erf.erfcInv((double)2.001)));
    }

    @Test
    public void testErfcInvInfinite() {
        Assert.assertTrue((boolean)Double.isInfinite(Erf.erfcInv((double)0.0)));
        Assert.assertTrue((Erf.erfcInv((double)0.0) > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Double.isInfinite(Erf.erfcInv((double)2.0)));
        Assert.assertTrue((Erf.erfcInv((double)2.0) < 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testErfcInv() {
        for (double x = -5.85; x < 5.9; x += 0.01) {
            double y = Erf.erfc((double)x);
            double dydxAbs = 2.0 * FastMath.exp((double)(-x * x)) / FastMath.sqrt((double)Math.PI);
            Assert.assertEquals((double)x, (double)Erf.erfcInv((double)y), (double)(1.0E-15 / dydxAbs));
        }
    }
}

