/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.random;

import com.hazelcast.shaded.org.apache.commons.math3.exception.OutOfRangeException;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.StableRandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.Well19937c;
import com.hazelcast.shaded.org.apache.commons.math3.stat.StatUtils;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.junit.Assert;
import org.junit.Test;

public class StableRandomGeneratorTest {
    private RandomGenerator rg = new Well19937c(100);
    private static final int sampleSize = 10000;

    @Test
    public void testNextDouble() {
        StableRandomGenerator generator = new StableRandomGenerator(this.rg, 1.3, 0.1);
        double[] sample = new double[20000];
        for (int i = 0; i < sample.length; ++i) {
            sample[i] = generator.nextNormalizedDouble();
        }
        Assert.assertEquals((double)0.0, (double)StatUtils.mean((double[])sample), (double)0.3);
    }

    @Test
    public void testGaussianCase() {
        StableRandomGenerator generator = new StableRandomGenerator(this.rg, 2.0, 0.0);
        double[] sample = new double[10000];
        for (int i = 0; i < sample.length; ++i) {
            sample[i] = generator.nextNormalizedDouble();
        }
        Assert.assertEquals((double)0.0, (double)StatUtils.mean((double[])sample), (double)0.02);
        Assert.assertEquals((double)1.0, (double)StatUtils.variance((double[])sample), (double)0.02);
    }

    @Test
    public void testCauchyCase() {
        StableRandomGenerator generator = new StableRandomGenerator(this.rg, 1.0, 0.0);
        DescriptiveStatistics summary = new DescriptiveStatistics();
        for (int i = 0; i < 10000; ++i) {
            double sample = generator.nextNormalizedDouble();
            summary.addValue(sample);
        }
        double median = summary.getPercentile(50.0);
        Assert.assertEquals((double)0.0, (double)median, (double)0.2);
    }

    @Test
    public void testAlphaRangeBelowZero() {
        try {
            new StableRandomGenerator(this.rg, -1.0, 0.0);
            Assert.fail((String)"Expected OutOfRangeException");
        }
        catch (OutOfRangeException e) {
            Assert.assertEquals((Object)-1.0, (Object)e.getArgument());
        }
    }

    @Test
    public void testAlphaRangeAboveTwo() {
        try {
            new StableRandomGenerator(this.rg, 3.0, 0.0);
            Assert.fail((String)"Expected OutOfRangeException");
        }
        catch (OutOfRangeException e) {
            Assert.assertEquals((Object)3.0, (Object)e.getArgument());
        }
    }

    @Test
    public void testBetaRangeBelowMinusOne() {
        try {
            new StableRandomGenerator(this.rg, 1.0, -2.0);
            Assert.fail((String)"Expected OutOfRangeException");
        }
        catch (OutOfRangeException e) {
            Assert.assertEquals((Object)-2.0, (Object)e.getArgument());
        }
    }

    @Test
    public void testBetaRangeAboveOne() {
        try {
            new StableRandomGenerator(this.rg, 1.0, 2.0);
            Assert.fail((String)"Expected OutOfRangeException");
        }
        catch (OutOfRangeException e) {
            Assert.assertEquals((Object)2.0, (Object)e.getArgument());
        }
    }
}

