/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.random;

import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NullArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.OutOfRangeException;
import com.hazelcast.shaded.org.apache.commons.math3.random.HaltonSequenceGenerator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HaltonSequenceGeneratorTest {
    private double[][] referenceValues = new double[][]{{0.0, 0.0, 0.0}, {0.5, 0.6667, 0.6}, {0.25, 0.3333, 0.2}, {0.75, 0.2223, 0.8}, {0.125, 0.8888, 0.4}, {0.625, 0.5555, 0.12}, {0.375, 0.1111, 0.72}, {0.875, 0.7777, 0.32}, {0.0625, 0.4444, 0.92}, {0.5625, 0.074, 0.52}};
    private double[][] referenceValuesUnscrambled = new double[][]{{0.0, 0.0}, {0.5, 0.3333}, {0.25, 0.6666}, {0.75, 0.1111}, {0.125, 0.4444}, {0.625, 0.7777}, {0.375, 0.2222}, {0.875, 0.5555}, {0.0625, 0.8888}, {0.5625, 0.037}};
    private HaltonSequenceGenerator generator;

    @Before
    public void setUp() {
        this.generator = new HaltonSequenceGenerator(3);
    }

    @Test
    public void test3DReference() {
        for (int i = 0; i < this.referenceValues.length; ++i) {
            double[] result = this.generator.nextVector();
            Assert.assertArrayEquals((double[])this.referenceValues[i], (double[])result, (double)0.001);
            Assert.assertEquals((long)(i + 1), (long)this.generator.getNextIndex());
        }
    }

    @Test
    public void test2DUnscrambledReference() {
        this.generator = new HaltonSequenceGenerator(2, new int[]{2, 3}, null);
        for (int i = 0; i < this.referenceValuesUnscrambled.length; ++i) {
            double[] result = this.generator.nextVector();
            Assert.assertArrayEquals((double[])this.referenceValuesUnscrambled[i], (double[])result, (double)0.001);
            Assert.assertEquals((long)(i + 1), (long)this.generator.getNextIndex());
        }
    }

    @Test
    public void testConstructor() {
        try {
            new HaltonSequenceGenerator(0);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            new HaltonSequenceGenerator(41);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testConstructor2() throws Exception {
        try {
            new HaltonSequenceGenerator(2, new int[]{1}, null);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            new HaltonSequenceGenerator(2, null, null);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            new HaltonSequenceGenerator(2, new int[]{1, 1}, new int[]{1});
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
    }

    @Test
    public void testSkip() {
        double[] result = this.generator.skipTo(5);
        Assert.assertArrayEquals((double[])this.referenceValues[5], (double[])result, (double)0.001);
        Assert.assertEquals((long)6L, (long)this.generator.getNextIndex());
        for (int i = 6; i < this.referenceValues.length; ++i) {
            result = this.generator.nextVector();
            Assert.assertArrayEquals((double[])this.referenceValues[i], (double[])result, (double)0.001);
            Assert.assertEquals((long)(i + 1), (long)this.generator.getNextIndex());
        }
    }
}

