/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.optimization.fitting;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.ParametricUnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.UniformRealDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.exception.ConvergenceException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.TooManyEvaluationsException;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.ConvergenceChecker;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.DifferentiableMultivariateVectorOptimizer;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.SimpleVectorValueChecker;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.fitting.CurveFitter;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.fitting.PolynomialFitter;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.general.GaussNewtonOptimizer;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.general.LevenbergMarquardtOptimizer;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class PolynomialFitterTest {
    @Test
    public void testFit() {
        UniformRealDistribution rng = new UniformRealDistribution(-100.0, 100.0);
        rng.reseedRandomGenerator(64925784252L);
        LevenbergMarquardtOptimizer optim = new LevenbergMarquardtOptimizer();
        PolynomialFitter fitter = new PolynomialFitter((DifferentiableMultivariateVectorOptimizer)optim);
        double[] coeff = new double[]{12.9, -3.4, 2.1};
        PolynomialFunction f = new PolynomialFunction(coeff);
        for (int i = 0; i < 100; ++i) {
            double x = rng.sample();
            fitter.addObservedPoint(x, f.value(x));
        }
        double[] best = fitter.fit(new double[]{-1.0E-20, 3.0E15, -5.0E25});
        TestUtils.assertEquals("best != coeff", coeff, best, 1.0E-12);
    }

    @Test
    public void testNoError() {
        Random randomizer = new Random(64925784252L);
        for (int degree = 1; degree < 10; ++degree) {
            PolynomialFunction p = this.buildRandomPolynomial(degree, randomizer);
            PolynomialFitter fitter = new PolynomialFitter((DifferentiableMultivariateVectorOptimizer)new LevenbergMarquardtOptimizer());
            for (int i = 0; i <= degree; ++i) {
                fitter.addObservedPoint(1.0, (double)i, p.value((double)i));
            }
            double[] init = new double[degree + 1];
            PolynomialFunction fitted = new PolynomialFunction(fitter.fit(init));
            for (double x = -1.0; x < 1.0; x += 0.01) {
                double error = FastMath.abs((double)(p.value(x) - fitted.value(x))) / (1.0 + FastMath.abs((double)p.value(x)));
                Assert.assertEquals((double)0.0, (double)error, (double)1.0E-6);
            }
        }
    }

    @Test
    public void testSmallError() {
        Random randomizer = new Random(53882150042L);
        double maxError = 0.0;
        for (int degree = 0; degree < 10; ++degree) {
            PolynomialFunction p = this.buildRandomPolynomial(degree, randomizer);
            PolynomialFitter fitter = new PolynomialFitter((DifferentiableMultivariateVectorOptimizer)new LevenbergMarquardtOptimizer());
            for (double x = -1.0; x < 1.0; x += 0.01) {
                fitter.addObservedPoint(1.0, x, p.value(x) + 0.1 * randomizer.nextGaussian());
            }
            double[] init = new double[degree + 1];
            PolynomialFunction fitted = new PolynomialFunction(fitter.fit(init));
            for (double x = -1.0; x < 1.0; x += 0.01) {
                double error = FastMath.abs((double)(p.value(x) - fitted.value(x))) / (1.0 + FastMath.abs((double)p.value(x)));
                maxError = FastMath.max((double)maxError, (double)error);
                Assert.assertTrue((FastMath.abs((double)error) < 0.1 ? 1 : 0) != 0);
            }
        }
        Assert.assertTrue((maxError > 0.01 ? 1 : 0) != 0);
    }

    @Test
    public void testMath798() {
        double tol = 1.0E-14;
        SimpleVectorValueChecker checker = new SimpleVectorValueChecker(1.0E-14, 1.0E-14);
        double[] init = new double[]{0.0, 0.0};
        int maxEval = 3;
        double[] lm = this.doMath798((DifferentiableMultivariateVectorOptimizer)new LevenbergMarquardtOptimizer((ConvergenceChecker)checker), 3, init);
        double[] gn = this.doMath798((DifferentiableMultivariateVectorOptimizer)new GaussNewtonOptimizer((ConvergenceChecker)checker), 3, init);
        for (int i = 0; i <= 1; ++i) {
            Assert.assertEquals((double)lm[i], (double)gn[i], (double)1.0E-14);
        }
    }

    @Test(expected=TooManyEvaluationsException.class)
    public void testMath798WithToleranceTooLow() {
        double tol = 1.0E-100;
        SimpleVectorValueChecker checker = new SimpleVectorValueChecker(1.0E-100, 1.0E-100);
        double[] init = new double[]{0.0, 0.0};
        int maxEval = 10000;
        this.doMath798((DifferentiableMultivariateVectorOptimizer)new GaussNewtonOptimizer((ConvergenceChecker)checker), 10000, init);
    }

    @Test
    public void testMath798WithToleranceTooLowButNoException() {
        double tol = 1.0E-100;
        double[] init = new double[]{0.0, 0.0};
        int maxEval = 10000;
        SimpleVectorValueChecker checker = new SimpleVectorValueChecker(1.0E-100, 1.0E-100, 10000);
        double[] lm = this.doMath798((DifferentiableMultivariateVectorOptimizer)new LevenbergMarquardtOptimizer((ConvergenceChecker)checker), 10000, init);
        double[] gn = this.doMath798((DifferentiableMultivariateVectorOptimizer)new GaussNewtonOptimizer((ConvergenceChecker)checker), 10000, init);
        for (int i = 0; i <= 1; ++i) {
            Assert.assertEquals((double)lm[i], (double)gn[i], (double)1.0E-15);
        }
    }

    private double[] doMath798(DifferentiableMultivariateVectorOptimizer optimizer, int maxEval, double[] init) {
        CurveFitter fitter = new CurveFitter(optimizer);
        fitter.addObservedPoint(-0.2, -7.12442E-13);
        fitter.addObservedPoint(-0.199, -4.33397E-13);
        fitter.addObservedPoint(-0.198, -2.823E-13);
        fitter.addObservedPoint(-0.197, -1.40405E-13);
        fitter.addObservedPoint(-0.196, -7.80821E-15);
        fitter.addObservedPoint(-0.195, 6.20484E-14);
        fitter.addObservedPoint(-0.194, 7.24673E-14);
        fitter.addObservedPoint(-0.193, 1.47152E-13);
        fitter.addObservedPoint(-0.192, 1.9629E-13);
        fitter.addObservedPoint(-0.191, 2.12038E-13);
        fitter.addObservedPoint(-0.19, 2.46906E-13);
        fitter.addObservedPoint(-0.189, 2.77495E-13);
        fitter.addObservedPoint(-0.188, 2.51281E-13);
        fitter.addObservedPoint(-0.187, 2.64001E-13);
        fitter.addObservedPoint(-0.186, 2.8882E-13);
        fitter.addObservedPoint(-0.185, 3.13604E-13);
        fitter.addObservedPoint(-0.184, 3.14248E-13);
        fitter.addObservedPoint(-0.183, 3.1172E-13);
        fitter.addObservedPoint(-0.182, 3.12912E-13);
        fitter.addObservedPoint(-0.181, 3.06761E-13);
        fitter.addObservedPoint(-0.18, 2.8559E-13);
        fitter.addObservedPoint(-0.179, 2.86806E-13);
        fitter.addObservedPoint(-0.178, 2.985E-13);
        fitter.addObservedPoint(-0.177, 2.67148E-13);
        fitter.addObservedPoint(-0.176, 2.94173E-13);
        fitter.addObservedPoint(-0.175, 3.27528E-13);
        fitter.addObservedPoint(-0.174, 3.33858E-13);
        fitter.addObservedPoint(-0.173, 2.97511E-13);
        fitter.addObservedPoint(-0.172, 2.8615E-13);
        fitter.addObservedPoint(-0.171, 2.84624E-13);
        double[] coeff = fitter.fit(maxEval, (ParametricUnivariateFunction)new PolynomialFunction.Parametric(), init);
        return coeff;
    }

    @Test
    public void testRedundantSolvable() {
        this.checkUnsolvableProblem((DifferentiableMultivariateVectorOptimizer)new LevenbergMarquardtOptimizer(), true);
    }

    @Test
    public void testRedundantUnsolvable() {
        this.checkUnsolvableProblem((DifferentiableMultivariateVectorOptimizer)new GaussNewtonOptimizer(true, (ConvergenceChecker)new SimpleVectorValueChecker(1.0E-15, 1.0E-15)), false);
    }

    @Test
    public void testLargeSample() {
        Random randomizer = new Random(6147774190404187803L);
        double maxError = 0.0;
        for (int degree = 0; degree < 10; ++degree) {
            PolynomialFunction p = this.buildRandomPolynomial(degree, randomizer);
            PolynomialFitter fitter = new PolynomialFitter((DifferentiableMultivariateVectorOptimizer)new LevenbergMarquardtOptimizer());
            for (int i = 0; i < 40000; ++i) {
                double x = -1.0 + (double)i / 20000.0;
                fitter.addObservedPoint(1.0, x, p.value(x) + 0.1 * randomizer.nextGaussian());
            }
            double[] init = new double[degree + 1];
            PolynomialFunction fitted = new PolynomialFunction(fitter.fit(init));
            for (double x = -1.0; x < 1.0; x += 0.01) {
                double error = FastMath.abs((double)(p.value(x) - fitted.value(x))) / (1.0 + FastMath.abs((double)p.value(x)));
                maxError = FastMath.max((double)maxError, (double)error);
                Assert.assertTrue((FastMath.abs((double)error) < 0.01 ? 1 : 0) != 0);
            }
        }
        Assert.assertTrue((maxError > 0.001 ? 1 : 0) != 0);
    }

    private void checkUnsolvableProblem(DifferentiableMultivariateVectorOptimizer optimizer, boolean solvable) {
        Random randomizer = new Random(1248788532L);
        for (int degree = 0; degree < 10; ++degree) {
            PolynomialFunction p = this.buildRandomPolynomial(degree, randomizer);
            PolynomialFitter fitter = new PolynomialFitter(optimizer);
            for (double x = -1.0; x < 1.0; x += 0.01) {
                fitter.addObservedPoint(1.0, 0.0, p.value(0.0));
            }
            try {
                double[] init = new double[degree + 1];
                fitter.fit(init);
                Assert.assertTrue((solvable || degree == 0 ? 1 : 0) != 0);
                continue;
            }
            catch (ConvergenceException e) {
                Assert.assertTrue((!solvable && degree > 0 ? 1 : 0) != 0);
            }
        }
    }

    private PolynomialFunction buildRandomPolynomial(int degree, Random randomizer) {
        double[] coefficients = new double[degree + 1];
        for (int i = 0; i <= degree; ++i) {
            coefficients[i] = randomizer.nextGaussian();
        }
        return new PolynomialFunction(coefficients);
    }
}

