/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.optimization;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.MultivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.ConvergenceChecker;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.GoalType;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.MultivariateMultiStartOptimizer;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.MultivariateOptimizer;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.PointValuePair;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.SimpleValueChecker;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.direct.AbstractSimplex;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.direct.NelderMeadSimplex;
import com.hazelcast.shaded.org.apache.commons.math3.optimization.direct.SimplexOptimizer;
import com.hazelcast.shaded.org.apache.commons.math3.random.GaussianRandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.JDKRandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.NormalizedRandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomVectorGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.UncorrelatedRandomVectorGenerator;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class MultivariateMultiStartOptimizerTest {
    @Test
    public void testRosenbrock() {
        Rosenbrock rosenbrock = new Rosenbrock();
        SimplexOptimizer underlying = new SimplexOptimizer((ConvergenceChecker)new SimpleValueChecker(-1.0, 0.001));
        NelderMeadSimplex simplex = new NelderMeadSimplex((double[][])new double[][]{{-1.2, 1.0}, {0.9, 1.2}, {3.5, -2.3}});
        underlying.setSimplex((AbstractSimplex)simplex);
        JDKRandomGenerator g = new JDKRandomGenerator();
        g.setSeed(16069223052L);
        UncorrelatedRandomVectorGenerator generator = new UncorrelatedRandomVectorGenerator(2, (NormalizedRandomGenerator)new GaussianRandomGenerator((RandomGenerator)g));
        MultivariateMultiStartOptimizer optimizer = new MultivariateMultiStartOptimizer((MultivariateOptimizer)underlying, 10, (RandomVectorGenerator)generator);
        PointValuePair optimum = optimizer.optimize(1100, (MultivariateFunction)rosenbrock, GoalType.MINIMIZE, new double[]{-1.2, 1.0});
        Assert.assertEquals((long)rosenbrock.getCount(), (long)optimizer.getEvaluations());
        Assert.assertTrue((optimizer.getEvaluations() > 900 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getEvaluations() < 1200 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)optimum.getValue() < 8.0E-4 ? 1 : 0) != 0);
    }

    private static class Rosenbrock
    implements MultivariateFunction {
        private int count = 0;

        public double value(double[] x) {
            ++this.count;
            double a = x[1] - x[0] * x[0];
            double b = 1.0 - x[0];
            return 100.0 * a * a + b * b;
        }

        public int getCount() {
            return this.count;
        }
    }
}

