/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.optim.nonlinear.vector.jacobian;

import com.hazelcast.shaded.org.apache.commons.math3.exception.ConvergenceException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathUnsupportedOperationException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.TooManyEvaluationsException;
import com.hazelcast.shaded.org.apache.commons.math3.optim.ConvergenceChecker;
import com.hazelcast.shaded.org.apache.commons.math3.optim.InitialGuess;
import com.hazelcast.shaded.org.apache.commons.math3.optim.MaxEval;
import com.hazelcast.shaded.org.apache.commons.math3.optim.OptimizationData;
import com.hazelcast.shaded.org.apache.commons.math3.optim.SimpleBounds;
import com.hazelcast.shaded.org.apache.commons.math3.optim.SimpleVectorValueChecker;
import com.hazelcast.shaded.org.apache.commons.math3.optim.nonlinear.vector.Target;
import com.hazelcast.shaded.org.apache.commons.math3.optim.nonlinear.vector.Weight;
import com.hazelcast.shaded.org.apache.commons.math3.optim.nonlinear.vector.jacobian.AbstractLeastSquaresOptimizer;
import com.hazelcast.shaded.org.apache.commons.math3.optim.nonlinear.vector.jacobian.AbstractLeastSquaresOptimizerAbstractTest;
import com.hazelcast.shaded.org.apache.commons.math3.optim.nonlinear.vector.jacobian.CircleVectorial;
import com.hazelcast.shaded.org.apache.commons.math3.optim.nonlinear.vector.jacobian.GaussNewtonOptimizer;
import java.io.IOException;
import org.junit.Test;

@Deprecated
public class GaussNewtonOptimizerTest
extends AbstractLeastSquaresOptimizerAbstractTest {
    public AbstractLeastSquaresOptimizer createOptimizer() {
        return new GaussNewtonOptimizer((ConvergenceChecker)new SimpleVectorValueChecker(1.0E-6, 1.0E-6));
    }

    @Test(expected=MathUnsupportedOperationException.class)
    public void testConstraintsUnsupported() {
        this.createOptimizer().optimize(new OptimizationData[]{new MaxEval(100), new Target(new double[]{2.0}), new Weight(new double[]{1.0}), new InitialGuess(new double[]{1.0, 2.0}), new SimpleBounds(new double[]{-10.0, 0.0}, new double[]{20.0, 30.0})});
    }

    @Test(expected=ConvergenceException.class)
    public void testMoreEstimatedParametersSimple() {
        super.testMoreEstimatedParametersSimple();
    }

    @Test(expected=ConvergenceException.class)
    public void testMoreEstimatedParametersUnsorted() {
        super.testMoreEstimatedParametersUnsorted();
    }

    @Test(expected=TooManyEvaluationsException.class)
    public void testMaxEvaluations() throws Exception {
        CircleVectorial circle = new CircleVectorial();
        circle.addPoint(30.0, 68.0);
        circle.addPoint(50.0, -6.0);
        circle.addPoint(110.0, -20.0);
        circle.addPoint(35.0, 15.0);
        circle.addPoint(45.0, 97.0);
        GaussNewtonOptimizer optimizer = new GaussNewtonOptimizer((ConvergenceChecker)new SimpleVectorValueChecker(1.0E-30, 1.0E-30));
        optimizer.optimize(new OptimizationData[]{new MaxEval(100), circle.getModelFunction(), circle.getModelFunctionJacobian(), new Target(new double[]{0.0, 0.0, 0.0, 0.0, 0.0}), new Weight(new double[]{1.0, 1.0, 1.0, 1.0, 1.0}), new InitialGuess(new double[]{98.68, 47.345})});
    }

    @Test(expected=ConvergenceException.class)
    public void testCircleFittingBadInit() {
        super.testCircleFittingBadInit();
    }

    @Test(expected=ConvergenceException.class)
    public void testHahn1() throws IOException {
        super.testHahn1();
    }
}

