/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ode.sampling;

import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MaxCountExceededException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NoBracketingException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FirstOrderIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblem3;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.DormandPrince54Integrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.sampling.FixedStepHandler;
import com.hazelcast.shaded.org.apache.commons.math3.ode.sampling.StepHandler;
import com.hazelcast.shaded.org.apache.commons.math3.ode.sampling.StepNormalizer;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StepNormalizerTest {
    TestProblem3 pb = null;
    FirstOrderIntegrator integ = null;
    boolean lastSeen;

    @Test
    public void testBoundaries() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double range = this.pb.getFinalTime() - this.pb.getInitialTime();
        this.setLastSeen(false);
        this.integ.addStepHandler((StepHandler)new StepNormalizer(range / 10.0, new FixedStepHandler(){
            private boolean firstCall = true;

            public void init(double t0, double[] y0, double t) {
            }

            public void handleStep(double t, double[] y, double[] yDot, boolean isLast) {
                if (this.firstCall) {
                    StepNormalizerTest.this.checkValue(t, StepNormalizerTest.this.pb.getInitialTime());
                    this.firstCall = false;
                }
                if (isLast) {
                    StepNormalizerTest.this.setLastSeen(true);
                    StepNormalizerTest.this.checkValue(t, StepNormalizerTest.this.pb.getFinalTime());
                }
            }
        }));
        this.integ.integrate((FirstOrderDifferentialEquations)this.pb, this.pb.getInitialTime(), this.pb.getInitialState(), this.pb.getFinalTime(), new double[this.pb.getDimension()]);
        Assert.assertTrue((boolean)this.lastSeen);
    }

    @Test
    public void testBeforeEnd() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        final double range = this.pb.getFinalTime() - this.pb.getInitialTime();
        this.setLastSeen(false);
        this.integ.addStepHandler((StepHandler)new StepNormalizer(range / 10.5, new FixedStepHandler(){

            public void init(double t0, double[] y0, double t) {
            }

            public void handleStep(double t, double[] y, double[] yDot, boolean isLast) {
                if (isLast) {
                    StepNormalizerTest.this.setLastSeen(true);
                    StepNormalizerTest.this.checkValue(t, StepNormalizerTest.this.pb.getFinalTime() - range / 21.0);
                }
            }
        }));
        this.integ.integrate((FirstOrderDifferentialEquations)this.pb, this.pb.getInitialTime(), this.pb.getInitialState(), this.pb.getFinalTime(), new double[this.pb.getDimension()]);
        Assert.assertTrue((boolean)this.lastSeen);
    }

    public void checkValue(double value, double reference) {
        Assert.assertTrue((FastMath.abs((double)(value - reference)) < 1.0E-10 ? 1 : 0) != 0);
    }

    public void setLastSeen(boolean lastSeen) {
        this.lastSeen = lastSeen;
    }

    @Before
    public void setUp() {
        this.pb = new TestProblem3(0.9);
        double minStep = 0.0;
        double maxStep = this.pb.getFinalTime() - this.pb.getInitialTime();
        this.integ = new DormandPrince54Integrator(minStep, maxStep, 1.0E-7, 1.0E-8);
        this.lastSeen = false;
    }

    @After
    public void tearDown() {
        this.pb = null;
        this.integ = null;
    }
}

